/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.client.gui.layer;

import com.mojang.blaze3d.systems.RenderSystem;
import it.hurts.octostudios.reliquified_twilight_forest.init.DataComponentRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.init.ItemRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.item.GemItem;
import it.hurts.octostudios.reliquified_twilight_forest.item.ability.LichCrownAbilities;
import it.hurts.octostudios.reliquified_twilight_forest.item.relic.LichCrownItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TwilightIndicatorLayer
implements LayeredDraw.Layer {
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LivingEntity living;
        LichCrownItem relic;
        Item item;
        Minecraft mc = Minecraft.getInstance();
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)mc.player, (Item)((Item)ItemRegistry.LICH_CROWN.get()));
        if (mc.player == null || !((item = stack.getItem()) instanceof LichCrownItem) || (relic = (LichCrownItem)item).getAbilityLevel(stack, "twilight") <= 0 || LichCrownAbilities.ClientEvents.getEntityLookingAt((Player)mc.player, 64.0) == null || !mc.options.getCameraType().isFirstPerson() || (item = mc.getCameraEntity()) instanceof LivingEntity && (living = (LivingEntity)item).isSleeping() || mc.options.hideGui || mc.player.isSpectator() || mc.crosshairPickEntity != null) {
            return;
        }
        float partialTick = (float)mc.player.tickCount + deltaTracker.getGameTimeDeltaPartialTick(true);
        float scale = 0.5f;
        float guiScale = (float)(Minecraft.getInstance().getWindow().getGuiScale() * (double)scale);
        float sin = (float)(Math.sin(partialTick / 2.0f) / 4.0 + 0.75);
        int itemX = guiGraphics.guiWidth();
        int itemY = guiGraphics.guiHeight();
        int scissorOffset = Math.round(Mth.map((float)((Integer)stack.getOrDefault(DataComponentRegistry.TWILIGHT_TIME, (Object)0)).intValue(), (float)0.0f, (float)50.0f, (float)0.0f, (float)(12.0f * guiScale)));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.pose().translate(0.0f, 0.0f, -150.0f);
        if (scissorOffset == 0) {
            RenderSystem.setShaderColor((float)(sin / 2.0f + 1.125f), (float)(sin / 2.0f + 1.125f), (float)(sin + 1.25f), (float)sin);
        }
        RenderSystem.enableScissor((int)((int)((float)itemX * guiScale)), (int)((int)((float)Minecraft.getInstance().getWindow().getScreenHeight() - (float)(14 + itemY) * guiScale)), (int)((int)(16.0f * guiScale)), (int)((int)(12.0f * guiScale - (float)scissorOffset)));
        guiGraphics.renderItem(((GemItem)ItemRegistry.TWILIGHT_GEM.get()).getDefaultInstance(), itemX, itemY);
        guiGraphics.pose().popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableScissor();
    }
}

