/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.entity;

import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HydraFirePuddleEntity
extends Entity
implements TraceableEntity {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(HydraFirePuddleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final ParticleOptions BORDER_PARTICLES = ParticleUtils.constructSimpleSpark((Color)new Color(255, 150, 0, 150), (float)0.25f, (int)10, (float)0.87f);
    public static final ParticleOptions INSIDE_PARTICLES = ParticleUtils.constructSimpleSpark((Color)new Color(175, 65, 0, 75), (float)0.4f, (int)30, (float)0.925f);
    private int lifetime = 200;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;

    public void setDamage(float damage) {
        this.getEntityData().set(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.getEntityData().get(DAMAGE)).floatValue();
    }

    public HydraFirePuddleEntity(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
    }

    public void setOwner(@Nullable Entity owner) {
        if (owner != null) {
            this.ownerUUID = owner.getUUID();
            this.cachedOwner = owner;
        }
    }

    @Nullable
    public Entity getOwner() {
        Level level;
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.cachedOwner = serverlevel.getEntity(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void tick() {
        int i;
        this.refreshDimensions();
        if (this.level().isClientSide) {
            Vec3 randomPos;
            float time = (float)(this.tickCount % 40) + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            for (int i2 = 0; i2 < 360; i2 += 20) {
                Vec3 direction = new Vec3(1.0, 0.0, 0.0).yRot((float)Math.toRadians((float)i2 + time * 2.0f));
                Vec3 pos = this.position().add(direction.scale((double)(this.getBbWidth() / 2.0f)));
                Vec3 randomPos2 = new Vec3(this.getRandomX(0.5), this.position().y, this.getRandomZ(0.5));
                this.level().addParticle(BORDER_PARTICLES, pos.x, pos.y + 0.05, pos.z, 0.0, 0.0, 0.0);
                if (i2 % 40 != 0 || !(randomPos2.distanceTo(this.position()) < (double)(this.getBbWidth() / 2.0f))) continue;
                this.level().addParticle(INSIDE_PARTICLES, randomPos2.x, randomPos2.y + 0.05, randomPos2.z, 0.0, 0.0, 0.0);
            }
            if (this.random.nextFloat() < 0.08f && (randomPos = new Vec3(this.getRandomX(0.5), this.position().y, this.getRandomZ(0.5))).distanceTo(this.position()) < (double)(this.getBbWidth() / 2.0f)) {
                this.level().addParticle((ParticleOptions)ParticleTypes.LAVA, randomPos.x, randomPos.y + 0.05, randomPos.z, 0.05, 0.05, 0.05);
            }
            return;
        }
        if (this.getLifetime() <= 0) {
            this.discard();
            return;
        }
        List<LivingEntity> toHurt = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.0, 0.1, 0.0)).stream().filter(entity -> !entity.equals((Object)this.getOwner()) && !EntityUtils.isAlliedTo((Entity)this.getOwner(), (Entity)entity) && entity.isAlive()).toList();
        toHurt.forEach(entity -> {
            entity.hurt(this.level().damageSources().source(DamageTypes.IN_FIRE, this.getOwner(), (Entity)this), this.getDamage());
            entity.setRemainingFireTicks(100);
        });
        if (this.isAlive() && (i = this.getLifetime()) > 0) {
            this.setLifetime(--i);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DAMAGE, (Object)Float.valueOf(1.0f));
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setLifetime(compound.getInt("lifetime"));
        this.setDamage(compound.getFloat("damage"));
        if (compound.hasUUID("Owner")) {
            this.ownerUUID = compound.getUUID("Owner");
            this.cachedOwner = null;
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("lifetime", this.getLifetime());
        compound.putFloat("damage", this.getDamage());
        if (this.ownerUUID != null) {
            compound.putUUID("Owner", this.ownerUUID);
        }
    }

    public EntityDimensions getDimensions(Pose pose) {
        return EntityDimensions.scalable((float)(4.0f + Mth.sin((float)((float)this.tickCount / 10.0f)) / 4.0f), (float)0.3f);
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }
}

