/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.item.relic;

import com.mojang.blaze3d.shaders.FogShape;
import it.hurts.octostudios.reliquified_twilight_forest.api.OreCache;
import it.hurts.octostudios.reliquified_twilight_forest.data.loot.LootEntries;
import it.hurts.octostudios.reliquified_twilight_forest.init.ConfigRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.init.ItemRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.item.BundleLikeRelicItem;
import it.hurts.octostudios.reliquified_twilight_forest.network.UpdateChunkPacket;
import it.hurts.octostudios.reliquified_twilight_forest.util.MathButCool;
import it.hurts.sskirillss.relics.client.particles.BasicColoredParticle;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.SlotContext;

public class GoblinNoseItem
extends BundleLikeRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"vein_seeker").stat(StatData.builder((String)"radius").initialValue(4.0, 8.0).upgradeModifier(UpgradeOperation.ADD, 1.6).formatValue(MathButCool::roundSingleDigit).build()).stat(StatData.builder((String)"filter_slots").initialValue(0.0, 0.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(Math::round).build()).active(CastData.builder().type(CastType.TOGGLEABLE).build()).maxLevel(5).build()).build()).leveling(LevelingData.builder().sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"vein_seeker").gem(GemShape.SQUARE, GemColor.GREEN).build()).build()).maxLevel(5).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.TROLL}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        GoblinNoseItem relic;
        LivingEntity livingEntity = slotContext.entity();
        Item item = stack.getItem();
        if (!(item instanceof GoblinNoseItem) || !(relic = (GoblinNoseItem)item).isAbilityTicking(stack, "vein_seeker")) {
            return;
        }
        if (!livingEntity.level().isClientSide) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 30, 0, true, false, false));
        }
        if (livingEntity.level().isClientSide && livingEntity == Minecraft.getInstance().player) {
            List<BlockPos> ORES = OreCache.getNearbyOres(livingEntity.level(), livingEntity.blockPosition(), (float)relic.getStatValue(stack, "vein_seeker", "radius"));
            ORES.forEach(bp -> {
                BlockState state = livingEntity.level().getBlockState(bp);
                if (livingEntity.getRandom().nextFloat() < 0.66f || !state.is(Tags.Blocks.ORES) || !relic.getContents(stack).isEmpty() && relic.getItemCount(stack, state.getBlock().asItem()) < 1) {
                    return;
                }
                GoblinNoseItem.spawnOreParticles(livingEntity, bp);
            });
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (!ConfigRegistry.GENERAL.isEnabledOreScanner()) {
            tooltipComponents.add((Component)Component.literal((String)" "));
            tooltipComponents.add((Component)Component.literal((String)"Temporarily disabled due to a technical issue!").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.DARK_RED));
        }
    }

    @Override
    public int getMaxSlots(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof GoblinNoseItem)) {
            return 0;
        }
        GoblinNoseItem relic = (GoblinNoseItem)item;
        return (int)Math.round(relic.getStatValue(stack, "vein_seeker", "filter_slots"));
    }

    public static void spawnOreParticles(LivingEntity livingEntity, BlockPos pos) {
        AABB area = new AABB(pos.getCenter(), pos.getCenter()).inflate(0.5);
        Random random = new Random();
        Level level = livingEntity.level();
        BasicColoredParticle.Options ORE_PARTICLE = new BasicColoredParticle.Options(BasicColoredParticle.Constructor.builder().color(new Color(random.nextInt(230, 255), random.nextInt(170, 255), 0, 255).getRGB()).diameter(random.nextFloat(0.2f, 0.35f)).lifetime(20).scaleModifier(0.8f).physical(false).visibleThroughWalls(true).roll(0.15f).build());
        level.addParticle((ParticleOptions)ORE_PARTICLE, true, random.nextDouble(area.minX, area.maxX), random.nextDouble(area.minY, area.maxY), random.nextDouble(area.minZ, area.maxZ), 0.0, 0.0, 0.0);
        if (random.nextFloat() < 0.1f && livingEntity.tickCount % 4 == 0) {
            ORE_PARTICLE = new BasicColoredParticle.Options(BasicColoredParticle.Constructor.builder().color(new Color(255, 255, 255, 255).getRGB()).diameter(0.4f).lifetime(60).scaleModifier(0.95f).physical(false).visibleThroughWalls(true).roll(0.25f).build());
            level.addParticle((ParticleOptions)ORE_PARTICLE, true, random.nextDouble(area.minX, area.maxX), random.nextDouble(area.minY, area.maxY), random.nextDouble(area.minZ, area.maxZ), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void playInsertSound(Player player, ItemStack toInsert) {
        player.playSound(SoundEvents.AMETHYST_BLOCK_PLACE, 0.8f, 1.25f);
    }

    @Override
    public Predicate<ItemStack> getPredicate() {
        return stack -> {
            BlockItem blockItem;
            Item patt0$temp = stack.getItem();
            return patt0$temp instanceof BlockItem && (blockItem = (BlockItem)patt0$temp).getBlock().defaultBlockState().is(Tags.Blocks.ORES);
        };
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void changeFog(ViewportEvent.RenderFog event) {
            Item inst;
            GoblinNoseItem relic;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)Minecraft.getInstance().player, (Item)((Item)ItemRegistry.GOBLIN_NOSE.get()));
            Item item = stack.getItem();
            if (!(item instanceof GoblinNoseItem && (relic = (GoblinNoseItem)item).isAbilityTicking(stack, "vein_seeker") && (item = Minecraft.getInstance().player.getEffect(MobEffects.DARKNESS)) instanceof MobEffectInstance && (inst = item).getDuration() <= 30)) {
                return;
            }
            float newDistance = (float)relic.getStatValue(stack, "vein_seeker", "radius");
            event.scaleNearPlaneDistance(newDistance / 15.0f);
            event.scaleFarPlaneDistance(newDistance / 15.0f);
            event.setFogShape(FogShape.SPHERE);
            event.setCanceled(true);
        }
    }

    @EventBusSubscriber
    public static class CommonEvents {
        @SubscribeEvent
        public static void onChunkLoad(ChunkEvent.Load event) {
            if (!event.getLevel().isClientSide()) {
                return;
            }
            if (ConfigRegistry.GENERAL.isEnabledOreScanner()) {
                ChunkAccess chunk = event.getChunk();
                OreCache.scanChunkAsync(event.getLevel(), chunk);
            }
        }

        @SubscribeEvent
        public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
            if (event.getLevel().isClientSide()) {
                return;
            }
            if (ConfigRegistry.GENERAL.isEnabledOreScanner()) {
                ChunkAccess chunk = event.getLevel().getChunk(event.getPos());
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)event.getLevel()), (ChunkPos)chunk.getPos(), (CustomPacketPayload)new UpdateChunkPacket(chunk.getPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        @SubscribeEvent
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            GoblinNoseItem relic;
            Item item;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)event.getPlayer(), (Item)((Item)ItemRegistry.GOBLIN_NOSE.get()));
            if (event.getLevel().isClientSide()) {
                return;
            }
            if (ConfigRegistry.GENERAL.isEnabledOreScanner()) {
                ChunkAccess chunk = event.getLevel().getChunk(event.getPos());
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)event.getLevel()), (ChunkPos)chunk.getPos(), (CustomPacketPayload)new UpdateChunkPacket(chunk.getPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if ((item = stack.getItem()) instanceof GoblinNoseItem && (relic = (GoblinNoseItem)item).isAbilityTicking(stack, "vein_seeker") && event.getState().is(Tags.Blocks.ORES)) {
                relic.spreadRelicExperience((LivingEntity)event.getPlayer(), stack, 1);
            }
        }

        @SubscribeEvent
        public static void onChunkUnload(ChunkEvent.Unload event) {
            if (!event.getLevel().isClientSide()) {
                return;
            }
            if (ConfigRegistry.GENERAL.isEnabledOreScanner()) {
                ChunkAccess chunk = event.getChunk();
                OreCache.removeChunk(chunk.getPos());
            }
        }
    }
}

