/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.world.level.block;

import fuzs.easyanvils.init.ModRegistry;
import fuzs.easyanvils.world.level.block.entity.AnvilBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class AnvilWithInventoryBlock
extends AnvilBlock
implements EntityBlock {
    private final Block block;

    public AnvilWithInventoryBlock(Block block) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block).dropsLike(block));
        this.block = block;
    }

    public String getDescriptionId() {
        return this.block.getDescriptionId();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AnvilBlockEntity) {
            AnvilBlockEntity blockEntity2 = (AnvilBlockEntity)blockEntity;
            player.openMenu((MenuProvider)blockEntity2);
            player.awardStat(Stats.INTERACT_WITH_ANVIL);
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)blockEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModRegistry.ANVIL_BLOCK_ENTITY_TYPE.value()).create(pos, state);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }
}

