/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.georenouveau.compat.jei.category;

import com.shynieke.georenouveau.compat.jei.JEIPlugin;
import com.shynieke.georenouveau.compat.jei.wrapper.ConversionWrapper;
import com.shynieke.georenouveau.registry.CompatRegistry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConversionCategory
implements IRecipeCategory<ConversionWrapper> {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final Component localizedName;

    public ConversionCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(120, 24);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)CompatRegistry.COAL_GEORE_GOLEM_CHARM.asItem().getDefaultInstance());
        this.arrow = guiHelper.createAnimatedRecipeArrow(40);
        this.localizedName = Component.translatable((String)"georenouveau.gui.jei.category.conversion");
    }

    public RecipeType<ConversionWrapper> getRecipeType() {
        return JEIPlugin.CONVERSION_TYPE;
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ConversionWrapper wrapper, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 98, 4).addItemLike((ItemLike)wrapper.linked().getBudding());
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 4).addItemLike((ItemLike)wrapper.linked().getBlock());
    }

    public void draw(ConversionWrapper wrapper, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 48, 5);
        if (mouseX >= 48.0 && mouseX <= (double)(48 + this.arrow.getWidth()) && mouseY >= 5.0 && mouseY <= (double)(5 + this.arrow.getHeight())) {
            Object formattedName = wrapper.linked().name;
            formattedName = ((String)formattedName).replace("_", " ");
            formattedName = Character.toUpperCase(((String)formattedName).charAt(0)) + ((String)formattedName).substring(1);
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)"georenouveau.gui.jei.category.conversion.required", (Object[])new Object[]{formattedName}).withStyle(ChatFormatting.YELLOW), (int)mouseX, (int)mouseY);
        }
    }
}

