/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.data;

import guideme.internal.GuideME;
import guideme.internal.GuidebookText;
import guideme.internal.data.LocalizationEnum;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;

public final class GuideMELanguageProvider
extends LanguageProvider {
    public GuideMELanguageProvider(PackOutput gen) {
        super(gen, "guideme", "en_us");
    }

    protected void addTranslations() {
        this.addEnum(GuidebookText.class);
        this.addItem(GuideME.GUIDE_ITEM, "Guide");
        this.add("key.guideme.category", "GuideME");
        this.add("key.guideme.guide", "Open Guide for Items");
        this.addConfigTranslations();
    }

    private void addConfigTranslations() {
        Map<String, String> translations = Map.of("guide", "Guides", "ignoreTranslatedGuides", "Ignore Guide Translations", "ignoreTranslatedGuides.tooltip", "Always load the original version of GuideME guides, regardless of the currently selected UI language", "title", "GuideME Configuration", "gui", "User Interface", "debug", "Debug", "debug.tooltip", "Advanced Debugging Settings for Guide development", "adaptiveScaling", "Adaptive UI Scaling", "fullWidthLayout", "Full Width Layout", "showDebugGuiOverlays", "Debug GUI Overlays");
        for (Map.Entry<String, String> entry : translations.entrySet()) {
            this.add("guideme.configuration." + entry.getKey(), entry.getValue());
        }
    }

    public <T extends Enum<T>> void addEnum(Class<T> localizedEnum) {
        for (Enum enumConstant : (Enum[])localizedEnum.getEnumConstants()) {
            this.add(((LocalizationEnum)((Object)enumConstant)).getTranslationKey(), ((LocalizationEnum)((Object)enumConstant)).getEnglishText());
        }
    }

    public String getName() {
        return "GuideME Translations";
    }
}

