/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.ars_hex.hexerei.broom;

import com.alexthw.ars_hex.ArsHex;
import com.alexthw.ars_hex.hexerei.HexereiModels;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.ArrayList;
import java.util.List;
import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.joefoxe.hexerei.item.custom.BroomBrushItem;
import net.joefoxe.hexerei.particle.ModParticleTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MagebloomBrush
extends BroomBrushItem {
    public MagebloomBrush(Item.Properties properties) {
        super(properties);
    }

    public void onBrushDamage(BroomEntity broom, RandomSource random) {
        ItemStack brush = broom.getModule(BroomEntity.BroomSlot.BRUSH);
        Entity entity = broom.getFirstPassenger();
        if (entity instanceof Player) {
            ManaCap mana;
            Player player = (Player)entity;
            if (!brush.isEmpty() && brush.getDamageValue() >= 2 && (mana = CapabilityRegistry.getMana((LivingEntity)player)) != null && mana.getCurrentMana() >= 200.0) {
                mana.removeMana(200.0);
                brush.setDamageValue(brush.getDamageValue() - 2);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void bakeModels() {
        EntityModelSet context = Minecraft.getInstance().getEntityModels();
        this.model = new HexereiModels.MagebloomBrush(context.bakeLayer(HexereiModels.MagebloomBrush.LAYER_LOCATION));
        this.texture = ArsHex.prefix("textures/entity/archwood_broom.png");
        this.dye_texture = null;
        this.list = new ArrayList();
        this.list.add(new Tuple((Object)GlowParticleData.createData((ParticleColor)ParticleColor.defaultParticleColor(), (float)0.3f, (float)0.6f, (int)40), (Object)5));
        this.list.add(new Tuple((Object)GlowParticleData.createData((ParticleColor)ParticleColor.defaultParticleColor(), (float)0.2f, (float)0.4f, (int)20), (Object)2));
        this.list.add(new Tuple((Object)((ParticleOptions)ModParticleTypes.BROOM.get()), (Object)8));
        this.list.add(new Tuple((Object)((ParticleOptions)ModParticleTypes.BROOM_2.get()), (Object)50));
        this.list.add(new Tuple((Object)((ParticleOptions)ModParticleTypes.BROOM_3.get()), (Object)50));
        this.list.add(new Tuple((Object)((ParticleOptions)ModParticleTypes.BROOM_4.get()), (Object)50));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)"tooltip.hexerei.broom_attachments").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        tooltip.add((Component)Component.translatable((String)"tooltip.ars_hex.magebloom_brush").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    public boolean shouldGlow(@Nullable Level level, ItemStack brushStack) {
        return brushStack.getDamageValue() < 10;
    }
}

