/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.BlockIngredient;
import es.degrassi.mmreborn.api.PartialBlockState;
import es.degrassi.mmreborn.api.Pattern;
import es.degrassi.mmreborn.api.codec.DefaultCodecs;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.common.crafting.modifier.ModifierReplacement;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.data.MMRTags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Structure {
    public static final NamedCodec<Structure> CODEC = NamedCodec.record(structure -> structure.group(NamedCodec.STRING.listOf().listOf().fieldOf("pattern").forGetter(s -> s.pattern.asList()), NamedCodec.unboundedMap(DefaultCodecs.CHARACTER, BlockIngredient.CODEC, "Map<Character, Block>").fieldOf("keys").forGetter(s -> s.pattern.asMap()), ModifierReplacement.CODEC.listOf().optionalFieldOf("modifiers", List.of()).forGetter(s -> s.pattern.getModifiers())).apply((Applicative)structure, Structure::makeStructure), "Structure with modifiers");
    public static final Structure EMPTY = new Structure(Map.of(), List.of(List.of("m")), Map.of(), List.of());
    private static final RandomSource random = RandomSource.create((long)42L);
    private final Pattern pattern;

    private static Structure makeStructure(List<List<String>> pattern, Map<Character, BlockIngredient> keys, List<ModifierReplacement> modifiers) {
        Builder builder = Builder.start();
        for (List<String> list : pattern) {
            builder.aisle(list.toArray(new String[0]));
        }
        for (Map.Entry entry : keys.entrySet()) {
            builder.where(((Character)entry.getKey()).charValue(), (BlockIngredient)entry.getValue());
        }
        return builder.build(pattern, keys, modifiers);
    }

    public static void place(DynamicMachine machine, BlockPos controllerPos, Level level, boolean isCreative, ServerPlayer player, boolean withModifiers) {
        Structure structure = machine.getPattern();
        BlockState blockState = level.getBlockState(controllerPos);
        Direction facing = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Map<BlockPos, BlockIngredient> blocks = withModifiers ? structure.getBlocks(facing) : structure.getBlocksFiltered(facing);
        BlockPos.MutableBlockPos worldPos = new BlockPos.MutableBlockPos();
        block0: for (BlockPos pos : blocks.keySet()) {
            BlockInWorld info;
            BlockIngredient ingredient = blocks.get(pos);
            if (ingredient.equals(BlockIngredient.AIR) || ingredient.equals(BlockIngredient.ANY)) continue;
            if (ingredient.getAll().stream().anyMatch(state -> state.equals(PartialBlockState.AIR) || state.equals(PartialBlockState.ANY) || state.getBlockState().isAir())) {
                ingredient = new BlockIngredient(ingredient.getTags(), ingredient.uniqueStates().filter(state -> !state.equals(PartialBlockState.AIR) && !state.equals(PartialBlockState.ANY) && !state.getBlockState().isAir()).toList());
            }
            if (ingredient.getAll().isEmpty()) continue;
            worldPos.set(pos.getX() + controllerPos.getX(), pos.getY() + controllerPos.getY(), pos.getZ() + controllerPos.getZ());
            BlockInWorld finalInfo = info = new BlockInWorld((LevelReader)level, (BlockPos)worldPos, false);
            if (!info.getState().isAir() && ingredient.getAll().stream().noneMatch(state -> state.test(finalInfo))) {
                if (isCreative) {
                    level.destroyBlock((BlockPos)worldPos, false);
                } else if (((Boolean)MMRConfig.get().shouldReplace.get()).booleanValue()) {
                    if (finalInfo.getState().is(MMRTags.Blocks.REPLACEABLE)) {
                        level.destroyBlock((BlockPos)worldPos, true);
                        if (((Boolean)MMRConfig.get().sendReplaceMessage.get()).booleanValue()) {
                            player.sendSystemMessage((Component)Component.translatable((String)"mmr.place.replace", (Object[])new Object[]{finalInfo.getState().getBlock().getName(), "X:" + worldPos.getX() + " Y:" + worldPos.getY() + " Z:" + worldPos.getZ()}));
                        }
                        info = new BlockInWorld((LevelReader)level, (BlockPos)worldPos, false);
                    }
                } else if (((Boolean)MMRConfig.get().sendErrorMessage.get()).booleanValue()) {
                    player.sendSystemMessage((Component)Component.translatable((String)"mmr.place.non_air", (Object[])new Object[]{finalInfo.getState().getBlock().getName(), "X:" + worldPos.getX() + " Y:" + worldPos.getY() + " Z:" + worldPos.getZ()}));
                }
            }
            if (!isCreative) {
                boolean placed = false;
                if (!info.getState().isAir() && (!((Boolean)MMRConfig.get().shouldReplace.get()).booleanValue() || !level.getBlockState((BlockPos)worldPos).is(MMRTags.Blocks.REPLACEABLE))) continue;
                for (PartialBlockState state2 : ingredient.getAll()) {
                    if (state2.equals(PartialBlockState.AIR) || state2.equals(PartialBlockState.ANY)) continue block0;
                    ItemStack blockToRemove2 = new ItemStack((ItemLike)state2.getBlockState().getBlock());
                    if (!player.getInventory().contains(blockToRemove2)) continue;
                    int slot = player.getInventory().findSlotMatchingItem(blockToRemove2);
                    player.getInventory().removeItem(slot, 1);
                    player.containerMenu.broadcastChanges();
                    player.inventoryMenu.slotsChanged((Container)player.getInventory());
                    Structure.setBlock(level, (BlockPos)worldPos, state2);
                    placed = true;
                    break;
                }
                if (placed || !((Boolean)MMRConfig.get().sendErrorMessage.get()).booleanValue()) continue;
                player.sendSystemMessage((Component)Component.translatable((String)"mmr.place.no_item", (Object[])new Object[]{ingredient.getString(), "X:" + worldPos.getX() + " Y:" + worldPos.getY() + " Z:" + worldPos.getZ(), ingredient.getString()}));
                continue;
            }
            if (worldPos.equals((Object)controllerPos)) continue;
            Structure.setBlock(level, (BlockPos)worldPos, ingredient.getAll().get(random.nextInt(0, ingredient.getAll().size())));
        }
    }

    public static void breakStructure(DynamicMachine machine, BlockPos controllerPos, Level level, ServerPlayer player) {
        boolean isCreative = player.isCreative();
        Direction direction = (Direction)level.getBlockState(controllerPos).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Map<BlockPos, BlockIngredient> blocks = machine.getPattern().getBlocks(direction);
        BlockPos.MutableBlockPos worldPos = new BlockPos.MutableBlockPos();
        for (BlockPos pos : blocks.keySet()) {
            BlockIngredient ingredient = blocks.get(pos);
            worldPos.set(pos.getX() + controllerPos.getX(), pos.getY() + controllerPos.getY(), pos.getZ() + controllerPos.getZ());
            BlockInWorld info = new BlockInWorld((LevelReader)level, (BlockPos)worldPos, false);
            if (info.getState().isAir() || info.getEntity() instanceof MachineControllerEntity || ingredient.getAll().stream().noneMatch(state -> state.test(info))) continue;
            level.destroyBlock(worldPos.immutable(), !isCreative);
        }
    }

    private static void setBlock(Level world, BlockPos pos, PartialBlockState state) {
        world.setBlockAndUpdate(pos, state.getBlockState());
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile != null && state.getNbt() != null && !state.getNbt().isEmpty()) {
            CompoundTag nbt = state.getNbt().copy();
            nbt.putInt("x", pos.getX());
            nbt.putInt("y", pos.getY());
            nbt.putInt("z", pos.getZ());
            tile.loadWithComponents(nbt, (HolderLookup.Provider)world.registryAccess());
        }
    }

    public Structure(Map<BlockPos, BlockIngredient> blocks, List<List<String>> pattern, Map<Character, BlockIngredient> keys, List<ModifierReplacement> modifiers) {
        this.pattern = new Pattern(blocks, pattern, keys, modifiers);
    }

    public Map<BlockPos, BlockIngredient> getBlocks(Direction direction) {
        return this.pattern.get(direction);
    }

    public Map<BlockPos, BlockIngredient> getBlocksFiltered(Direction direction) {
        return this.pattern.getFiltered(direction);
    }

    public boolean match(LevelReader world, BlockPos machinePos, Direction machineFacing) {
        return this.pattern.match(world, machinePos, machineFacing);
    }

    public JsonObject asJson() {
        JsonObject json = new JsonObject();
        json.add("pattern", (JsonElement)this.pattern.asJson());
        return json;
    }

    public String toString() {
        return this.asJson().toString();
    }

    @Generated
    public Pattern getPattern() {
        return this.pattern;
    }

    public static class Builder {
        private static final Joiner COMMA_JOIN = Joiner.on((String)",");
        private final List<String[]> depth = Lists.newArrayList();
        private final Map<Character, BlockIngredient> symbolMap = Maps.newHashMap();
        private int aisleHeight;
        private int rowWidth;

        private Builder() {
            this.symbolMap.put(Character.valueOf(' '), BlockIngredient.ANY);
            this.symbolMap.put(Character.valueOf('m'), BlockIngredient.MACHINE);
            this.symbolMap.put(Character.valueOf('_'), BlockIngredient.NOT_MACHINE);
        }

        public Builder aisle(String ... aisle) {
            if (!ArrayUtils.isEmpty((Object[])aisle) && !StringUtils.isEmpty((CharSequence)aisle[0])) {
                if (this.depth.isEmpty()) {
                    this.aisleHeight = aisle.length;
                    this.rowWidth = aisle[0].length();
                }
                if (aisle.length != this.aisleHeight) {
                    throw new IllegalArgumentException("Expected aisle with height of " + this.aisleHeight + ", but was given one with a height of " + aisle.length + ")");
                }
                for (String s : aisle) {
                    if (s.length() != this.rowWidth) {
                        throw new IllegalArgumentException("Not all rows in the given aisle are the correct width (expected " + this.rowWidth + ", found one with " + s.length() + ")");
                    }
                    for (char c0 : s.toCharArray()) {
                        if (this.symbolMap.containsKey(Character.valueOf(c0))) continue;
                        this.symbolMap.put(Character.valueOf(c0), null);
                    }
                }
                this.depth.add(aisle);
                return this;
            }
            throw new IllegalArgumentException("Empty pattern for aisle");
        }

        public static Builder start() {
            return new Builder();
        }

        public Builder where(char symbol, BlockIngredient blockMatcher) {
            this.symbolMap.put(Character.valueOf(symbol), blockMatcher);
            return this;
        }

        public Structure build(List<List<String>> pattern, Map<Character, BlockIngredient> keys, List<ModifierReplacement> modifiers) {
            this.checkMissingPredicates();
            BlockPos machinePos = this.getMachinePos();
            HashMap blocks = Maps.newHashMap();
            for (int i = 0; i < this.depth.size(); ++i) {
                for (int j = 0; j < this.aisleHeight; ++j) {
                    for (int k = 0; k < this.rowWidth; ++k) {
                        blocks.put(new BlockPos(k - machinePos.getX(), i - machinePos.getY(), j - machinePos.getZ()), this.symbolMap.get(Character.valueOf(this.depth.get(i)[j].charAt(k))));
                    }
                }
            }
            return new Structure(blocks, pattern, keys, modifiers);
        }

        private BlockPos getMachinePos() {
            BlockPos machinePos = null;
            for (int i = 0; i < this.depth.size(); ++i) {
                for (int j = 0; j < this.aisleHeight; ++j) {
                    for (int k = 0; k < this.rowWidth; ++k) {
                        if (this.depth.get(i)[j].charAt(k) != 'm') continue;
                        if (machinePos == null) {
                            machinePos = new BlockPos(k, i, j);
                            continue;
                        }
                        throw new IllegalStateException("The structure pattern need exactly one 'm' character to defined the machine position, several found !");
                    }
                }
            }
            if (machinePos != null) {
                return machinePos;
            }
            throw new IllegalStateException("You need to define the machine position in the structure with character 'm'");
        }

        private void checkMissingPredicates() {
            ArrayList list = Lists.newArrayList();
            for (Map.Entry<Character, BlockIngredient> entry : this.symbolMap.entrySet()) {
                if (entry.getValue() != null) continue;
                list.add(entry.getKey());
            }
            if (!list.isEmpty()) {
                throw new IllegalStateException("Blocks for character(s) " + COMMA_JOIN.join((Iterable)list) + " are missing");
            }
        }

        public JsonObject asJson() {
            JsonObject json = new JsonObject();
            json.addProperty("aisleHeight", (Number)this.aisleHeight);
            json.addProperty("rowWidth", (Number)this.rowWidth);
            JsonArray depth = new JsonArray();
            this.depth.forEach(array -> {
                JsonArray newOne = new JsonArray();
                Arrays.asList(array).forEach(arg_0 -> ((JsonArray)newOne).add(arg_0));
                depth.add((JsonElement)newOne);
            });
            json.add("depth", (JsonElement)depth);
            JsonObject symbols = new JsonObject();
            this.symbolMap.forEach((key, value) -> symbols.add(String.valueOf(key), (JsonElement)value.asJson()));
            json.add("symbolMap", (JsonElement)symbols);
            return json;
        }

        public String toString() {
            return this.asJson().toString();
        }
    }
}

