/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.codec.DefaultCodecs;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.crafting.IProcessor;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.network.DataType;
import es.degrassi.mmreborn.api.network.IData;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.MachineHatchType;
import es.degrassi.mmreborn.common.manager.crafting.ProcessorType;
import es.degrassi.mmreborn.common.util.EmptyRequirementType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class RegistrarCodec<V>
implements NamedCodec<V> {
    public static final NamedCodec<Item> ITEM = RegistrarCodec.of(BuiltInRegistries.ITEM, false);
    public static final NamedCodec<Block> BLOCK = RegistrarCodec.of(BuiltInRegistries.BLOCK, false);
    public static final NamedCodec<Fluid> FLUID = RegistrarCodec.of(BuiltInRegistries.FLUID, false);
    public static final NamedCodec<EntityType<?>> ENTITY = RegistrarCodec.of(BuiltInRegistries.ENTITY_TYPE, false);
    public static final NamedCodec<MobEffect> EFFECT = RegistrarCodec.of(BuiltInRegistries.MOB_EFFECT, false);
    public static final NamedCodec<RequirementType<? extends IRequirement<?>>> REQUIREMENT_NEW = RegistrarCodec.of(ModularMachineryReborn.getRequirementRegistrar(), true);
    public static final NamedCodec<ComponentType> COMPONENT = RegistrarCodec.of(ModularMachineryReborn.getComponentRegistrar(), true);
    public static final NamedCodec<EmptyRequirementType> EMPTY_REQUIREMENT_TYPE = RegistrarCodec.of(ModularMachineryReborn.getEmptyRequirementTypeRegistrar(), true);
    public static final NamedCodec<MachineHatchType> HATCH_TYPE = RegistrarCodec.of(ModularMachineryReborn.getMachineHatchTypeRegistrar(), true);
    public static final NamedCodec<DataType<? extends IData<?>, ?>> DATA = RegistrarCodec.of(ModularMachineryReborn.dataRegistrar(), true);
    public static final NamedCodec<ProcessorType<? extends IProcessor>> CRAFTING_PROCESSOR = RegistrarCodec.of(ModularMachineryReborn.processorRegistrar(), true);
    public static final NamedCodec<ResourceLocation> MMR_LOC_CODEC = NamedCodec.STRING.comapFlatMap(s -> {
        try {
            if (s.contains(":")) {
                return DataResult.success((Object)ResourceLocation.tryParse((String)s));
            }
            return DataResult.success((Object)ModularMachineryReborn.rl(s));
        }
        catch (Exception e) {
            return DataResult.error(e::getMessage);
        }
    }, ResourceLocation::toString, "MMR Resource location");
    private final Registry<V> registrar;
    private final boolean isMMR;

    public static <V> RegistrarCodec<V> of(Registry<V> registrar, boolean isMMR) {
        return new RegistrarCodec<V>(registrar, isMMR);
    }

    private RegistrarCodec(Registry<V> registrar, boolean isMMR) {
        this.registrar = registrar;
        this.isMMR = isMMR;
    }

    @Override
    public <T> DataResult<Pair<V, T>> decode(DynamicOps<T> ops, T input) {
        return (this.isMMR ? MMR_LOC_CODEC : DefaultCodecs.RESOURCE_LOCATION).decode(ops, input).flatMap(keyValuePair -> !this.registrar.containsKey((ResourceLocation)keyValuePair.getFirst()) ? DataResult.error(() -> "Unknown registry key in " + String.valueOf(this.registrar.key()) + ": " + String.valueOf(keyValuePair.getFirst())) : DataResult.success((Object)keyValuePair.mapFirst(arg_0 -> this.registrar.get(arg_0))));
    }

    @Override
    public <T> DataResult<T> encode(DynamicOps<T> ops, V input, T prefix) {
        return DefaultCodecs.RESOURCE_LOCATION.encode(ops, this.registrar.getKey(input), prefix);
    }

    @Override
    public String name() {
        return this.registrar.key().location().toString();
    }
}

