/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.container;

import es.degrassi.mmreborn.client.ModularMachineryRebornClient;
import es.degrassi.mmreborn.client.container.ContainerBase;
import es.degrassi.mmreborn.client.container.SlotItemComponent;
import es.degrassi.mmreborn.common.entity.base.ExperienceHatchEntity;
import es.degrassi.mmreborn.common.registration.ContainerRegistration;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.NotNull;

public class ExperienceHatchContainer
extends ContainerBase<ExperienceHatchEntity> {
    public static void open(ServerPlayer player, final ExperienceHatchEntity machine) {
        player.openMenu(new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return machine.getBlockState().getBlock().getName();
            }

            public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
                return new ExperienceHatchContainer(machine, player, id);
            }
        }, buf -> buf.writeBlockPos(machine.getBlockPos()));
    }

    public ExperienceHatchContainer(ExperienceHatchEntity entity, Player player, int containerId) {
        super(entity, player, (MenuType)ContainerRegistration.EXPERIENCE_HATCH.get(), containerId);
    }

    public ExperienceHatchContainer(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(ModularMachineryRebornClient.getClientSideExperienceHatchEntity(buffer.readBlockPos()), inv.player, id);
    }

    @Override
    public void init() {
        super.init();
        this.addSyncedSlot(new SlotItemComponent(((ExperienceHatchEntity)this.getEntity()).getCapabilityInventory().getInventory().get(0), new AtomicInteger(this.getFirstComponentSlotIndex()).getAndIncrement(), 80, 47));
    }
}

