/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.model.hatch;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import es.degrassi.mmreborn.client.model.hatch.HatchOverrideList;
import es.degrassi.mmreborn.common.registration.DataComponentRegistration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.common.NeoForgeConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

@ParametersAreNonnullByDefault
public class HatchBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<ResourceLocation> BASE_TEXTURE = new ModelProperty();
    public static final ModelProperty<String> BASE_TEXTURE_NAME = new ModelProperty();
    public static final ModelProperty<ResourceLocation> OVERLAY_TEXTURE = new ModelProperty();
    public static final ModelProperty<String> OVERLAY_TEXTURE_NAME = new ModelProperty();
    public static final ModelProperty<ResourceLocation> MODEL = new ModelProperty();
    private static final Map<ModelData, BakedModel> modelByModelData = Maps.newConcurrentMap();
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ModelBaker baker;
    private final HatchOverrideList overrideList = new HatchOverrideList();

    public HatchBakedModel(ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter) {
        this.spriteGetter = spriteGetter;
        this.baker = baker;
    }

    private static Material createMaterial(ResourceLocation texture) {
        return new Material(InventoryMenu.BLOCK_ATLAS, texture);
    }

    private static Material copy(Material material) {
        return new Material(material.atlasLocation(), material.texture());
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType type) {
        BakedModel bakedModel;
        if (modelByModelData.containsKey(data)) {
            bakedModel = modelByModelData.get(data);
        } else {
            ResourceLocation baseTexture = (ResourceLocation)data.get(BASE_TEXTURE);
            ResourceLocation overlayTexture = (ResourceLocation)data.get(OVERLAY_TEXTURE);
            String baseTextureName = (String)data.get(BASE_TEXTURE_NAME);
            String overlayTextureName = (String)data.get(OVERLAY_TEXTURE_NAME);
            ResourceLocation model = (ResourceLocation)data.get(MODEL);
            if (model == null) {
                return List.of();
            }
            BlockModel oldBlockModel = (BlockModel)this.baker.getModel(model);
            HashMap textureMap = Maps.newHashMap();
            oldBlockModel.textureMap.forEach((string, either) -> {
                either.ifLeft(material -> textureMap.put(string, Either.left((Object)HatchBakedModel.copy(material))));
                either.ifRight(name -> textureMap.put(string, Either.right((Object)name)));
            });
            if (baseTexture != null && baseTextureName != null) {
                switch (baseTextureName) {
                    case "bg_down": {
                        textureMap.put("bg_down", Either.left((Object)HatchBakedModel.createMaterial(baseTexture)));
                        break;
                    }
                    case "bg_up": {
                        textureMap.put("bg_up", Either.left((Object)HatchBakedModel.createMaterial(baseTexture)));
                        break;
                    }
                    case "bg_north": {
                        textureMap.put("bg_north", Either.left((Object)HatchBakedModel.createMaterial(baseTexture)));
                        break;
                    }
                    case "bg_south": {
                        textureMap.put("bg_south", Either.left((Object)HatchBakedModel.createMaterial(baseTexture)));
                        break;
                    }
                    case "bg_west": {
                        textureMap.put("bg_west", Either.left((Object)HatchBakedModel.createMaterial(baseTexture)));
                        break;
                    }
                    case "bg_east": {
                        textureMap.put("bg_east", Either.left((Object)HatchBakedModel.createMaterial(baseTexture)));
                        break;
                    }
                    default: {
                        textureMap.put("bg_all", Either.left((Object)HatchBakedModel.createMaterial(baseTexture)));
                    }
                }
            }
            if (overlayTexture != null && overlayTextureName != null) {
                switch (overlayTextureName) {
                    case "ov_down": {
                        textureMap.put("ov_down", Either.left((Object)HatchBakedModel.createMaterial(overlayTexture)));
                        break;
                    }
                    case "ov_up": {
                        textureMap.put("ov_up", Either.left((Object)HatchBakedModel.createMaterial(overlayTexture)));
                        break;
                    }
                    case "ov_north": {
                        textureMap.put("ov_north", Either.left((Object)HatchBakedModel.createMaterial(overlayTexture)));
                        break;
                    }
                    case "ov_south": {
                        textureMap.put("ov_south", Either.left((Object)HatchBakedModel.createMaterial(overlayTexture)));
                        break;
                    }
                    case "ov_west": {
                        textureMap.put("ov_west", Either.left((Object)HatchBakedModel.createMaterial(overlayTexture)));
                        break;
                    }
                    case "ov_east": {
                        textureMap.put("ov_east", Either.left((Object)HatchBakedModel.createMaterial(overlayTexture)));
                        break;
                    }
                    case "ov_top": {
                        textureMap.put("ov_top", Either.left((Object)HatchBakedModel.createMaterial(overlayTexture)));
                        break;
                    }
                    case "ov_side": {
                        textureMap.put("ov_side", Either.left((Object)HatchBakedModel.createMaterial(overlayTexture)));
                        break;
                    }
                    case "ov_front": {
                        textureMap.put("ov_front", Either.left((Object)HatchBakedModel.createMaterial(overlayTexture)));
                        break;
                    }
                    default: {
                        textureMap.put("ov_all", Either.left((Object)HatchBakedModel.createMaterial(overlayTexture)));
                    }
                }
            }
            BlockModel blockModel = new BlockModel(oldBlockModel.getParentLocation(), oldBlockModel.elements, (Map)textureMap, Boolean.valueOf(oldBlockModel.hasAmbientOcclusion()), oldBlockModel.getGuiLight(), oldBlockModel.getTransforms(), oldBlockModel.getOverrides());
            blockModel.resolveParents(arg_0 -> ((ModelBaker)this.baker).getModel(arg_0));
            bakedModel = this.baker.bakeUncached((UnbakedModel)blockModel, (ModelState)BlockModelRotation.X0_Y0, this.spriteGetter);
            modelByModelData.put(data, bakedModel);
        }
        if (bakedModel == null) {
            return List.of();
        }
        if (state != null && state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            return this.getRotatedQuads(bakedModel, (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING), side, rand, type);
        }
        return bakedModel.getQuads(state, side, rand, ModelData.EMPTY, type);
    }

    private List<BakedQuad> getRotatedQuads(BakedModel model, Direction machineFacing, @Nullable Direction side, RandomSource random, @Nullable RenderType type) {
        Direction originalSide = this.getRotatedDirection(machineFacing, side);
        List finalQuads = model.getQuads(null, originalSide, random, ModelData.EMPTY, type);
        return finalQuads.stream().map(quad -> this.rotateQuad((BakedQuad)quad, this.getRotation(machineFacing), side == null ? quad.getDirection() : side)).toList();
    }

    private Quaternionf getRotation(Direction machineFacing) {
        return switch (machineFacing) {
            case Direction.EAST -> new Quaternionf().fromAxisAngleDeg(0.0f, -1.0f, 0.0f, 90.0f);
            case Direction.SOUTH -> new Quaternionf().fromAxisAngleDeg(0.0f, -1.0f, 0.0f, 180.0f);
            case Direction.WEST -> new Quaternionf().fromAxisAngleDeg(0.0f, -1.0f, 0.0f, 270.0f);
            default -> new Quaternionf();
        };
    }

    private BakedQuad rotateQuad(BakedQuad quad, Quaternionf rotation, Direction side) {
        int[] quadData = quad.getVertices();
        int[] newQuadData = Arrays.copyOf(quadData, quadData.length);
        for (int i = 0; i < quadData.length / 8; ++i) {
            float x = Float.intBitsToFloat(quadData[i * 8]);
            float y = Float.intBitsToFloat(quadData[i * 8 + 1]);
            float z = Float.intBitsToFloat(quadData[i * 8 + 2]);
            Vector4f pos = new Vector4f(x - 0.5f, y - 0.5f, z - 0.5f, 1.0f);
            pos.rotate((Quaternionfc)rotation);
            pos.div(pos.w);
            newQuadData[i * 8] = Float.floatToRawIntBits(pos.x() + 0.5f);
            newQuadData[i * 8 + 1] = Float.floatToRawIntBits(pos.y() + 0.5f);
            newQuadData[i * 8 + 2] = Float.floatToRawIntBits(pos.z() + 0.5f);
            newQuadData[i * 8 + 7] = 0;
        }
        return new BakedQuad(newQuadData, quad.getTintIndex(), side, quad.getSprite(), quad.isShade());
    }

    public Direction getRotatedDirection(Direction machineFacing, @Nullable Direction quad) {
        if (quad == null || quad.getAxis() == Direction.Axis.Y) {
            return quad;
        }
        return switch (machineFacing) {
            case Direction.WEST -> Direction.from2DDataValue((int)((quad.get2DDataValue() + 1) % 4));
            case Direction.SOUTH -> Direction.from2DDataValue((int)((quad.get2DDataValue() + 2) % 4));
            case Direction.EAST -> Direction.from2DDataValue((int)((quad.get2DDataValue() + 3) % 4));
            default -> quad;
        };
    }

    public boolean useAmbientOcclusion() {
        return (Boolean)NeoForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get();
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return true;
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        return this.getParticleIcon(ModelData.EMPTY);
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.getMachineModel(data).getParticleIcon(data);
    }

    @NotNull
    public ItemOverrides getOverrides() {
        return this.overrideList;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        try {
            return this.getMachineModel(data).getRenderTypes(state, rand, data);
        }
        catch (IllegalArgumentException ignored) {
            return ChunkRenderTypeSet.all();
        }
    }

    @NotNull
    public List<RenderType> getRenderTypes(ItemStack stack, boolean fabulous) {
        return Optional.ofNullable(this.getMachineItemModel(stack)).map(machine -> machine.getRenderTypes(stack, fabulous)).orElse(List.of(RenderTypeHelper.getFallbackItemRenderType((ItemStack)stack, (BakedModel)this, (boolean)fabulous)));
    }

    private BakedModel getMachineModel(@NotNull ModelData data) {
        return this.getMachineBlockModel(data);
    }

    public BakedModel getMachineBlockModel(@NotNull ModelData data) {
        return Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)((ResourceLocation)data.get(MODEL))));
    }

    public BakedModel getMachineItemModel(ItemStack stack) {
        return Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)((ResourceLocation)stack.get(DataComponentRegistration.DEFAULT_MODEL))));
    }
}

