/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.client.container.ControllerContainer;
import es.degrassi.mmreborn.client.screen.popup.BasePopupScreen;
import es.degrassi.mmreborn.client.screen.widget.tabs.CoreTabWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.ShowRecipesTabWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.StructureBreakWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.StructurePlacerWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.TabGroupWidget;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.util.Mods;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import java.util.List;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ControllerScreen
extends BasePopupScreen<ControllerContainer> {
    public static final ResourceLocation TAB = ModularMachineryReborn.rl("textures/gui/widget/base_tab.png");
    protected static final ResourceLocation BASE_SLOT = ModularMachineryReborn.rl("textures/gui/base_slot.png");
    protected static final ResourceLocation BASE_SLOT_HOVERED = ModularMachineryReborn.rl("textures/gui/base_slot_hovered.png");
    private static final int screenWidth = 158;
    private TabGroupWidget tabs;

    public ControllerScreen(ControllerContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle, TextureSizeHelper.getWidth(ControllerScreen.getTexture()), TextureSizeHelper.getHeight(ControllerScreen.getTexture()));
    }

    @Override
    protected void init() {
        super.init();
        this.createWidgets();
    }

    @Override
    public void removed() {
        super.removed();
        if (this.minecraft.player != null) {
            ((ControllerContainer)this.menu).removed((Player)this.minecraft.player);
        }
    }

    private void createWidgets() {
        this.tabs = (TabGroupWidget)this.addRenderableWidget((GuiEventListener)new TabGroupWidget(this.x, this.y - TextureSizeHelper.getHeight(TAB)));
        this.tabs.addTab(new StructurePlacerWidget(this, ((ControllerContainer)this.getMenu()).getId(), ((MachineControllerEntity)((ControllerContainer)this.getMenu()).getEntity()).getBlockPos())).addTab(new StructureBreakWidget(this, ((ControllerContainer)this.getMenu()).getId(), ((MachineControllerEntity)((ControllerContainer)this.getMenu()).getEntity()).getBlockPos())).addTab(new CoreTabWidget(this));
        if (Mods.isJEIorEMILoaded()) {
            this.tabs.addTab(new ShowRecipesTabWidget(null, ((MachineControllerEntity)((ControllerContainer)this.getMenu()).getEntity()).getFoundMachine()));
        }
        this.tabs.setInitialFocus(((MachineControllerEntity)((ControllerContainer)this.getMenu()).getEntity()).getLastFocus());
    }

    public static ResourceLocation getTexture() {
        return ModularMachineryReborn.rl("textures/gui/guicontroller.png");
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        List out;
        ItemStack itemstack;
        int i = this.x;
        int j = this.y;
        this.renderTransparentBackground(guiGraphics);
        this.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        RenderSystem.disableDepthTest();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)i, (float)j, 0.0f);
        this.hoveredSlot = null;
        for (int k = 0; k < ((ControllerContainer)this.menu).slots.size(); ++k) {
            Slot slot = (Slot)((ControllerContainer)this.menu).slots.get(k);
            if (!slot.isActive()) continue;
            this.renderSlot(guiGraphics, slot);
            if (!this.isHovering(slot, mouseX, mouseY)) continue;
            this.hoveredSlot = slot;
            this.renderSlotHighlight(guiGraphics, slot, mouseX, mouseY, partialTicks);
        }
        this.renderLabels(guiGraphics, mouseX, mouseY);
        ItemStack itemStack = itemstack = this.draggingItem.isEmpty() ? ((ControllerContainer)this.menu).getCarried() : this.draggingItem;
        if (!itemstack.isEmpty()) {
            int l1 = 8;
            int i2 = this.draggingItem.isEmpty() ? 8 : 16;
            String s = null;
            if (!this.draggingItem.isEmpty() && this.isSplittingStack) {
                itemstack = itemstack.copyWithCount(Mth.ceil((float)((float)itemstack.getCount() / 2.0f)));
            } else if (this.isQuickCrafting && this.quickCraftSlots.size() > 1 && (itemstack = itemstack.copyWithCount(this.quickCraftingRemainder)).isEmpty()) {
                s = String.valueOf(ChatFormatting.YELLOW) + "0";
            }
            this.renderFloatingItem(guiGraphics, itemstack, mouseX - i - 8, mouseY - j - i2, s);
        }
        if (!this.snapbackItem.isEmpty()) {
            float f = (float)(Util.getMillis() - this.snapbackTime) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.snapbackItem = ItemStack.EMPTY;
            }
            int j2 = this.snapbackEnd.x - this.snapbackStartX;
            int k2 = this.snapbackEnd.y - this.snapbackStartY;
            int j1 = this.snapbackStartX + (int)((float)j2 * f);
            int k1 = this.snapbackStartY + (int)((float)k2 * f);
            this.renderFloatingItem(guiGraphics, this.snapbackItem, j1, k1, null);
        }
        guiGraphics.pose().popPose();
        RenderSystem.enableDepthTest();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.x, (float)this.y, 0.0f);
        float scale = 0.72f;
        guiGraphics.pose().scale(scale, scale, scale);
        int offsetX = 14;
        int offsetY = 14;
        DynamicMachine machine = ((MachineControllerEntity)((ControllerContainer)this.getMenu()).getEntity()).getFoundMachine();
        if (machine != DynamicMachine.DUMMY) {
            List out2 = this.font.split((FormattedText)Component.literal((String)machine.getLocalizedName()), Mth.floor((float)(158.0f * (1.0f / scale))));
            offsetY -= 7;
            for (FormattedCharSequence draw : out2) {
                guiGraphics.drawString(this.font, draw, offsetX, offsetY += 7, 0xFFFFFF);
                offsetY += 7;
            }
            offsetY -= 7;
        } else {
            MutableComponent drawnHead = Component.translatable((String)"gui.controller.structure", (Object[])new Object[]{Component.translatable((String)"gui.controller.structure.none")});
            guiGraphics.drawString(this.font, (Component)drawnHead, offsetX, offsetY, 0xFFFFFF);
        }
        offsetY += 10;
        if (((MachineControllerEntity)((ControllerContainer)this.getMenu()).getEntity()).isPaused()) {
            MutableComponent drawnStop = Component.translatable((String)"gui.controller.status.redstone_stopped");
            out = this.font.split((FormattedText)drawnStop, Mth.floor((float)(158.0f * (1.0f / scale))));
            for (FormattedCharSequence draw : out) {
                guiGraphics.drawString(this.font, draw, offsetX, offsetY += 7, 0xFFFFFF);
                offsetY += 7;
            }
            guiGraphics.pose().popPose();
            this.renderTooltip(guiGraphics, mouseX, mouseY);
            return;
        }
        MutableComponent status = Component.translatable((String)"gui.controller.status");
        out = this.font.split((FormattedText)status.append(((MachineControllerEntity)((ControllerContainer)this.getMenu()).getEntity()).getCraftingStatus().getUnlocMessage()), Mth.floor((float)(158.0f * (1.0f / scale))));
        for (FormattedCharSequence draw : out) {
            guiGraphics.drawString(this.font, draw, offsetX, offsetY += 7, 0xFFFFFF);
            offsetY += 7;
        }
        guiGraphics.pose().popPose();
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.pose().pushPose();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int leftPos = (this.width - this.xSize) / 2;
        int topPos = (this.height - this.ySize) / 2;
        guiGraphics.blit(ControllerScreen.getTexture(), leftPos, topPos, 0.0f, 0.0f, this.xSize, this.ySize, this.xSize, this.ySize);
        guiGraphics.pose().popPose();
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        if (((ControllerContainer)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            ItemStack itemstack = this.hoveredSlot.getItem();
            guiGraphics.renderTooltip(this.font, this.getTooltipFromContainerItem(itemstack), itemstack.getTooltipImage(), itemstack, x, y);
        }
        this.tabs.renderTooltip(guiGraphics, x, y);
        super.renderTooltip(guiGraphics, x, y);
    }

    protected void renderSlotHighlight(GuiGraphics guiGraphics, Slot slot, int mouseX, int mouseY, float partialTick) {
        if (slot.isHighlightable()) {
            ControllerScreen.renderSlotHighlight(guiGraphics, slot.x, slot.y, this.getSlotColor(slot.index));
        }
    }

    public static void renderSlotHighlight(GuiGraphics guiGraphics, int x, int y, int color) {
        guiGraphics.pose().pushPose();
        int width = TextureSizeHelper.getWidth(BASE_SLOT_HOVERED);
        int height = TextureSizeHelper.getHeight(BASE_SLOT_HOVERED);
        guiGraphics.blit(BASE_SLOT_HOVERED, x - 1, y - 1, 0.0f, 0.0f, width, height, width, height);
        guiGraphics.fillGradient(RenderType.guiOverlay(), x, y, x + 16, y + 16, color, color, 0);
        guiGraphics.pose().popPose();
    }

    @Generated
    public TabGroupWidget getTabs() {
        return this.tabs;
    }
}

