/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget.tabs;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import es.degrassi.mmreborn.api.BlockIngredient;
import es.degrassi.mmreborn.client.container.ControllerContainer;
import es.degrassi.mmreborn.client.item.MMRItemTooltipComponent;
import es.degrassi.mmreborn.client.screen.ControllerScreen;
import es.degrassi.mmreborn.client.screen.popup.ConfirmationPopup;
import es.degrassi.mmreborn.client.screen.widget.ItemOrIconButton;
import es.degrassi.mmreborn.client.screen.widget.tabs.TabWidget;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.network.client.CPlaceStructurePacket;
import es.degrassi.mmreborn.common.util.CycleTimer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public class StructurePlacerWidget
extends TabWidget {
    private final ControllerScreen parentScreen;
    private final ResourceLocation machine;
    private final BlockPos controllerPos;
    private static final CycleTimer timer = new CycleTimer(() -> 1000, true);
    public final Component component = Component.translatable((String)"modular_machinery_reborn.gui.structure_placer_button");

    public StructurePlacerWidget(ControllerScreen parentScreen, ResourceLocation machine, BlockPos controllerPos) {
        super(0, 0, new ItemOrIconButton(5, 5, Blocks.STRUCTURE_BLOCK.asItem(), button -> {}));
        this.parentScreen = parentScreen;
        this.machine = machine;
        this.controllerPos = controllerPos;
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        timer.onDraw();
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        this.parentScreen.setFocused((GuiEventListener)this);
        ((MachineControllerEntity)((ControllerContainer)this.parentScreen.getMenu()).getEntity()).setLastFocus(0);
        this.parentScreen.openPopup(new ConfirmationPopup<ControllerContainer>(this.parentScreen, 180, 96, () -> this.parentScreen.openPopup(new ConfirmationPopup<ControllerContainer>(this.parentScreen, 180, 96, () -> PacketDistributor.sendToServer((CustomPacketPayload)new CPlaceStructurePacket(this.machine, this.controllerPos, true), (CustomPacketPayload[])new CustomPacketPayload[0])).cancelCallback(() -> this.onClick(mouseX, mouseY, button)).text(new Component[]{Component.translatable((String)"mmr.gui.structure.place.modifier.true")}))).confirmText((Component)Component.translatable((String)"mmr.gui.structure.place.confirm.modifier")).cancelText((Component)Component.translatable((String)"mmr.gui.structure.place.cancel.modifier")).text(new Component[]{Component.translatable((String)"mmr.gui.structure.place.modifier")}).addCloseButton().cancelCallback(() -> this.parentScreen.openPopup(new ConfirmationPopup<ControllerContainer>(this.parentScreen, 180, 96, () -> PacketDistributor.sendToServer((CustomPacketPayload)new CPlaceStructurePacket(this.machine, this.controllerPos, false), (CustomPacketPayload[])new CustomPacketPayload[0])).cancelCallback(() -> this.onClick(mouseX, mouseY, button)).text(new Component[]{Component.translatable((String)"mmr.gui.structure.place.modifier.false")}))), "popup");
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        ArrayList components = Lists.newArrayList();
        this.gatherComponents(components);
        guiGraphics.renderComponentTooltipFromElements(Minecraft.getInstance().font, (List)components, x, y, ItemStack.EMPTY);
    }

    @Override
    public void gatherComponents(List<Either<FormattedText, TooltipComponent>> components) {
        components.add((Either<FormattedText, TooltipComponent>)Either.left((Object)this.component));
        Optional.of(((MachineControllerEntity)((ControllerContainer)this.parentScreen.getMenu()).getEntity()).getFoundMachine()).ifPresentOrElse(machine -> {
            if (Screen.hasShiftDown()) {
                components.add(Either.left((Object)Component.translatable((String)"modular_machinery_reborn.controller.required").withStyle(ChatFormatting.GRAY)));
                HashMap map = Maps.newHashMap();
                machine.getPattern().getPattern().asList().stream().flatMap(Collection::stream).flatMap(s -> s.chars().mapToObj(c -> Character.valueOf((char)c))).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(entry -> {
                    BlockIngredient ingredient = machine.getPattern().getPattern().asMap().get(entry.getKey());
                    if (ingredient == null) {
                        return null;
                    }
                    return Pair.of(ingredient.getStacks(((Long)entry.getValue()).intValue()), (Object)ingredient.getNamesUnified());
                }).filter(Objects::nonNull).forEachOrdered(pair -> {
                    List stacks = (List)pair.getFirst();
                    MutableComponent component = (MutableComponent)pair.getSecond();
                    ArrayList s2 = Lists.newArrayList();
                    if (map.containsKey(component)) {
                        stacks.forEach(stack -> map.forEach((c, s) -> {
                            if (c.getString().equals(component.getString())) {
                                s.forEach(s1 -> {
                                    if (s1.is(stack.getItem())) {
                                        s1.grow(stack.getCount());
                                    }
                                    s2.add(s1);
                                });
                            }
                        }));
                    } else {
                        s2.addAll(stacks);
                    }
                    map.put(component, s2);
                });
                map.forEach((c, stacks) -> {
                    if (c != null && !stacks.isEmpty()) {
                        MMRItemTooltipComponent component = new MMRItemTooltipComponent((List<ItemStack>)stacks, timer);
                        component.setComponent((Component)Component.translatable((String)"modular_machinery_reborn.controller.required.block", (Object[])new Object[]{c}).withStyle(ChatFormatting.GRAY));
                        components.add(Either.right((Object)component));
                    }
                });
            } else {
                components.add(Either.left((Object)Component.translatable((String)"modular_machinery_reborn.controller.required.block.key", (Object[])new Object[]{Component.translatable((String)"modular_machinery_reborn.controller.required.shift").withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GRAY)));
            }
            if (Screen.hasControlDown() && !Screen.hasShiftDown()) {
                components.add(Either.left((Object)Component.translatable((String)"modular_machinery_reborn.controller.modifier").withStyle(ChatFormatting.GRAY)));
                HashMap modifierMap = Maps.newHashMap();
                machine.getPattern().getPattern().getModifiers().forEach(ingredient -> {
                    MutableComponent component = Component.empty();
                    ingredient.getDescriptionLines().forEach(arg_0 -> ((MutableComponent)component).append(arg_0));
                    modifierMap.put(component, ingredient.getIngredient().getStacks(1));
                });
                if (!modifierMap.isEmpty()) {
                    modifierMap.forEach((c, stacks) -> {
                        if (c != null && !stacks.isEmpty()) {
                            MMRItemTooltipComponent component = new MMRItemTooltipComponent((List<ItemStack>)stacks, timer);
                            component.setComponent((Component)Component.translatable((String)"modular_machinery_reborn.controller.required.block", (Object[])new Object[]{c}).withStyle(ChatFormatting.GRAY));
                            components.add(Either.right((Object)component));
                        }
                    });
                }
            } else {
                components.add(Either.left((Object)Component.translatable((String)"modular_machinery_reborn.controller.required.block.key", (Object[])new Object[]{Component.translatable((String)"modular_machinery_reborn.controller.required.control").withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GRAY)));
            }
        }, () -> components.add(Either.left((Object)Component.translatable((String)"modular_machinery_reborn.controller.no_machine").withStyle(ChatFormatting.GRAY))));
    }
}

