/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget.tabs;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import es.degrassi.mmreborn.client.screen.widget.ItemOrIconButton;
import es.degrassi.mmreborn.client.screen.widget.tabs.TabWidget;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

@ParametersAreNonnullByDefault
public class TabGroupWidget
extends AbstractWidget {
    private final List<TabWidget> tabs = Lists.newArrayList();
    private final AtomicInteger lastX = new AtomicInteger();

    public TabGroupWidget(int x, int y) {
        super(x, y, 0, 0, (Component)Component.empty());
        this.lastX.set(x);
    }

    public int getWidth() {
        return this.tabs.stream().mapToInt(AbstractWidget::getWidth).sum();
    }

    public int getHeight() {
        return this.tabs.stream().mapToInt(AbstractWidget::getHeight).max().orElse(1);
    }

    public TabGroupWidget addTab(TabWidget tab) {
        return this.addTab(0, 0, tab);
    }

    public TabGroupWidget addTab(int xOffset, int yOffset, TabWidget tab) {
        tab.setX(this.lastX.getAndAdd(tab.getWidth() + xOffset));
        tab.setY(this.getY() + yOffset);
        this.tabs.add(tab);
        return this;
    }

    public TabGroupWidget addTab(ItemOrIconButton icon, @Nullable TabWidget.OnClick action) {
        return this.addTab(0, 0, icon, action);
    }

    public TabGroupWidget addTab(int xOffset, int yOffset, ItemOrIconButton icon, @Nullable TabWidget.OnClick action) {
        TabWidget tab = new TabWidget(this.lastX.get() + xOffset, this.getY() + yOffset, icon, action);
        this.lastX.getAndAdd(tab.getWidth() + xOffset);
        return this.addTab(tab);
    }

    public TabGroupWidget addTab(ItemOrIconButton icon) {
        return this.addTab(0, 0, icon);
    }

    public TabGroupWidget addTab(int xOffset, int yOffset, ItemOrIconButton icon) {
        TabWidget tab = new TabWidget(this.lastX.get() + xOffset, this.getY() + yOffset, icon);
        this.lastX.getAndAdd(tab.getWidth() + xOffset);
        return this.addTab(tab);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.tabs.forEach(tab -> tab.render(guiGraphics, mouseX, mouseY, partialTick));
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.tabs.forEach(tab -> tab.updateWidgetNarration(narrationElementOutput));
    }

    public void onClick(double mouseX, double mouseY, int button) {
        this.getTabUnderMouse(mouseX, mouseY).ifPresent(tab -> tab.onClick(mouseX, mouseY, button));
    }

    private Optional<TabWidget> getTabUnderMouse(double mouseX, double mouseY) {
        return this.tabs.stream().filter(tab -> tab.isMouseOver(mouseX, mouseY)).filter(AbstractWidget::isActive).findFirst();
    }

    public void setInitialFocus(int lastFocus) {
        if (lastFocus < 0) {
            lastFocus = 0;
        }
        if (lastFocus >= this.tabs.size()) {
            lastFocus = this.tabs.size() - 1;
        }
        this.tabs.forEach(tab -> tab.setFocused(false));
        this.tabs.get(lastFocus).setFocused(true);
    }

    public void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        this.tabs.stream().filter(tab -> tab.isMouseOver(x, y)).forEach(tab -> tab.renderTooltip(guiGraphics, x, y));
    }

    public void gatherComponents(List<Either<FormattedText, TooltipComponent>> components) {
        this.tabs.forEach(tab -> tab.gatherComponents(components));
    }
}

