/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget.tabs;

import com.mojang.datafixers.util.Either;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.client.screen.widget.ItemOrIconButton;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

@ParametersAreNonnullByDefault
public class TabWidget
extends AbstractWidget {
    private static final ResourceLocation TAB = ModularMachineryReborn.rl("textures/gui/widget/base_tab.png");
    private static final ResourceLocation TAB_HOVERED = ModularMachineryReborn.rl("textures/gui/widget/base_tab_hovered.png");
    private final ItemOrIconButton iconButton;
    @Nullable
    private final OnClick onClick;

    public TabWidget(int x, int y, @Nullable ItemOrIconButton icon, @Nullable OnClick onClick) {
        super(x, y - TextureSizeHelper.getHeight(TAB), TextureSizeHelper.getWidth(TAB), TextureSizeHelper.getHeight(TAB), (Component)Component.empty());
        this.iconButton = icon;
        this.onClick = onClick;
    }

    public TabWidget(int x, int y, @Nullable ItemOrIconButton icon) {
        this(x, y, icon, null);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation tab = this.isHoveredOrFocused() ? TAB_HOVERED : TAB;
        int x = this.getX();
        int y = this.getY();
        int width = TextureSizeHelper.getWidth(tab);
        int height = TextureSizeHelper.getHeight(tab);
        this.width = width;
        this.height = height;
        guiGraphics.blit(tab, x, y, 0.0f, 0.0f, width, height, width, height);
        if (this.iconButton != null) {
            this.iconButton.setDisableBackground(true);
            this.iconButton.setPosition(5 + x, 5 + y);
            this.iconButton.renderTooltip(false);
            this.iconButton.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    public void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        if (this.iconButton != null) {
            this.iconButton.renderTooltip(guiGraphics, x, y);
        }
    }

    public void onClick(double mouseX, double mouseY, int button) {
        if (this.onClick != null) {
            this.onClick.onClick(mouseX, mouseY, button);
        }
        if (this.iconButton != null) {
            this.iconButton.onClick(mouseX, mouseY, button);
        }
    }

    public void gatherComponents(List<Either<FormattedText, TooltipComponent>> components) {
    }

    public static interface OnClick {
        public void onClick(double var1, double var3, int var5);
    }
}

