/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class FluidRenderer {
    private static final int MIN_FLUID_HEIGHT = 1;
    private static final int TEXTURE_SIZE = 16;

    private FluidRenderer() {
    }

    public static void renderFluid(PoseStack poseStack, int posX, int posY, int width, int height, FluidStack fluidStack, long capacity) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid == Fluids.EMPTY) {
            return;
        }
        RenderSystem.enableBlend();
        poseStack.pushPose();
        poseStack.translate((float)posX, (float)posY, 0.0f);
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(extensions.getStillTexture(fluidStack));
        int fluidColor = extensions.getTintColor(fluidStack);
        long amount = fluidStack.getAmount();
        int scaledAmount = (int)(amount * (long)height / capacity);
        if (amount > 0L && scaledAmount < 1) {
            scaledAmount = 1;
        }
        if (scaledAmount > height) {
            scaledAmount = height;
        }
        FluidRenderer.drawTiledSprite(poseStack, width, height, fluidColor, scaledAmount, sprite);
        poseStack.popPose();
        RenderSystem.disableBlend();
    }

    private static void drawTiledSprite(PoseStack poseStack, int tiledWidth, int tiledHeight, int color, int scaledAmount, TextureAtlasSprite sprite) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        Matrix4f matrix = poseStack.last().pose();
        FluidRenderer.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : 16;
                int height = yTile == yTileCount ? yRemainder : 16;
                int x = xTile * 16;
                int y = tiledHeight - (yTile + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                FluidRenderer.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        if (alpha == 0.0f) {
            alpha = 1.0f;
        }
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, float zLevel) {
        float uMin = textureSprite.getU0();
        float uMax = textureSprite.getU1();
        float vMin = textureSprite.getV0();
        float vMax = textureSprite.getV1();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix, xCoord, yCoord + 16.0f, zLevel).setUv(uMin, vMax);
        bufferBuilder.addVertex(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).setUv(uMax, vMax);
        bufferBuilder.addVertex(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).setUv(uMax, vMin);
        bufferBuilder.addVertex(matrix, xCoord, yCoord + (float)maskTop, zLevel).setUv(uMin, vMin);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }
}

