/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.client.container.ControllerContainer;
import es.degrassi.mmreborn.common.block.BlockMachineComponent;
import es.degrassi.mmreborn.common.block.BlockTickEntity;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.item.ControllerItem;
import es.degrassi.mmreborn.common.item.ItemBlueprint;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.network.server.SAddControllerRenderer;
import es.degrassi.mmreborn.common.network.server.SMachineUpdatePacket;
import es.degrassi.mmreborn.common.network.server.SRemoveControllerRenderer;
import es.degrassi.mmreborn.common.network.server.SStopSoundInstancePacket;
import es.degrassi.mmreborn.common.util.RedstoneHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockController
extends BlockMachineComponent
implements BlockTickEntity {
    public BlockController() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(5.0f, 10.0f).requiresCorrectToolForDrops().dynamicShape().noOcclusion());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        BlockEntity blockEntity;
        ResourceLocation id = (ResourceLocation)ModularMachineryReborn.MACHINES_BLOCK.inverse().get((Object)this);
        if (id != null && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof MachineControllerEntity) {
            MachineControllerEntity entity = (MachineControllerEntity)blockEntity;
            entity.setId(id);
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                serverLevel.getServer().tell((Runnable)new TickTask(1, () -> PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(pPos), (CustomPacketPayload)new SMachineUpdatePacket(id, pPos), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        ControllerItem.getMachine(stack).ifPresent(machine -> {
            BlockEntity tile = level.getBlockEntity(pos);
            if (tile instanceof MachineControllerEntity) {
                MachineControllerEntity machineTile = (MachineControllerEntity)tile;
                machineTile.setId(machine.getRegistryName());
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    level.getServer().tell((Runnable)new TickTask(1, () -> PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SMachineUpdatePacket(machine.getRegistryName(), pos), (CustomPacketPayload[])new CustomPacketPayload[0])));
                }
            }
        });
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof MachineControllerEntity) {
            MachineControllerEntity entity = (MachineControllerEntity)tile;
            return ControllerItem.makeMachineItem(entity.getId());
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new MachineControllerEntity(blockPos, blockState);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof MachineControllerEntity) {
            MachineControllerEntity entity = (MachineControllerEntity)te;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SStopSoundInstancePacket(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SRemoveControllerRenderer(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (player.getAbilities().instabuild && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof MachineControllerEntity) {
                MachineControllerEntity entity = (MachineControllerEntity)blockEntity;
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SStopSoundInstancePacket(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SRemoveControllerRenderer(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof MachineControllerEntity) {
            MachineControllerEntity controller = (MachineControllerEntity)te;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (player.getItemInHand(hand).getItem() instanceof ItemBlueprint) {
                    DynamicMachine machine = controller.getFoundMachine();
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverPlayer.serverLevel(), (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SAddControllerRenderer(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return ItemInteractionResult.SUCCESS;
                }
                ControllerContainer.open(serverPlayer, controller);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof MachineControllerEntity) {
            MachineControllerEntity entity = (MachineControllerEntity)tile;
            RedstoneHelper.getRedstoneLevel(entity);
        }
        return 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof MachineControllerEntity) {
            MachineControllerEntity entity = (MachineControllerEntity)tile;
            RedstoneHelper.getRedstoneLevel(entity);
        }
        return 0;
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof MachineControllerEntity) {
            MachineControllerEntity entity = (MachineControllerEntity)tile;
            RedstoneHelper.getRedstoneLevel(entity);
        }
        return 0;
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return Optional.ofNullable(level.getBlockEntity(pos)).filter(blockEntity -> blockEntity instanceof MachineControllerEntity).map(tile -> ((MachineControllerEntity)tile).getInteractionSound()).orElse(super.getSoundType(state));
    }
}

