/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block;

import es.degrassi.experiencelib.impl.capability.BasicExperienceHandler;
import es.degrassi.mmreborn.client.container.ExperienceHatchContainer;
import es.degrassi.mmreborn.common.block.BlockMachineComponent;
import es.degrassi.mmreborn.common.block.BlockTickEntity;
import es.degrassi.mmreborn.common.block.prop.ExperienceHatchSize;
import es.degrassi.mmreborn.common.entity.base.ExperienceHatchEntity;
import es.degrassi.mmreborn.common.util.RedstoneHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockExperienceHatch
extends BlockMachineComponent
implements BlockTickEntity {
    protected final ExperienceHatchSize size;

    public BlockExperienceHatch(ExperienceHatchSize size) {
        super(BlockBehaviour.Properties.of().dynamicShape().noOcclusion().strength(2.0f, 10.0f).sound(SoundType.METAL));
        this.size = size;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag pTooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.experiencehatch.tank.info", (Object[])new Object[]{this.size.getCapacity()}).withStyle(ChatFormatting.GRAY));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof ExperienceHatchEntity) {
            ExperienceHatchEntity entity = (ExperienceHatchEntity)te;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ExperienceHatchContainer.open(serverPlayer, entity);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        return RedstoneHelper.getRedstoneLevel(pLevel.getBlockEntity(pPos));
    }

    public int getExpDrop(BlockState state, LevelAccessor level, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity breaker, ItemStack tool) {
        ExperienceHatchEntity entity;
        BasicExperienceHandler tank;
        if (level.isClientSide()) {
            return super.getExpDrop(state, level, pos, blockEntity, breaker, tool);
        }
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof ExperienceHatchEntity && (tank = (entity = (ExperienceHatchEntity)blockEntity2).getTank()).getExperience() > 0L) {
            for (int i = 0; i < tank.getTanks(); ++i) {
                for (long extracted = tank.extractExperienceRecipe(i, Long.MAX_VALUE, false); extracted > Integer.MAX_VALUE; extracted -= Integer.MAX_VALUE) {
                    this.popExperience((ServerLevel)level, pos, Integer.MAX_VALUE);
                }
            }
            return (int)tank.getExperience();
        }
        return super.getExpDrop(state, level, pos, blockEntity, breaker, tool);
    }
}

