/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block;

import es.degrassi.mmreborn.common.block.BlockDynamicColor;
import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineEntity;
import es.degrassi.mmreborn.common.entity.base.ItemDroppeable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockMachineComponent
extends Block
implements BlockDynamicColor,
EntityBlock {
    protected BlockMachineComponent(BlockBehaviour.Properties properties) {
        super(properties.requiresCorrectToolForDrops());
    }

    @Override
    public int getColorMultiplier(BlockState state, @Nullable BlockAndTintGetter worldIn, @Nullable BlockPos pos, int tintIndex) {
        if (worldIn == null || pos == null) {
            return Config.machineColor;
        }
        BlockEntity te = worldIn.getBlockEntity(pos);
        if (te instanceof ColorableMachineEntity) {
            return ((ColorableMachineEntity)te).getMachineColor();
        }
        return Config.machineColor;
    }

    protected boolean triggerEvent(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, int pId, int pParam) {
        super.triggerEvent(pState, pLevel, pPos, pId, pParam);
        BlockEntity be = pLevel.getBlockEntity(pPos);
        return be != null && be.triggerEvent(pId, pParam);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new ColorableMachineComponentEntity(blockPos, blockState);
    }

    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        BlockEntity be = (BlockEntity)builder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (be instanceof ItemDroppeable) {
            ItemDroppeable entity = (ItemDroppeable)be;
            entity.addDrops(drops);
        }
        return drops;
    }

    protected boolean canBeReplaced(BlockState state, Fluid fluid) {
        return false;
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return false;
    }
}

