/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import es.degrassi.mmreborn.client.util.EnergyDisplayUtil;
import es.degrassi.mmreborn.common.block.prop.ConfigLoaded;
import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.machine.MachineJsonReloadListener;
import es.degrassi.mmreborn.common.network.server.SOpenFilePacket;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class MMRCommand {
    private MMRCommand() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> register(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)name).then(MMRCommand.logging())).then(MMRCommand.reload());
    }

    private static ArgumentBuilder<CommandSourceStack, ?> logging() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"log").requires(cs -> cs.hasPermission(2))).executes(ctx -> {
            Entity patt0$temp = ((CommandSourceStack)ctx.getSource()).getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SOpenFilePacket(new File("logs/modular_machinery_reborn/mmr.log").toURI().toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return 1;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> reload() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(cs -> cs.hasPermission(2))).executes(ctx -> {
            Config.load();
            ConfigLoaded.load();
            EnergyDisplayUtil.loadFromConfig();
            Entity patt0$temp = ((CommandSourceStack)ctx.getSource()).getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                MMRCommand.reloadMachines(player.server, player);
            }
            return 1;
        });
    }

    public static void reloadMachines(MinecraftServer server, @Nullable ServerPlayer player) {
        new MachineJsonReloadListener().reload(CompletableFuture::completedFuture, server.getResourceManager(), (ProfilerFiller)InactiveProfiler.INSTANCE, (ProfilerFiller)InactiveProfiler.INSTANCE, (Executor)server, (Executor)server).thenRun(() -> {
            if (player != null) {
                player.sendSystemMessage((Component)Component.translatable((String)"modular_machinery_reborn.command.reload.machines").withStyle(ChatFormatting.GRAY));
            }
        });
    }
}

