/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.codec.DefaultCodecs;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.BiomeComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RequirementBiome
implements IRequirement<BiomeComponent> {
    public static final NamedCodec<RequirementBiome> CODEC = NamedCodec.record(instance -> instance.group(DefaultCodecs.RESOURCE_LOCATION.listOf().fieldOf("filter").forGetter(RequirementBiome::filter), NamedCodec.BOOL.optionalFieldOf("blacklist", false).forGetter(RequirementBiome::blacklist), PositionedRequirement.POSITION_CODEC.optionalFieldOf("position", new PositionedRequirement(0, 0)).forGetter(IRequirement::getPosition)).apply((Applicative)instance, RequirementBiome::new), "Biome Requirement");
    private final IOType actionType;
    private final RequirementType<RequirementBiome> requirementType;
    private final PositionedRequirement position;
    private final List<ResourceLocation> filter;
    private final boolean blacklist;

    public RequirementBiome(List<ResourceLocation> filter, boolean blacklist, PositionedRequirement position) {
        this.filter = filter;
        this.blacklist = blacklist;
        this.position = position;
        this.requirementType = RequirementTypeRegistration.BIOME.get();
        this.actionType = IOType.INPUT;
    }

    public List<ResourceLocation> filter() {
        return this.filter;
    }

    public boolean blacklist() {
        return this.blacklist;
    }

    @Override
    public RequirementType<RequirementBiome> getType() {
        return RequirementTypeRegistration.BIOME.get();
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentRegistration.COMPONENT_BIOME.get();
    }

    @Override
    public IOType getMode() {
        return this.getActionType();
    }

    @Override
    public boolean test(BiomeComponent component, ICraftingContext context) {
        Registry biomeRegistry = context.getMachineTile().getLevel().registryAccess().registryOrThrow(Registries.BIOME);
        return this.filter.stream().anyMatch(biome -> biomeRegistry.get(biome) == context.getMachineTile().getLevel().getBiome(context.getMachineTile().getBlockPos()).value()) != this.blacklist;
    }

    @Override
    public void gatherRequirements(IRequirementList<BiomeComponent> list) {
    }

    @Override
    public JsonObject asJson() {
        JsonObject json = IRequirement.super.asJson();
        json.addProperty("blacklist", Boolean.valueOf(this.blacklist));
        JsonArray array = new JsonArray();
        this.filter.stream().map(ResourceLocation::toString).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        json.add("filter", (JsonElement)array);
        return json;
    }

    @Override
    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)"component.missing.biome");
    }

    @Override
    public boolean isComponentValid(BiomeComponent m, ICraftingContext context) {
        return this.getMode().equals((Object)m.getIOType());
    }

    @Generated
    public IOType getActionType() {
        return this.actionType;
    }

    @Generated
    public RequirementType<RequirementBiome> getRequirementType() {
        return this.requirementType;
    }

    @Override
    @Generated
    public PositionedRequirement getPosition() {
        return this.position;
    }
}

