/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.DurabilityComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import java.util.Arrays;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;

public class RequirementDurability
implements IRequirement<DurabilityComponent> {
    public static final NamedCodec<RequirementDurability> CODEC = NamedCodec.record(instance -> instance.group(NamedCodec.of(CraftingHelper.makeIngredientCodec((boolean)true)).fieldOf("ingredient").aliases("item").forGetter(req -> req.ingredient), NamedCodec.intRange(1, Integer.MAX_VALUE).optionalFieldOf("amount", 1).forGetter(RequirementDurability::getAmount), IOType.CODEC.fieldOf("mode").forGetter(IRequirement::getMode), PositionedRequirement.POSITION_CODEC.optionalFieldOf("position", new PositionedRequirement(0, 0)).forGetter(IRequirement::getPosition)).apply((Applicative)instance, (item, amount, mode, position) -> new RequirementDurability((IOType)((Object)((Object)mode)), (Ingredient)item, (int)amount, (PositionedRequirement)position)), "RequirementDurability");
    public final Ingredient ingredient;
    private final IOType mode;
    private final PositionedRequirement position;
    private final int amount;

    public RequirementDurability(IOType ioType, Ingredient ingredient, int amount, PositionedRequirement position) {
        this.amount = amount;
        this.ingredient = ingredient;
        this.mode = ioType;
        this.position = position;
    }

    @Override
    public RequirementType<RequirementDurability> getType() {
        return RequirementTypeRegistration.DURABILITY.get();
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentRegistration.COMPONENT_DURABILITY.get();
    }

    @Override
    public boolean test(DurabilityComponent component, ICraftingContext context) {
        int a = (int)context.getIntegerModifiedValue(this.amount, this);
        if (this.getMode().isInput()) {
            return this.processWithLog(amount -> Arrays.stream(this.ingredient.getItems()).mapToInt(item -> component.getContainerProvider().getDurabilityAmount((ItemStack)item)).sum() >= amount, a);
        }
        return this.processWithLog(amount -> Arrays.stream(this.ingredient.getItems()).mapToInt(item -> component.getContainerProvider().getSpaceForDurability((ItemStack)item)).sum() >= amount, 1);
    }

    private boolean processWithLog(Function<Integer, Boolean> function, int amount) {
        return function.apply(amount);
    }

    @Override
    public void gatherRequirements(IRequirementList<DurabilityComponent> list) {
        if (this.mode.isInput()) {
            list.processOnStart(this::processInput);
        } else {
            list.processOnEnd(this::processOutput);
        }
    }

    private CraftingResult processInput(DurabilityComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this);
        int maxRemove = Arrays.stream(this.ingredient.getItems()).mapToInt(item -> component.getContainerProvider().getDurabilityAmount((ItemStack)item)).sum();
        if (maxRemove >= amount) {
            int toDamage = amount;
            for (ItemStack item2 : this.ingredient.getItems()) {
                int canDamage = component.getContainerProvider().getDurabilityAmount(item2);
                if (canDamage <= 0) continue;
                canDamage = Math.min(canDamage, toDamage);
                component.getContainerProvider().removeDurability(item2, canDamage);
                if ((toDamage -= canDamage) != 0) continue;
                return CraftingResult.success();
            }
        }
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.durability.input", (Object[])new Object[]{amount, maxRemove}));
    }

    private CraftingResult processOutput(DurabilityComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this);
        int maxRepair = Arrays.stream(this.ingredient.getItems()).mapToInt(item -> component.getContainerProvider().getSpaceForDurability((ItemStack)item)).sum();
        if (maxRepair >= amount) {
            int toRepair = amount;
            for (ItemStack item2 : this.ingredient.getItems()) {
                int canRepair = component.getContainerProvider().getSpaceForDurability(item2);
                if (canRepair <= 0) continue;
                canRepair = Math.min(canRepair, toRepair);
                component.getContainerProvider().repairItem(item2, canRepair);
                if ((toRepair -= canRepair) != 0) continue;
                return CraftingResult.success();
            }
        }
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.durability.output", (Object[])new Object[]{amount, maxRepair}));
    }

    public JsonObject asJson(Ingredient ingredient) {
        JsonObject json = new JsonObject();
        JsonArray stacks = new JsonArray();
        for (ItemStack stack : ingredient.getItems()) {
            ItemStack.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)stack).result().map(JsonElement::toString).ifPresent(arg_0 -> ((JsonArray)stacks).add(arg_0));
        }
        json.add("items", (JsonElement)stacks);
        return json;
    }

    @Override
    public JsonObject asJson() {
        JsonObject json = IRequirement.super.asJson();
        json.add("ingredient", (JsonElement)this.asJson(this.ingredient));
        return json;
    }

    @Override
    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)String.format("component.missing.durability.%s", ioType.name().toLowerCase()));
    }

    @Override
    public boolean isComponentValid(DurabilityComponent m, ICraftingContext context) {
        return true;
    }

    @Generated
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    @Generated
    public IOType getMode() {
        return this.mode;
    }

    @Override
    @Generated
    public PositionedRequirement getPosition() {
        return this.position;
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }
}

