/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.emi;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.screen.EmiScreenManager;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.client.requirement.ItemRendering;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementDurability;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.IngredientHolder;
import es.degrassi.mmreborn.common.crafting.requirement.emi.SlotTooltip;
import es.degrassi.mmreborn.common.integration.emi.EmiIngredientRegistry;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.DurabilityComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class EmiDurabilityComponent
extends EmiComponent<ItemStack, RecipeRequirement<DurabilityComponent, RequirementDurability>>
implements SlotTooltip,
ItemRendering,
IngredientHolder {
    private int item;
    private int width = 16;
    private int height = 16;
    @Nullable
    private EmiRecipe recipe;
    private final EmiIngredient ingredient;
    private final List<ItemStack> items;

    public EmiDurabilityComponent(RecipeRequirement<DurabilityComponent, RequirementDurability> requirement) {
        super(requirement, 36, 0);
        this.ingredient = EmiIngredientRegistry.getIngredient(requirement.getType()).create(requirement);
        this.items = this.generateWithDurability(requirement.requirement().ingredient);
    }

    private List<ItemStack> generateWithDurability(Ingredient original) {
        return ((Stream)Arrays.stream(original.getItems()).map(this::generateWithDurability).flatMap(Collection::stream).unordered()).toList();
    }

    private List<ItemStack> generateWithDurability(ItemStack stack) {
        if (!stack.isDamageableItem()) {
            throw new IllegalArgumentException("Invalid not damageable item in durability requirement");
        }
        int maxDamage = stack.getMaxDamage();
        ArrayList damagedItems = Lists.newArrayList();
        if (maxDamage <= 10) {
            for (int i = 0; i <= maxDamage; ++i) {
                ItemStack copy = stack.copy();
                copy.setDamageValue(i);
                damagedItems.add(copy);
            }
        } else {
            for (int i = 0; i <= 10; ++i) {
                ItemStack copy = stack.copy();
                copy.setDamageValue(Mth.randomBetweenInclusive((RandomSource)RandomSource.create(), (int)0, (int)maxDamage));
                damagedItems.add(copy);
            }
        }
        return ((Stream)damagedItems.stream().unordered()).toList();
    }

    @Override
    public void recipeContext(EmiRecipe recipe) {
        this.recipe = recipe;
    }

    @Override
    public EmiStack getStack() {
        return EmiStack.of((ItemStack)this.ingredients().get(this.item));
    }

    @Override
    public EmiIngredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public List<ItemStack> ingredients() {
        return this.items;
    }

    @Override
    public Bounds getBounds() {
        return super.getBounds();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.item = (int)(System.currentTimeMillis() / 1000L % (long)this.ingredients().size());
        this.width += 2;
        this.height += 2;
        super.render(guiGraphics, mouseX, mouseY);
        this.width -= 2;
        this.height -= 2;
        this.drawStack(guiGraphics, 1, 1, -1);
    }

    public IOType getActionType() {
        return ((RequirementDurability)this.requirement.requirement()).getMode();
    }

    @Override
    public List<Component> getTooltip() {
        ArrayList list = Lists.newArrayList();
        if (this.getStack().isEmpty()) {
            return list;
        }
        list.addAll(this.getStack().getTooltipText());
        if (this.getActionType().isInput()) {
            list.add(Component.translatable((String)"modular_machinery_reborn.ingredient.durability.consume", (Object[])new Object[]{((RequirementDurability)this.requirement.requirement()).getAmount()}));
        } else if (this.getActionType() == IOType.OUTPUT) {
            list.add(Component.translatable((String)"modular_machinery_reborn.ingredient.durability.repair", (Object[])new Object[]{((RequirementDurability)this.requirement.requirement()).getAmount()}));
        }
        return list;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.slotInteraction(bind -> bind.matchesMouse(button))) {
            return true;
        }
        return EmiScreenManager.stackInteraction((EmiStackInteraction)new EmiStackInteraction((EmiIngredient)this.getStack(), this.getRecipe(), true), bind -> bind.matchesMouse(button));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.slotInteraction(bind -> bind.matchesKey(keyCode, scanCode))) {
            return true;
        }
        return EmiScreenManager.stackInteraction((EmiStackInteraction)new EmiStackInteraction((EmiIngredient)this.getStack(), this.getRecipe(), true), bind -> bind.matchesKey(keyCode, scanCode));
    }

    @Override
    @Generated
    public int getWidth() {
        return this.width;
    }

    @Override
    @Generated
    public int getHeight() {
        return this.height;
    }

    @Override
    @Nullable
    @Generated
    public EmiRecipe getRecipe() {
        return this.recipe;
    }
}

