/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.data;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.client.util.EnergyDisplayUtil;
import es.degrassi.mmreborn.common.block.prop.EnergyHatchSize;
import es.degrassi.mmreborn.common.block.prop.ExperienceHatchSize;
import es.degrassi.mmreborn.common.block.prop.FluidHatchSize;
import es.degrassi.mmreborn.common.block.prop.ItemBusSize;
import es.degrassi.mmreborn.common.block.prop.ItemDurabilityHatchSize;
import es.degrassi.mmreborn.common.block.prop.ParallelHatchSize;
import es.degrassi.mmreborn.common.util.LoggingLevel;
import java.util.List;
import lombok.Generated;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class MMRConfig {
    private static final MMRConfig INSTANCE;
    private static final ModConfigSpec spec;
    public final ModConfigSpec.ConfigValue<LoggingLevel> debugLevel;
    public final ModConfigSpec.ConfigValue<Boolean> logMissingOptional;
    public final ModConfigSpec.ConfigValue<Boolean> logFirstEitherError;
    public final ModConfigSpec.ConfigValue<String> general_casing_color;
    public final ModConfigSpec.ConfigValue<String> chance_color;
    public final ModConfigSpec.ConfigValue<Integer> checkStructureTicks;
    public final ModConfigSpec.ConfigValue<Integer> checkRecipeTicks;
    public final ModConfigSpec.ConfigValue<Integer> maxParallel;
    public final ModConfigSpec.ConfigValue<Boolean> shouldReplace;
    public final ModConfigSpec.ConfigValue<Boolean> sendReplaceMessage;
    public final ModConfigSpec.ConfigValue<Boolean> sendMissingBlockMessage;
    public final ModConfigSpec.ConfigValue<Boolean> sendErrorMessage;
    public final ModConfigSpec.ConfigValue<Integer> structureRenderTime;
    public final ModConfigSpec.ConfigValue<Integer> blockTagCycleTime;
    public final ModConfigSpec.ConfigValue<String> machineDirectory;
    public final ModConfigSpec.ConfigValue<List<String>> modelFolders;
    public final ModConfigSpec.ConfigValue<Integer> TINY_energy_size;
    public final ModConfigSpec.ConfigValue<Integer> TINY_energy_transferRate;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_energy_size;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_energy_transferRate;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_energy_size;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_energy_transferRate;
    public final ModConfigSpec.ConfigValue<Integer> REINFORCED_energy_size;
    public final ModConfigSpec.ConfigValue<Integer> REINFORCED_energy_transferRate;
    public final ModConfigSpec.ConfigValue<Integer> BIG_energy_size;
    public final ModConfigSpec.ConfigValue<Integer> BIG_energy_transferRate;
    public final ModConfigSpec.ConfigValue<Integer> HUGE_energy_size;
    public final ModConfigSpec.ConfigValue<Integer> HUGE_energy_transferRate;
    public final ModConfigSpec.ConfigValue<Integer> LUDICROUS_energy_size;
    public final ModConfigSpec.ConfigValue<Integer> LUDICROUS_energy_transferRate;
    public final ModConfigSpec.ConfigValue<Integer> ULTIMATE_energy_size;
    public final ModConfigSpec.ConfigValue<Integer> ULTIMATE_energy_transferRate;
    public final ModConfigSpec.ConfigValue<Boolean> energy_displayFETooltip;
    public final ModConfigSpec.ConfigValue<Boolean> energy_displayIC2EUTooltip;
    public final ModConfigSpec.ConfigValue<EnergyDisplayUtil.EnergyType> energy_type;
    public final ModConfigSpec.ConfigValue<Integer> TINY_fluid_size;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_fluid_size;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_fluid_size;
    public final ModConfigSpec.ConfigValue<Integer> REINFORCED_fluid_size;
    public final ModConfigSpec.ConfigValue<Integer> BIG_fluid_size;
    public final ModConfigSpec.ConfigValue<Integer> HUGE_fluid_size;
    public final ModConfigSpec.ConfigValue<Integer> LUDICROUS_fluid_size;
    public final ModConfigSpec.ConfigValue<Integer> VACUUM_fluid_size;
    public final ModConfigSpec.ConfigValue<Integer> itemSlotXOffset;
    public final ModConfigSpec.ConfigValue<Integer> itemSlotYOffset;
    public final ModConfigSpec.ConfigValue<Integer> TINY_item_size;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_item_size;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_item_size;
    public final ModConfigSpec.ConfigValue<Integer> REINFORCED_item_size;
    public final ModConfigSpec.ConfigValue<Integer> BIG_item_size;
    public final ModConfigSpec.ConfigValue<Integer> HUGE_item_size;
    public final ModConfigSpec.ConfigValue<Integer> LUDICROUS_item_size;
    public final ModConfigSpec.ConfigValue<Integer> TINY_item_cols;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_item_cols;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_item_cols;
    public final ModConfigSpec.ConfigValue<Integer> REINFORCED_item_cols;
    public final ModConfigSpec.ConfigValue<Integer> BIG_item_cols;
    public final ModConfigSpec.ConfigValue<Integer> HUGE_item_cols;
    public final ModConfigSpec.ConfigValue<Integer> LUDICROUS_item_cols;
    public final ModConfigSpec.ConfigValue<Integer> TINY_durability_size;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_durability_size;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_durability_size;
    public final ModConfigSpec.ConfigValue<Integer> BIG_durability_size;
    public final ModConfigSpec.ConfigValue<Integer> TINY_durability_cols;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_durability_cols;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_durability_cols;
    public final ModConfigSpec.ConfigValue<Integer> BIG_durability_cols;
    public final ModConfigSpec.ConfigValue<Integer> TINY_experience_size;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_experience_size;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_experience_size;
    public final ModConfigSpec.ConfigValue<Integer> REINFORCED_experience_size;
    public final ModConfigSpec.ConfigValue<Integer> BIG_experience_size;
    public final ModConfigSpec.ConfigValue<Integer> HUGE_experience_size;
    public final ModConfigSpec.ConfigValue<Integer> LUDICROUS_experience_size;
    public final ModConfigSpec.ConfigValue<Integer> VACUUM_experience_size;
    public final ModConfigSpec.ConfigValue<Integer> BASIC_parallel;
    public final ModConfigSpec.ConfigValue<Integer> MEDIUM_parallel;
    public final ModConfigSpec.ConfigValue<Integer> ADVANCED_parallel;
    public final ModConfigSpec.ConfigValue<Integer> ULTIMATE_parallel;
    public final ModConfigSpec.ConfigValue<Integer> MAX_parallel;

    public static MMRConfig get() {
        return INSTANCE;
    }

    public MMRConfig(ModConfigSpec.Builder builder) {
        builder.push("general");
        builder.push("Logs");
        this.logMissingOptional = builder.comment("If true, all missing optional properties\nand their default values will be logged\nwhen parsing custom machines jsons.").define("log_missing_optional", false);
        this.logFirstEitherError = builder.comment("When parsing custom machines json files,\nsome properties can be read with 2 serializers.\nSet this to true to log when the first serializer throw an error,\neven if the second succeed.").define("log_first_either_error", false);
        this.debugLevel = builder.comment("Configure what logs will be printed in the custommachinery.log file.\nOnly logs with level higher or equal than selected will be printed.\nFATAL > ERROR > WARN > INFO > DEBUG > ALL").defineEnum("debug_level", (Enum)LoggingLevel.INFO);
        builder.pop();
        builder.push("General");
        this.general_casing_color = builder.comment("Defines the _default_ color for machine casings as items or blocks. (Hex color with alpha at start) Has to be defined both server and clientside!").define("general_casing_color", (Object)"#FFFF4900");
        this.chance_color = builder.comment("Defines the _default_ color for EMI/JEI chance text color. (Hex color without alpha) Has to be defined both server and clientside!").define("chance_color", (Object)"#FFFFFF");
        this.checkStructureTicks = builder.comment("Defines the time in ticks that the machine should check for a structure update.\n20 ticks = 1 second. Default: 5").defineInRange("check_structure_ticks", 5, 1, Integer.MAX_VALUE);
        this.checkRecipeTicks = builder.comment("Defines the time in ticks that the machine should check for a recipe update.\n20 ticks = 1 second. Default: 80").defineInRange("check_recipe_ticks", 20, 1, Integer.MAX_VALUE);
        this.maxParallel = builder.comment("Defines the number of max parallel recipes that can be run on multiblocks. If this number is below than any on [parallel hatch] config path, it will use the max value of them instead.").defineInRange("maxParallel", 256, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("Structure");
        this.shouldReplace = builder.comment("Defines if it should break and place the non-matching blocks on trying to place structure. Default: true").define("should_replace", true);
        this.sendReplaceMessage = builder.comment("Defines if should sent a message to the player for each replaced block. Default: true").define("replaceMessage", true);
        this.sendMissingBlockMessage = builder.comment("Defines if should sent a message to the player for each missing block. Default: true").define("missingBlockMessage", true);
        this.sendErrorMessage = builder.comment("Defines if should sent a message to the player for each error on place block. Default: true").define("errorMessage", true);
        builder.pop();
        builder.push("Rendering");
        this.structureRenderTime = builder.comment("The time in milliseconds the structure requirement\nstructure will render in world when clicking\non the icon in the jei recipe.").defineInRange("structure_render_time", 10000, 1, Integer.MAX_VALUE);
        this.blockTagCycleTime = builder.comment("The time in milliseconds each blocks will be shown\nwhen using a block tag in a structure.").defineInRange("block_tag_cycle_time", 1000, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("Directories");
        this.machineDirectory = builder.comment("A folder name where MMR will load machine structure json.\nThese folder must be under the \"data/<namespace>\" folder.").define("machine_directory", (Object)"machines");
        this.modelFolders = builder.comment("A list of folder names where MMR will load controller models json. These folders must be under the 'assets/namespace/models' folder.").define("model_folders", (Object)Lists.newArrayList((Object[])new String[]{"controller", "controllers"}));
        builder.pop();
        builder.pop();
        builder.push("energyHatch");
        builder.push(EnergyHatchSize.TINY.getSerializedName());
        this.TINY_energy_size = builder.comment("Energy storage size of the energy hatch.").defineInRange("size", EnergyHatchSize.TINY.defaultConfigurationEnergy, 1, Integer.MAX_VALUE);
        this.TINY_energy_transferRate = builder.comment("Defines the transfer limit for RF/FE things. \nIC2's transfer limit is defined by the voltage tier.").defineInRange("transfer_rate", EnergyHatchSize.TINY.defaultConfigurationTransferLimit, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(EnergyHatchSize.SMALL.getSerializedName());
        this.SMALL_energy_size = builder.comment("Energy storage size of the energy hatch.").defineInRange("size", EnergyHatchSize.SMALL.defaultConfigurationEnergy, 1, Integer.MAX_VALUE);
        this.SMALL_energy_transferRate = builder.comment("Defines the transfer limit for RF/FE things. \nIC2's transfer limit is defined by the voltage tier.").defineInRange("transfer_rate", EnergyHatchSize.SMALL.defaultConfigurationTransferLimit, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(EnergyHatchSize.NORMAL.getSerializedName());
        this.NORMAL_energy_size = builder.comment("Energy storage size of the energy hatch.").defineInRange("size", EnergyHatchSize.NORMAL.defaultConfigurationEnergy, 1, Integer.MAX_VALUE);
        this.NORMAL_energy_transferRate = builder.comment("Defines the transfer limit for RF/FE things. \nIC2's transfer limit is defined by the voltage tier.").defineInRange("transfer_rate", EnergyHatchSize.NORMAL.defaultConfigurationTransferLimit, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(EnergyHatchSize.REINFORCED.getSerializedName());
        this.REINFORCED_energy_size = builder.comment("Energy storage size of the energy hatch.").defineInRange("size", EnergyHatchSize.REINFORCED.defaultConfigurationEnergy, 1, Integer.MAX_VALUE);
        this.REINFORCED_energy_transferRate = builder.comment("Defines the transfer limit for RF/FE things. \nIC2's transfer limit is defined by the voltage tier.").defineInRange("transfer_rate", EnergyHatchSize.REINFORCED.defaultConfigurationTransferLimit, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(EnergyHatchSize.BIG.getSerializedName());
        this.BIG_energy_size = builder.comment("Energy storage size of the energy hatch.").defineInRange("size", EnergyHatchSize.BIG.defaultConfigurationEnergy, 1, Integer.MAX_VALUE);
        this.BIG_energy_transferRate = builder.comment("Defines the transfer limit for RF/FE things. \nIC2's transfer limit is defined by the voltage tier.").defineInRange("transfer_rate", EnergyHatchSize.BIG.defaultConfigurationTransferLimit, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(EnergyHatchSize.HUGE.getSerializedName());
        this.HUGE_energy_size = builder.comment("Energy storage size of the energy hatch.").defineInRange("size", EnergyHatchSize.HUGE.defaultConfigurationEnergy, 1, Integer.MAX_VALUE);
        this.HUGE_energy_transferRate = builder.comment("Defines the transfer limit for RF/FE things. \nIC2's transfer limit is defined by the voltage tier.").defineInRange("transfer_rate", EnergyHatchSize.HUGE.defaultConfigurationTransferLimit, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(EnergyHatchSize.LUDICROUS.getSerializedName());
        this.LUDICROUS_energy_size = builder.comment("Energy storage size of the energy hatch.").defineInRange("size", EnergyHatchSize.LUDICROUS.defaultConfigurationEnergy, 1, Integer.MAX_VALUE);
        this.LUDICROUS_energy_transferRate = builder.comment("Defines the transfer limit for RF/FE things. \nIC2's transfer limit is defined by the voltage tier.").defineInRange("transfer_rate", EnergyHatchSize.LUDICROUS.defaultConfigurationTransferLimit, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(EnergyHatchSize.ULTIMATE.getSerializedName());
        this.ULTIMATE_energy_size = builder.comment("Energy storage size of the energy hatch.").defineInRange("size", EnergyHatchSize.ULTIMATE.defaultConfigurationEnergy, 1, Integer.MAX_VALUE);
        this.ULTIMATE_energy_transferRate = builder.comment("Defines the transfer limit for RF/FE things. \nIC2's transfer limit is defined by the voltage tier.").defineInRange("transfer_rate", EnergyHatchSize.ULTIMATE.defaultConfigurationTransferLimit, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("Display");
        this.energy_displayFETooltip = builder.comment("Set to true, if the standard 'energy' FE (or RF) should be displayed in the tooltip of the energy hatch along with its transmission rates.").define("displayFETooltip", true);
        this.energy_displayIC2EUTooltip = builder.comment("Set to true, if IC2's energy EU should be displayed in the tooltip of the energy hatch. Will only have effect if IC2 is installed.").define("displayIC2EUTooltip", true);
        this.energy_type = builder.comment("Available options: 'FE', 'IC2_EU' - Default: FE - Set this to one of those 2 types to have GUI, recipe preview and energy be displayed in that type of energy in ALL ModularMachinery Reborn things.").defineEnum("type", (Enum)EnergyDisplayUtil.EnergyType.FE);
        builder.pop();
        builder.pop();
        builder.push("fluidHatch");
        builder.push(FluidHatchSize.TINY.getSerializedName());
        this.TINY_fluid_size = builder.comment("Defines the tank size of fluid hatch in mB").defineInRange("size", FluidHatchSize.TINY.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FluidHatchSize.SMALL.getSerializedName());
        this.SMALL_fluid_size = builder.comment("Defines the tank size of fluid hatch in mB").defineInRange("size", FluidHatchSize.SMALL.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FluidHatchSize.NORMAL.getSerializedName());
        this.NORMAL_fluid_size = builder.comment("Defines the tank size of fluid hatch in mB").defineInRange("size", FluidHatchSize.NORMAL.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FluidHatchSize.REINFORCED.getSerializedName());
        this.REINFORCED_fluid_size = builder.comment("Defines the tank size of fluid hatch in mB").defineInRange("size", FluidHatchSize.REINFORCED.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FluidHatchSize.BIG.getSerializedName());
        this.BIG_fluid_size = builder.comment("Defines the tank size of fluid hatch in mB").defineInRange("size", FluidHatchSize.BIG.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FluidHatchSize.HUGE.getSerializedName());
        this.HUGE_fluid_size = builder.comment("Defines the tank size of fluid hatch in mB").defineInRange("size", FluidHatchSize.HUGE.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FluidHatchSize.LUDICROUS.getSerializedName());
        this.LUDICROUS_fluid_size = builder.comment("Defines the tank size of fluid hatch in mB").defineInRange("size", FluidHatchSize.LUDICROUS.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(FluidHatchSize.VACUUM.getSerializedName());
        this.VACUUM_fluid_size = builder.comment("Defines the tank size of fluid hatch in mB").defineInRange("size", FluidHatchSize.VACUUM.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.pop();
        builder.push("itemBus");
        builder.push("container");
        this.itemSlotXOffset = builder.comment("Defines the container X offset relative to top-left corner of the texture").defineInRange("xOffset", 8, 0, Integer.MAX_VALUE);
        this.itemSlotYOffset = builder.comment("Defines the container Y offset relative to top-left corner of the texture").defineInRange("yOffset", 8, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemBusSize.TINY.getSerializedName());
        this.TINY_item_size = builder.comment("Defines the slots number of item bus").defineInRange("slots", ItemBusSize.TINY.defaultSlots, 1, Integer.MAX_VALUE);
        this.TINY_item_cols = builder.comment("Defines the slot cols number of item bus").defineInRange("cols", ItemBusSize.TINY.defaultCols, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemBusSize.SMALL.getSerializedName());
        this.SMALL_item_size = builder.comment("Defines the slots number of item bus").defineInRange("slots", ItemBusSize.SMALL.defaultSlots, 1, Integer.MAX_VALUE);
        this.SMALL_item_cols = builder.comment("Defines the slot cols number of item bus").defineInRange("cols", ItemBusSize.SMALL.defaultCols, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemBusSize.NORMAL.getSerializedName());
        this.NORMAL_item_size = builder.comment("Defines the slots number of item bus").defineInRange("slots", ItemBusSize.NORMAL.defaultSlots, 1, Integer.MAX_VALUE);
        this.NORMAL_item_cols = builder.comment("Defines the slot cols number of item bus").defineInRange("cols", ItemBusSize.NORMAL.defaultCols, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemBusSize.REINFORCED.getSerializedName());
        this.REINFORCED_item_size = builder.comment("Defines the slots number of item bus").defineInRange("slots", ItemBusSize.REINFORCED.defaultSlots, 1, Integer.MAX_VALUE);
        this.REINFORCED_item_cols = builder.comment("Defines the slot cols number of item bus").defineInRange("cols", ItemBusSize.REINFORCED.defaultCols, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemBusSize.BIG.getSerializedName());
        this.BIG_item_size = builder.comment("Defines the slots number of item bus").defineInRange("slots", ItemBusSize.BIG.defaultSlots, 1, Integer.MAX_VALUE);
        this.BIG_item_cols = builder.comment("Defines the slot cols number of item bus").defineInRange("cols", ItemBusSize.BIG.defaultCols, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemBusSize.HUGE.getSerializedName());
        this.HUGE_item_size = builder.comment("Defines the slots number of item bus").defineInRange("slots", ItemBusSize.HUGE.defaultSlots, 1, Integer.MAX_VALUE);
        this.HUGE_item_cols = builder.comment("Defines the slot cols number of item bus").defineInRange("cols", ItemBusSize.HUGE.defaultCols, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemBusSize.LUDICROUS.getSerializedName());
        this.LUDICROUS_item_size = builder.comment("Defines the slots number of item bus").defineInRange("slots", ItemBusSize.LUDICROUS.defaultSlots, 1, Integer.MAX_VALUE);
        this.LUDICROUS_item_cols = builder.comment("Defines the slot cols number of item bus").defineInRange("cols", ItemBusSize.LUDICROUS.defaultCols, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.pop();
        builder.push("durabilityHatch");
        builder.push(ItemDurabilityHatchSize.TINY.getSerializedName());
        this.TINY_durability_size = builder.comment("Defines the slots number of item durability hatch").defineInRange("slots", ItemDurabilityHatchSize.TINY.defaultSlots, 1, Integer.MAX_VALUE);
        this.TINY_durability_cols = builder.comment("Defines the slot cols number of item durability hatch").defineInRange("cols", ItemBusSize.TINY.defaultCols, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemDurabilityHatchSize.SMALL.getSerializedName());
        this.SMALL_durability_size = builder.comment("Defines the slots number of item durability hatch").defineInRange("slots", ItemDurabilityHatchSize.SMALL.defaultSlots, 1, Integer.MAX_VALUE);
        this.SMALL_durability_cols = builder.comment("Defines the slot cols number of item durability hatch").defineInRange("cols", ItemDurabilityHatchSize.SMALL.defaultCols, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemDurabilityHatchSize.NORMAL.getSerializedName());
        this.NORMAL_durability_size = builder.comment("Defines the slots number of item durability hatch").defineInRange("slots", ItemDurabilityHatchSize.NORMAL.defaultSlots, 1, Integer.MAX_VALUE);
        this.NORMAL_durability_cols = builder.comment("Defines the slot cols number of item durability hatch").defineInRange("cols", ItemDurabilityHatchSize.NORMAL.defaultCols, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ItemDurabilityHatchSize.BIG.getSerializedName());
        this.BIG_durability_size = builder.comment("Defines the slots number of item durability hatch").defineInRange("slots", ItemDurabilityHatchSize.BIG.defaultSlots, 1, Integer.MAX_VALUE);
        this.BIG_durability_cols = builder.comment("Defines the slot cols number of item durability hatch").defineInRange("cols", ItemDurabilityHatchSize.BIG.defaultCols, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.pop();
        builder.push("experienceHatch");
        builder.push(ExperienceHatchSize.TINY.getSerializedName());
        this.TINY_experience_size = builder.comment("Defines the Experience Hatch").defineInRange("capacity", ExperienceHatchSize.TINY.defaultCapacity, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ExperienceHatchSize.SMALL.getSerializedName());
        this.SMALL_experience_size = builder.comment("Defines the Experience Hatch").defineInRange("capacity", ExperienceHatchSize.SMALL.defaultCapacity, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ExperienceHatchSize.NORMAL.getSerializedName());
        this.NORMAL_experience_size = builder.comment("Defines the Experience Hatch").defineInRange("capacity", ExperienceHatchSize.NORMAL.defaultCapacity, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ExperienceHatchSize.REINFORCED.getSerializedName());
        this.REINFORCED_experience_size = builder.comment("Defines the Experience Hatch").defineInRange("capacity", ExperienceHatchSize.REINFORCED.defaultCapacity, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ExperienceHatchSize.BIG.getSerializedName());
        this.BIG_experience_size = builder.comment("Defines the Experience Hatch").defineInRange("capacity", ExperienceHatchSize.BIG.defaultCapacity, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ExperienceHatchSize.HUGE.getSerializedName());
        this.HUGE_experience_size = builder.comment("Defines the Experience Hatch").defineInRange("capacity", ExperienceHatchSize.HUGE.defaultCapacity, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ExperienceHatchSize.LUDICROUS.getSerializedName());
        this.LUDICROUS_experience_size = builder.comment("Defines the Experience Hatch").defineInRange("capacity", ExperienceHatchSize.LUDICROUS.defaultCapacity, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ExperienceHatchSize.VACUUM.getSerializedName());
        this.VACUUM_experience_size = builder.comment("Defines the Experience Hatch").defineInRange("capacity", ExperienceHatchSize.VACUUM.defaultCapacity, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.pop();
        builder.push("parallel hatch");
        builder.push(ParallelHatchSize.BASIC.getSerializedName());
        this.BASIC_parallel = builder.comment("Defined the max amount of running recipes").defineInRange("max", ParallelHatchSize.BASIC.defaultMax, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ParallelHatchSize.MEDIUM.getSerializedName());
        this.MEDIUM_parallel = builder.comment("Defined the max amount of running recipes").defineInRange("max", ParallelHatchSize.MEDIUM.defaultMax, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ParallelHatchSize.ADVANCED.getSerializedName());
        this.ADVANCED_parallel = builder.comment("Defined the max amount of running recipes").defineInRange("max", ParallelHatchSize.ADVANCED.defaultMax, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ParallelHatchSize.ULTIMATE.getSerializedName());
        this.ULTIMATE_parallel = builder.comment("Defined the max amount of running recipes").defineInRange("max", ParallelHatchSize.ULTIMATE.defaultMax, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(ParallelHatchSize.MAX.getSerializedName());
        this.MAX_parallel = builder.comment("Defined the max amount of running recipes").defineInRange("max", ParallelHatchSize.MAX.defaultMax, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.pop();
    }

    public int fluidSize(FluidHatchSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case FluidHatchSize.TINY -> (Integer)this.TINY_fluid_size.get();
            case FluidHatchSize.SMALL -> (Integer)this.SMALL_fluid_size.get();
            case FluidHatchSize.NORMAL -> (Integer)this.NORMAL_fluid_size.get();
            case FluidHatchSize.REINFORCED -> (Integer)this.REINFORCED_fluid_size.get();
            case FluidHatchSize.BIG -> (Integer)this.BIG_fluid_size.get();
            case FluidHatchSize.HUGE -> (Integer)this.HUGE_fluid_size.get();
            case FluidHatchSize.LUDICROUS -> (Integer)this.LUDICROUS_fluid_size.get();
            case FluidHatchSize.VACUUM -> (Integer)this.VACUUM_fluid_size.get();
        };
    }

    public int itemSize(ItemBusSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case ItemBusSize.TINY -> (Integer)this.TINY_item_size.get();
            case ItemBusSize.SMALL -> (Integer)this.SMALL_item_size.get();
            case ItemBusSize.NORMAL -> (Integer)this.NORMAL_item_size.get();
            case ItemBusSize.REINFORCED -> (Integer)this.REINFORCED_item_size.get();
            case ItemBusSize.BIG -> (Integer)this.BIG_item_size.get();
            case ItemBusSize.HUGE -> (Integer)this.HUGE_item_size.get();
            case ItemBusSize.LUDICROUS -> (Integer)this.LUDICROUS_item_size.get();
        };
    }

    public int durabilitySize(ItemDurabilityHatchSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case ItemDurabilityHatchSize.TINY -> (Integer)this.TINY_durability_size.get();
            case ItemDurabilityHatchSize.SMALL -> (Integer)this.SMALL_durability_size.get();
            case ItemDurabilityHatchSize.NORMAL -> (Integer)this.NORMAL_durability_size.get();
            case ItemDurabilityHatchSize.BIG -> (Integer)this.BIG_durability_size.get();
        };
    }

    public int itemCols(ItemBusSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case ItemBusSize.TINY -> (Integer)this.TINY_item_cols.get();
            case ItemBusSize.SMALL -> (Integer)this.SMALL_item_cols.get();
            case ItemBusSize.NORMAL -> (Integer)this.NORMAL_item_cols.get();
            case ItemBusSize.REINFORCED -> (Integer)this.REINFORCED_item_cols.get();
            case ItemBusSize.BIG -> (Integer)this.BIG_item_cols.get();
            case ItemBusSize.HUGE -> (Integer)this.HUGE_item_cols.get();
            case ItemBusSize.LUDICROUS -> (Integer)this.LUDICROUS_item_cols.get();
        };
    }

    public int durabilityCols(ItemDurabilityHatchSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case ItemDurabilityHatchSize.TINY -> (Integer)this.TINY_durability_cols.get();
            case ItemDurabilityHatchSize.SMALL -> (Integer)this.SMALL_durability_cols.get();
            case ItemDurabilityHatchSize.NORMAL -> (Integer)this.NORMAL_durability_cols.get();
            case ItemDurabilityHatchSize.BIG -> (Integer)this.BIG_durability_cols.get();
        };
    }

    public long energySize(EnergyHatchSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case EnergyHatchSize.TINY -> ((Integer)this.TINY_energy_size.get()).intValue();
            case EnergyHatchSize.SMALL -> ((Integer)this.SMALL_energy_size.get()).intValue();
            case EnergyHatchSize.NORMAL -> ((Integer)this.NORMAL_energy_size.get()).intValue();
            case EnergyHatchSize.REINFORCED -> ((Integer)this.REINFORCED_energy_size.get()).intValue();
            case EnergyHatchSize.BIG -> ((Integer)this.BIG_energy_size.get()).intValue();
            case EnergyHatchSize.HUGE -> ((Integer)this.HUGE_energy_size.get()).intValue();
            case EnergyHatchSize.LUDICROUS -> ((Integer)this.LUDICROUS_energy_size.get()).intValue();
            case EnergyHatchSize.ULTIMATE -> ((Integer)this.ULTIMATE_energy_size.get()).intValue();
        };
    }

    public long energyLimit(EnergyHatchSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case EnergyHatchSize.TINY -> ((Integer)this.TINY_energy_transferRate.get()).intValue();
            case EnergyHatchSize.SMALL -> ((Integer)this.SMALL_energy_transferRate.get()).intValue();
            case EnergyHatchSize.NORMAL -> ((Integer)this.NORMAL_energy_transferRate.get()).intValue();
            case EnergyHatchSize.REINFORCED -> ((Integer)this.REINFORCED_energy_transferRate.get()).intValue();
            case EnergyHatchSize.BIG -> ((Integer)this.BIG_energy_transferRate.get()).intValue();
            case EnergyHatchSize.HUGE -> ((Integer)this.HUGE_energy_transferRate.get()).intValue();
            case EnergyHatchSize.LUDICROUS -> ((Integer)this.LUDICROUS_energy_transferRate.get()).intValue();
            case EnergyHatchSize.ULTIMATE -> ((Integer)this.ULTIMATE_energy_transferRate.get()).intValue();
        };
    }

    public int experienceSize(ExperienceHatchSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case ExperienceHatchSize.TINY -> (Integer)this.TINY_experience_size.get();
            case ExperienceHatchSize.SMALL -> (Integer)this.SMALL_experience_size.get();
            case ExperienceHatchSize.NORMAL -> (Integer)this.NORMAL_experience_size.get();
            case ExperienceHatchSize.REINFORCED -> (Integer)this.REINFORCED_experience_size.get();
            case ExperienceHatchSize.BIG -> (Integer)this.BIG_experience_size.get();
            case ExperienceHatchSize.HUGE -> (Integer)this.HUGE_experience_size.get();
            case ExperienceHatchSize.LUDICROUS -> (Integer)this.LUDICROUS_experience_size.get();
            case ExperienceHatchSize.VACUUM -> (Integer)this.VACUUM_experience_size.get();
        };
    }

    public int maxParallel(ParallelHatchSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case ParallelHatchSize.BASIC -> (Integer)this.BASIC_parallel.get();
            case ParallelHatchSize.MEDIUM -> (Integer)this.MEDIUM_parallel.get();
            case ParallelHatchSize.ADVANCED -> (Integer)this.ADVANCED_parallel.get();
            case ParallelHatchSize.ULTIMATE -> (Integer)this.ULTIMATE_parallel.get();
            case ParallelHatchSize.MAX -> (Integer)this.MAX_parallel.get();
        };
    }

    public int getMaxParallel() {
        int max = (Integer)this.BASIC_parallel.get();
        for (ParallelHatchSize size : ParallelHatchSize.values()) {
            int probable = this.maxParallel(size);
            if (probable <= max) continue;
            max = probable;
        }
        return max;
    }

    @Generated
    public static ModConfigSpec getSpec() {
        return spec;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(MMRConfig::new);
        INSTANCE = (MMRConfig)pair.getLeft();
        spec = (ModConfigSpec)pair.getRight();
    }
}

