/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity.base;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.client.model.hatch.HatchBakedModel;
import es.degrassi.mmreborn.common.block.prop.FluidHatchSize;
import es.degrassi.mmreborn.common.entity.FluidInputHatchEntity;
import es.degrassi.mmreborn.common.entity.base.CapabilityInventoryEntity;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.IServerTickEntity;
import es.degrassi.mmreborn.common.entity.base.ITickEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineHatchType;
import es.degrassi.mmreborn.common.machine.component.FluidComponent;
import es.degrassi.mmreborn.common.network.server.SUpdateMachineTexturePacket;
import es.degrassi.mmreborn.common.registration.MachineHatchTypeRegistration;
import es.degrassi.mmreborn.common.util.HybridTank;
import es.degrassi.mmreborn.common.util.IOInventory;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class FluidTankEntity
extends ColorableMachineComponentEntity
implements MachineComponentEntity<FluidComponent>,
ControllerAccessible,
TextureableMachineEntity,
CapabilityInventoryEntity<IFluidHandlerItem>,
ITickEntity,
IServerTickEntity {
    private HybridTank tank;
    private IOType ioType;
    private FluidHatchSize hatchSize;
    private BlockPos controllerPos;
    private ResourceLocation baseTexture;
    private ResourceLocation overlayTexture;
    private ResourceLocation defaultOverlayTexture;
    private static final ResourceLocation defaultBaseTexture = ModularMachineryReborn.rl("block/casing_plain");
    private final IOInventory capabilityInventory;
    private final long tickOffset = Utils.RAND.nextIntBetweenInclusive(0, 0x7FFFFFFE);
    private long lastCheckTick;

    protected FluidTankEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, FluidHatchSize size, IOType ioType) {
        super(type, pos, state);
        this.tank = size.buildTank(this, ioType == IOType.INPUT, ioType == IOType.OUTPUT);
        this.hatchSize = size;
        this.ioType = ioType;
        this.overlayTexture = this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_fluid" + ioType.getSerializedName() + "hatch_" + size.getSerializedName());
        this.capabilityInventory = this.createCapabilityInventory();
        this.tank.setListener(() -> {
            if (this.getController() != null) {
                this.getController().getProcessor().setMachineInventoryChanged();
            }
        });
    }

    @Override
    public ItemCapability<IFluidHandlerItem, Void> getCapability() {
        return Capabilities.FluidHandler.ITEM;
    }

    @Override
    public void doRestrictedTick() {
        IServerTickEntity.super.doRestrictedTick();
        this.tickInventory();
    }

    @Override
    public void tickInventory() {
        if (!this.shouldTickInventory()) {
            return;
        }
        this.capabilityInventory.getInventory().forEach(slot -> Optional.ofNullable((IFluidHandlerItem)slot.getItemStack().getCapability(this.getCapability())).ifPresent(cap -> {
            if (this.ioType == IOType.NONE) {
                return;
            }
            if (this.ioType.isInput()) {
                if (this.getTank().getFluidAmount() >= this.getTank().getCapacity()) {
                    return;
                }
                Item patt0$temp = slot.getItemStack().getItem();
                if (patt0$temp instanceof BucketItem) {
                    BucketItem bucket = (BucketItem)patt0$temp;
                    if (bucket.content.isSame(Fluids.EMPTY)) {
                        return;
                    }
                    FluidStack fluid = new FluidStack(bucket.content, 1000);
                    int simulatedInsert = this.getTank().fill(fluid.copy(), IFluidHandler.FluidAction.SIMULATE);
                    if (simulatedInsert < 1000) {
                        return;
                    }
                    slot.setItemStack(new ItemStack((ItemLike)Items.BUCKET));
                    this.getTank().fill(fluid.copy(), IFluidHandler.FluidAction.EXECUTE);
                } else {
                    FluidStack simulatedCap = cap.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                    int simulatedInsert = this.getTank().fill(simulatedCap.copy(), IFluidHandler.FluidAction.SIMULATE);
                    cap.drain(simulatedCap.copyWithAmount(simulatedInsert), IFluidHandler.FluidAction.EXECUTE);
                    this.getTank().fill(simulatedCap.copyWithAmount(simulatedInsert), IFluidHandler.FluidAction.EXECUTE);
                }
            } else if (this.ioType.isOutput()) {
                if (this.getTank().getFluidAmount() == 0) {
                    return;
                }
                Item patt0$temp = slot.getItemStack().getItem();
                if (patt0$temp instanceof BucketItem) {
                    BucketItem bucket = (BucketItem)patt0$temp;
                    if (!bucket.content.isSame(Fluids.EMPTY)) {
                        return;
                    }
                    simulatedExtract = this.getTank().drain(1000, IFluidHandler.FluidAction.SIMULATE);
                    ItemStack fluidStack = BuiltInRegistries.ITEM.stream().filter(item -> {
                        if (!(item instanceof BucketItem)) return false;
                        BucketItem b = (BucketItem)item;
                        if (!b.content.isSame(simulatedExtract.getFluid())) return false;
                        return true;
                    }).findFirst().map(ItemStack::new).orElse(ItemStack.EMPTY);
                    if (fluidStack.isEmpty() || simulatedExtract.isEmpty() || simulatedExtract.getAmount() < 1000) {
                        return;
                    }
                    slot.setItemStack(fluidStack);
                    this.getTank().drain(simulatedExtract, IFluidHandler.FluidAction.EXECUTE);
                } else {
                    simulatedExtract = this.getTank().drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                    int simulatedCap = cap.fill(simulatedExtract.copy(), IFluidHandler.FluidAction.SIMULATE);
                    cap.fill(simulatedExtract.copyWithAmount(simulatedCap), IFluidHandler.FluidAction.EXECUTE);
                    this.getTank().drain(simulatedExtract.copyWithAmount(simulatedCap), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }));
    }

    @Override
    public IOType getMode() {
        return this.ioType;
    }

    @Override
    public boolean shouldTickInventory() {
        long gameTime = this.getLevel().getGameTime();
        if (!Utils.shouldRunPeriodicCheck(false, gameTime, this.lastCheckTick, this.tickOffset, 2L)) {
            return false;
        }
        this.lastCheckTick = gameTime;
        return true;
    }

    @Override
    public FluidComponent provideComponent() {
        return new FluidComponent(this.getTank(), this.ioType);
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.ioType = IOType.getByString(compound.getString("ioType"));
        this.hatchSize = FluidHatchSize.value(compound.getString("size"));
        HybridTank newTank = this.hatchSize.buildTank(this, this.ioType == IOType.INPUT, this.ioType == IOType.OUTPUT);
        CompoundTag tankTag = compound.getCompound("tank");
        newTank.readFromNBT(provider, tankTag);
        this.tank = newTank;
        if (compound.contains("controllerPos")) {
            this.controllerPos = BlockPos.of((long)compound.getLong("controllerPos"));
        }
        this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_fluid" + this.ioType.getSerializedName() + "hatch_" + this.hatchSize.getSerializedName());
        this.baseTexture = compound.contains("baseTexture") ? ResourceLocation.parse((String)compound.getString("baseTexture")) : defaultBaseTexture;
        this.overlayTexture = compound.contains("overlayTexture") ? ResourceLocation.parse((String)compound.getString("overlayTexture")) : this.defaultOverlayTexture;
        this.tank.setListener(() -> {
            if (this.getController() != null) {
                this.getController().getProcessor().setMachineInventoryChanged();
            }
        });
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.ioType == null) {
            this.ioType = this instanceof FluidInputHatchEntity ? IOType.INPUT : IOType.OUTPUT;
        }
        compound.putString("ioType", this.ioType.getSerializedName());
        compound.putString("size", this.hatchSize.getSerializedName());
        CompoundTag tankTag = new CompoundTag();
        this.tank.writeToNBT(provider, tankTag);
        compound.put("tank", (Tag)tankTag);
        if (this.controllerPos != null) {
            compound.putLong("controllerPos", this.controllerPos.asLong());
        }
        if (this.baseTexture != null) {
            compound.putString("baseTexture", this.baseTexture.toString());
        }
        if (this.overlayTexture != null) {
            compound.putString("overlayTexture", this.overlayTexture.toString());
        }
    }

    @Override
    public void setControllerPos(BlockPos pos) {
        this.controllerPos = pos;
    }

    public ModelData getModelData() {
        ModelData.Builder builder = this.getModelDataBuilder("all");
        builder.with(HatchBakedModel.BASE_TEXTURE, (Object)this.baseTexture).with(HatchBakedModel.BASE_TEXTURE_NAME, (Object)"bg_all");
        builder.with(HatchBakedModel.OVERLAY_TEXTURE, (Object)this.overlayTexture).with(HatchBakedModel.OVERLAY_TEXTURE_NAME, (Object)"ov_all");
        return builder.build();
    }

    @Override
    public ResourceLocation getMachineBaseTexture() {
        return this.baseTexture;
    }

    @Override
    public ResourceLocation getMachineOverlayTexture() {
        return this.overlayTexture;
    }

    @Override
    public void setMachineBaseTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.baseTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.baseTexture, true, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void setMachineOverlayTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.overlayTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.overlayTexture, false, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void resetTextures() {
        this.setMachineBaseTexture(defaultBaseTexture);
        this.setMachineOverlayTexture(this.defaultOverlayTexture);
    }

    @Override
    public MachineHatchType getHatchType() {
        return switch (this.ioType) {
            case IOType.INPUT -> {
                Supplier<MachineHatchType> v0 = switch (this.hatchSize) {
                    default -> throw new MatchException(null, null);
                    case FluidHatchSize.TINY -> MachineHatchTypeRegistration.FLUID_INPUT_HATCH_TINY;
                    case FluidHatchSize.SMALL -> MachineHatchTypeRegistration.FLUID_INPUT_HATCH_SMALL;
                    case FluidHatchSize.NORMAL -> MachineHatchTypeRegistration.FLUID_INPUT_HATCH_NORMAL;
                    case FluidHatchSize.REINFORCED -> MachineHatchTypeRegistration.FLUID_INPUT_HATCH_REINFORCED;
                    case FluidHatchSize.BIG -> MachineHatchTypeRegistration.FLUID_INPUT_HATCH_BIG;
                    case FluidHatchSize.HUGE -> MachineHatchTypeRegistration.FLUID_INPUT_HATCH_HUGE;
                    case FluidHatchSize.LUDICROUS -> MachineHatchTypeRegistration.FLUID_INPUT_HATCH_LUDICROUS;
                    case FluidHatchSize.VACUUM -> MachineHatchTypeRegistration.FLUID_INPUT_HATCH_VACUUM;
                };
                yield v0.get();
            }
            case IOType.OUTPUT -> {
                Supplier<MachineHatchType> v2 = switch (this.hatchSize) {
                    default -> throw new MatchException(null, null);
                    case FluidHatchSize.TINY -> MachineHatchTypeRegistration.FLUID_OUTPUT_HATCH_TINY;
                    case FluidHatchSize.SMALL -> MachineHatchTypeRegistration.FLUID_OUTPUT_HATCH_SMALL;
                    case FluidHatchSize.NORMAL -> MachineHatchTypeRegistration.FLUID_OUTPUT_HATCH_NORMAL;
                    case FluidHatchSize.REINFORCED -> MachineHatchTypeRegistration.FLUID_OUTPUT_HATCH_REINFORCED;
                    case FluidHatchSize.BIG -> MachineHatchTypeRegistration.FLUID_OUTPUT_HATCH_BIG;
                    case FluidHatchSize.HUGE -> MachineHatchTypeRegistration.FLUID_OUTPUT_HATCH_HUGE;
                    case FluidHatchSize.LUDICROUS -> MachineHatchTypeRegistration.FLUID_OUTPUT_HATCH_LUDICROUS;
                    case FluidHatchSize.VACUUM -> MachineHatchTypeRegistration.FLUID_INPUT_HATCH_VACUUM;
                };
                yield v2.get();
            }
            default -> null;
        };
    }

    @Generated
    public HybridTank getTank() {
        return this.tank;
    }

    @Generated
    public IOType getIoType() {
        return this.ioType;
    }

    @Generated
    public FluidHatchSize getHatchSize() {
        return this.hatchSize;
    }

    @Override
    @Generated
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Generated
    public long getTickOffset() {
        return this.tickOffset;
    }

    @Generated
    public long getLastCheckTick() {
        return this.lastCheckTick;
    }

    @Generated
    public void setTank(HybridTank tank) {
        this.tank = tank;
    }

    @Generated
    public void setIoType(IOType ioType) {
        this.ioType = ioType;
    }

    @Generated
    public void setHatchSize(FluidHatchSize hatchSize) {
        this.hatchSize = hatchSize;
    }

    @Generated
    public void setDefaultOverlayTexture(ResourceLocation defaultOverlayTexture) {
        this.defaultOverlayTexture = defaultOverlayTexture;
    }

    @Generated
    public void setLastCheckTick(long lastCheckTick) {
        this.lastCheckTick = lastCheckTick;
    }

    @Generated
    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    @Generated
    public void setBaseTexture(ResourceLocation baseTexture) {
        this.baseTexture = baseTexture;
    }

    @Generated
    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    @Generated
    public void setOverlayTexture(ResourceLocation overlayTexture) {
        this.overlayTexture = overlayTexture;
    }

    @Generated
    public ResourceLocation getDefaultOverlayTexture() {
        return this.defaultOverlayTexture;
    }

    @Generated
    public static ResourceLocation getDefaultBaseTexture() {
        return defaultBaseTexture;
    }

    @Override
    @Generated
    public IOInventory getCapabilityInventory() {
        return this.capabilityInventory;
    }
}

