/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.jei.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.client.container.ControllerContainer;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementItem;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.ItemComponent;
import es.degrassi.mmreborn.common.network.client.emi.FillRecipeC2SPacket;
import es.degrassi.mmreborn.common.registration.ContainerRegistration;
import es.degrassi.mmreborn.common.util.MMRLogger;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MMRJeiRecipeTransferHandler
implements IRecipeTransferHandler<ControllerContainer, MachineRecipe>,
IRecipeTransferInfo<ControllerContainer, MachineRecipe> {
    private final RecipeType<MachineRecipe> type;
    private final IRecipeTransferHandlerHelper helper;
    public static final Component NO_ITEMS = Component.translatable((String)"mmr.emi.no_items");
    public static final Component ERROR_INGREDIENT = Component.translatable((String)"jei.tooltip.error.recipe.transfer.missing");
    private static final Map<ControllerContainer, List<Slot>> slots = Maps.newHashMap();

    public MMRJeiRecipeTransferHandler(ResourceLocation machine, IRecipeTransferHandlerHelper helper, RecipeType<MachineRecipe> type) {
        this.type = type;
        this.helper = helper;
    }

    public Class<? extends ControllerContainer> getContainerClass() {
        return ControllerContainer.class;
    }

    public Optional<MenuType<ControllerContainer>> getMenuType() {
        return Optional.of((MenuType)ContainerRegistration.CONTROLLER.get());
    }

    public RecipeType<MachineRecipe> getRecipeType() {
        return this.type;
    }

    public boolean canHandle(ControllerContainer container, MachineRecipe recipe) {
        return true;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(ControllerContainer container, MachineRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        ModularMachineryReborn.LOGGER.debug("trying to transfer recipe...");
        if (!this.helper.recipeTransferHasServerSupport()) {
            return this.helper.createUserErrorWithTooltip((Component)Component.translatable((String)"jei.tooltip.error.recipe.transfer.no.server"));
        }
        ModularMachineryReborn.LOGGER.debug("jei is on server to fill recipe correctly");
        if (!this.canHandle(container, recipe)) {
            ModularMachineryReborn.LOGGER.debug("this is not a valid recipe for actual menu");
            IRecipeTransferError handlingError = this.getHandlingError(container, recipe);
            if (handlingError != null) {
                return handlingError;
            }
            return this.helper.createInternalError();
        }
        List<ItemStack> stacks = this.getStacks(recipe, container, 1);
        ModularMachineryReborn.LOGGER.debug("getted stacks to process: {}", stacks.stream().map(ItemStack::getDisplayName).map(Component::getString).toList());
        if (!stacks.isEmpty()) {
            ModularMachineryReborn.LOGGER.debug("trying to actually fill recipe");
            return this.clientFill(recipe, container, stacks, recipeSlots, doTransfer);
        }
        return this.helper.createInternalError();
    }

    public void sendFillRecipe(ControllerContainer screenHandler, int action, List<ItemStack> stacks, MachineRecipe recipe) {
        PacketDistributor.sendToServer((CustomPacketPayload)new FillRecipeC2SPacket(screenHandler, action, this.getInventorySlots(screenHandler, recipe), this.getRecipeSlots(screenHandler, recipe), null, stacks), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Nullable
    public IRecipeTransferError clientFill(MachineRecipe recipe, ControllerContainer container, List<ItemStack> stacks, IRecipeSlotsView recipeSlots, boolean doTransfer) {
        List<IRecipeSlotView> filteredSlots = recipeSlots.getSlotViews(RecipeIngredientRole.INPUT).stream().filter(slot -> slot.getAllIngredients().allMatch(ing -> ing.getType().equals((Object)VanillaTypes.ITEM_STACK))).toList();
        if (filteredSlots.isEmpty()) {
            ModularMachineryReborn.LOGGER.debug("no items in the current recipe");
            return this.helper.createUserErrorWithTooltip(NO_ITEMS);
        }
        ArrayList errorSlots = Lists.newArrayList();
        List<SizedIngredient> ingredients = recipe.getRequirements().stream().map(RecipeRequirement::requirement).filter(req -> req instanceof RequirementItem).map(req -> (RequirementItem)req).map(RequirementItem::getIngredient).toList();
        filteredSlots.forEach(slot -> {
            if (ingredients.stream().noneMatch(ingredient -> slot.getItemStacks().noneMatch(arg_0 -> ((SizedIngredient)ingredient).test(arg_0)))) {
                errorSlots.add(slot);
            }
        });
        if (!errorSlots.isEmpty()) {
            ModularMachineryReborn.LOGGER.debug("recipe has missing ingredients, sending slots with missing ingredients...");
            return this.helper.createUserErrorForMissingSlots(ERROR_INGREDIENT, (Collection)errorSlots);
        }
        if (doTransfer) {
            ModularMachineryReborn.LOGGER.debug("sending packet to fill recipe...");
            this.sendFillRecipe(container, 2, stacks, recipe);
        }
        return null;
    }

    public List<ItemStack> getStacks(MachineRecipe recipe, ControllerContainer screenHandler, int amount) {
        ArrayList stacks = Lists.newArrayList();
        try {
            ((MachineControllerEntity)screenHandler.getEntity()).getComponentManager().getItemComponent(IOType.INPUT).map(ItemComponent::getContainerProvider).ifPresent(inventory -> {
                HashMap ingredientsMap = Maps.newHashMap();
                recipe.getRecipeRequirements().stream().map(RecipeRequirement::requirement).filter(req -> req instanceof RequirementItem).map(req -> (RequirementItem)req).forEach(req -> ingredientsMap.put(req.getIngredient(), req.isUsesDataComponents()));
                Player player = screenHandler.getPlayer();
                List ingredients = ingredientsMap.keySet().stream().toList();
                List<Slot> slots = inventory.createSlots(player);
                List<Slot> crafting = inventory.createInventorySlots(Lists.newArrayList(), 0);
                ModularMachineryReborn.LOGGER.debug("slots: {}", slots);
                ModularMachineryReborn.LOGGER.debug("craftingSlots: {}", crafting);
                ArrayList discovered = Lists.newArrayList();
                Object2IntOpenHashMap weightDivider = new Object2IntOpenHashMap();
                for (int i = 0; i < ingredients.size(); ++i) {
                    ArrayList d = Lists.newArrayList();
                    SizedIngredient ingredient = (SizedIngredient)ingredients.get(i);
                    ItemStack[] itemStacks = ingredient.getItems();
                    if (ingredient.ingredient().isEmpty()) {
                        discovered.add(null);
                        continue;
                    }
                    for (ItemStack stack : itemStacks) {
                        block2: for (Slot slot : slots) {
                            ItemStack is = slot.getItem();
                            if (!ItemStack.matches((ItemStack)is, (ItemStack)stack)) continue;
                            Iterator iterator = d.iterator();
                            while (iterator.hasNext()) {
                                DiscoveredItem di = (DiscoveredItem)iterator.next();
                                if (!((Boolean)ingredientsMap.get(ingredient) != false ? ItemStack.isSameItemSameComponents((ItemStack)is, (ItemStack)di.stack) : ItemStack.isSameItem((ItemStack)is, (ItemStack)di.stack))) continue;
                                di.amount += is.getCount();
                                continue block2;
                            }
                            d.add(new DiscoveredItem(stack, is, is.getCount(), ingredient.count(), is.getMaxStackSize(), (Boolean)ingredientsMap.get(ingredient)));
                        }
                    }
                    DiscoveredItem biggest = null;
                    Iterator iterator = d.iterator();
                    while (iterator.hasNext()) {
                        DiscoveredItem di = (DiscoveredItem)iterator.next();
                        if (biggest == null) {
                            biggest = di;
                            continue;
                        }
                        int a = di.amount / (weightDivider.getOrDefault((Object)di.ingredient, 0) + di.consumed);
                        int ba = biggest.amount / (weightDivider.getOrDefault((Object)biggest.ingredient, 0) + biggest.consumed);
                        if (ba >= a) continue;
                        biggest = di;
                    }
                    if (biggest == null || i >= crafting.size()) {
                        return;
                    }
                    Slot slot = crafting.get(i);
                    if (slot == null) {
                        return;
                    }
                    weightDivider.put((Object)biggest.ingredient, weightDivider.getOrDefault((Object)biggest.ingredient, 0) + biggest.consumed);
                    biggest.max = Math.min(biggest.max, slot.getItem().getMaxStackSize());
                    discovered.add(biggest);
                }
                if (discovered.isEmpty()) {
                    return;
                }
                ArrayList unique = Lists.newArrayList();
                block5: for (DiscoveredItem di : discovered) {
                    if (di == null) continue;
                    for (DiscoveredItem ui : unique) {
                        if (!ItemStack.isSameItemSameComponents((ItemStack)di.stack, (ItemStack)ui.stack)) continue;
                        ui.consumed += di.consumed;
                        continue block5;
                    }
                    unique.add(new DiscoveredItem(di.ingredient, di.stack, di.amount, di.consumed, di.max, di.components));
                }
                int maxAmount = Integer.MAX_VALUE;
                for (DiscoveredItem ui : unique) {
                    maxAmount = Math.min(maxAmount, Math.min(ui.amount / ui.consumed, ui.max));
                }
                if ((maxAmount = Math.min(maxAmount, amount + this.batchesAlreadyPresent(recipe, screenHandler))) == 0) {
                    return;
                }
                for (DiscoveredItem di : discovered) {
                    if (di != null) {
                        ItemStack is = di.stack.copy();
                        int a = di.consumed * maxAmount;
                        is.setCount(a);
                        stacks.add(is);
                        continue;
                    }
                    stacks.add(ItemStack.EMPTY);
                }
            });
        }
        catch (Exception e) {
            MMRLogger.INSTANCE.error((Object)e);
        }
        return stacks;
    }

    public int batchesAlreadyPresent(MachineRecipe recipe, ControllerContainer screen) {
        List<SizedIngredient> ingredients = recipe.getRecipeRequirements().stream().map(RecipeRequirement::requirement).filter(req -> req instanceof RequirementItem).map(req -> (RequirementItem)req).map(RequirementItem::getIngredient).toList();
        ArrayList stacks = Lists.newArrayList();
        for (Slot slot : this.getRecipeSlots(screen, recipe)) {
            if (slot != null) {
                stacks.add(slot.getItem());
                continue;
            }
            stacks.add(ItemStack.EMPTY);
        }
        long amount = Long.MAX_VALUE;
        block1: for (int i = 0; i < ingredients.size(); ++i) {
            SizedIngredient input = ingredients.get(i);
            if (input.ingredient().isEmpty()) {
                if (((ItemStack)stacks.get(i)).isEmpty()) continue;
                return 0;
            }
            if (i >= stacks.size()) {
                return 0;
            }
            ItemStack es = (ItemStack)stacks.get(i);
            for (ItemStack v : input.getItems()) {
                if (v.isEmpty() || !ItemStack.matches((ItemStack)v, (ItemStack)es) || es.getCount() < v.getCount()) continue;
                amount = Math.min(amount, (long)(es.getCount() / v.getCount()));
                continue block1;
            }
            return 0;
        }
        if (amount < Long.MAX_VALUE && amount > 0L) {
            return (int)amount;
        }
        return 0;
    }

    public static List<Slot> getSlots(ControllerContainer handler) {
        return slots.computeIfAbsent(handler, MMRJeiRecipeTransferHandler::createSlots);
    }

    public List<Slot> getRecipeSlots(ControllerContainer container, MachineRecipe recipe) {
        List<Slot> slots = MMRJeiRecipeTransferHandler.getSlots(container);
        return slots.subList(36, slots.size());
    }

    public List<Slot> getInventorySlots(ControllerContainer container, MachineRecipe recipe) {
        return MMRJeiRecipeTransferHandler.getSlots(container);
    }

    private static List<Slot> createSlots(ControllerContainer handler) {
        return ((MachineControllerEntity)handler.getEntity()).getComponentManager().getItemComponent(IOType.INPUT).map(ItemComponent::getContainerProvider).map(inventory -> inventory.createSlots(handler.getPlayer())).stream().flatMap(Collection::stream).toList();
    }

    private static class DiscoveredItem {
        public ItemStack ingredient;
        public ItemStack stack;
        public int consumed;
        public int amount;
        public int max;
        public boolean components;

        public DiscoveredItem(ItemStack ingredient, ItemStack stack, int amount, int consumed, int max, boolean components) {
            this.ingredient = ingredient;
            this.stack = stack.copy();
            this.amount = amount;
            this.consumed = consumed;
            this.max = max;
            this.components = components;
        }
    }
}

