/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.kubejs;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.util.TickDuration;
import dev.latvian.mods.rhino.util.HideFromJS;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.integration.kubejs.ModularMachineryRebornRecipeSchemas;
import es.degrassi.mmreborn.common.integration.kubejs.RecipeJSBuilder;
import es.degrassi.mmreborn.common.integration.kubejs.requirement.BiomeRequirementJS;
import es.degrassi.mmreborn.common.integration.kubejs.requirement.ChunkloadRequirementJS;
import es.degrassi.mmreborn.common.integration.kubejs.requirement.DimensionRequirementJS;
import es.degrassi.mmreborn.common.integration.kubejs.requirement.DurabilityRequirementJS;
import es.degrassi.mmreborn.common.integration.kubejs.requirement.EmptyRequirementJS;
import es.degrassi.mmreborn.common.integration.kubejs.requirement.EnergyRequirementJS;
import es.degrassi.mmreborn.common.integration.kubejs.requirement.ExperienceRequirementJS;
import es.degrassi.mmreborn.common.integration.kubejs.requirement.FluidRequirementJS;
import es.degrassi.mmreborn.common.integration.kubejs.requirement.FunctionRequirementJS;
import es.degrassi.mmreborn.common.integration.kubejs.requirement.HeightRequirementJS;
import es.degrassi.mmreborn.common.integration.kubejs.requirement.ItemRequirementJS;
import es.degrassi.mmreborn.common.integration.kubejs.requirement.LootTableRequirementJS;
import es.degrassi.mmreborn.common.integration.kubejs.requirement.TimeRequirementJS;
import es.degrassi.mmreborn.common.integration.kubejs.requirement.WeatherRequirementJS;
import es.degrassi.mmreborn.common.registration.RecipeRegistration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.helpers.MessageFormatter;

public class MachineRecipeBuilderJS
extends KubeRecipe
implements RecipeJSBuilder,
EnergyRequirementJS,
ItemRequirementJS,
FluidRequirementJS,
DimensionRequirementJS,
BiomeRequirementJS,
WeatherRequirementJS,
TimeRequirementJS,
ChunkloadRequirementJS,
LootTableRequirementJS,
ExperienceRequirementJS,
HeightRequirementJS,
FunctionRequirementJS,
DurabilityRequirementJS,
EmptyRequirementJS {
    @HideFromJS
    public static final Map<ResourceLocation, Map<ResourceLocation, Integer>> IDS = Maps.newHashMap();
    @HideFromJS
    private boolean jei = false;

    @HideFromJS
    public MachineRecipeBuilderJS(ResourceLocation machine, int time, int width, int height, int progressX, int progressY) {
        this.setValue(ModularMachineryRebornRecipeSchemas.MACHINE_ID, machine);
        this.setValue(ModularMachineryRebornRecipeSchemas.TIME, new TickDuration((long)time));
        this.setValue(ModularMachineryRebornRecipeSchemas.PROGRESS_X, progressX);
        this.setValue(ModularMachineryRebornRecipeSchemas.PROGRESS_Y, progressY);
        this.setValue(ModularMachineryRebornRecipeSchemas.WIDTH, width);
        this.setValue(ModularMachineryRebornRecipeSchemas.HEIGHT, height);
        this.setValue(ModularMachineryRebornRecipeSchemas.SHOULD_RENDER_PROGRESS, true);
    }

    @HideFromJS
    public MachineRecipeBuilderJS(ResourceLocation machine, int time, int width, int height) {
        this.setValue(ModularMachineryRebornRecipeSchemas.MACHINE_ID, machine);
        this.setValue(ModularMachineryRebornRecipeSchemas.TIME, new TickDuration((long)time));
        this.setValue(ModularMachineryRebornRecipeSchemas.WIDTH, width);
        this.setValue(ModularMachineryRebornRecipeSchemas.HEIGHT, height);
        this.setValue(ModularMachineryRebornRecipeSchemas.SHOULD_RENDER_PROGRESS, true);
    }

    @HideFromJS
    public MachineRecipeBuilderJS(ResourceLocation machine, int time) {
        this.setValue(ModularMachineryRebornRecipeSchemas.MACHINE_ID, machine);
        this.setValue(ModularMachineryRebornRecipeSchemas.TIME, new TickDuration((long)time));
        this.setValue(ModularMachineryRebornRecipeSchemas.PROGRESS_X, 74);
        this.setValue(ModularMachineryRebornRecipeSchemas.PROGRESS_Y, 8);
        this.setValue(ModularMachineryRebornRecipeSchemas.WIDTH, 256);
        this.setValue(ModularMachineryRebornRecipeSchemas.HEIGHT, 256);
        this.setValue(ModularMachineryRebornRecipeSchemas.SHOULD_RENDER_PROGRESS, true);
    }

    @HideFromJS
    public MachineRecipeBuilderJS() {
    }

    @HideFromJS
    public void afterLoaded() {
        super.afterLoaded();
        ResourceLocation machine = (ResourceLocation)this.getValue(ModularMachineryRebornRecipeSchemas.MACHINE_ID);
        if (machine == null) {
            throw new KubeRuntimeException("Invalid machine id: " + String.valueOf(this.getValue(ModularMachineryRebornRecipeSchemas.MACHINE_ID)));
        }
        if (this.newRecipe) {
            int uniqueID = IDS.computeIfAbsent(RecipeRegistration.RECIPE_TYPE.getId(), id -> new HashMap()).computeIfAbsent(machine, m -> 0);
            IDS.get(RecipeRegistration.RECIPE_TYPE.getId()).put(machine, uniqueID + 1);
            this.id = ResourceLocation.fromNamespaceAndPath((String)"kubejs", (String)(RecipeRegistration.RECIPE_TYPE.getId().getPath() + "/" + machine.getNamespace() + "/" + machine.getPath() + "/" + uniqueID));
        }
    }

    @HideFromJS
    @Nullable
    public KubeRecipe serializeChanges() {
        if (!this.newRecipe) {
            return super.serializeChanges();
        }
        MachineRecipe.MachineRecipeBuilder builder = new MachineRecipe.MachineRecipeBuilder((ResourceLocation)this.getValue(ModularMachineryRebornRecipeSchemas.MACHINE_ID), (int)((TickDuration)this.getValue(ModularMachineryRebornRecipeSchemas.TIME)).ticks(), (Integer)this.getValue(ModularMachineryRebornRecipeSchemas.WIDTH), (Integer)this.getValue(ModularMachineryRebornRecipeSchemas.HEIGHT), new PositionedRequirement((Integer)this.getValue(ModularMachineryRebornRecipeSchemas.PROGRESS_X), (Integer)this.getValue(ModularMachineryRebornRecipeSchemas.PROGRESS_Y)));
        for (RecipeRequirement requirement : (List)this.getValue(ModularMachineryRebornRecipeSchemas.REQUIREMENTS)) {
            builder.addRequirement(requirement);
        }
        builder.addJeiRequirements((List)this.getValue(ModularMachineryRebornRecipeSchemas.JEI_REQUIREMENTS));
        if (((Boolean)this.getValue(ModularMachineryRebornRecipeSchemas.HIDE)).booleanValue()) {
            builder.hide();
        }
        builder.shouldRenderProgress((Boolean)this.getValue(ModularMachineryRebornRecipeSchemas.SHOULD_RENDER_PROGRESS));
        builder.withPriority((Integer)this.getValue(ModularMachineryRebornRecipeSchemas.PRIORITY));
        builder.shouldVoidOnFailure((Boolean)this.getValue(ModularMachineryRebornRecipeSchemas.VOID));
        this.id = this.getOrCreateId();
        DataResult result = MachineRecipe.CODEC.encodeStart((DynamicOps)this.type.event.registries.json(), builder);
        if (result.result().isPresent()) {
            this.json = (JsonObject)result.result().get();
        } else if (result.error().isPresent()) {
            ConsoleJS.SERVER.error((Object)("Error in Modular Machinery recipe: " + String.valueOf(this.id) + "\n" + ((DataResult.Error)result.error().get()).message()));
            this.json = new JsonObject();
        }
        if (this.json != null) {
            this.json.addProperty("type", RecipeRegistration.RECIPE_TYPE.getId().toString());
        }
        return this;
    }

    public MachineRecipeBuilderJS jei() {
        this.jei = true;
        return this;
    }

    public MachineRecipeBuilderJS hide() {
        this.setValue(ModularMachineryRebornRecipeSchemas.HIDE, true);
        return this;
    }

    public MachineRecipeBuilderJS renderProgress(boolean value) {
        this.setValue(ModularMachineryRebornRecipeSchemas.SHOULD_RENDER_PROGRESS, value);
        return this;
    }

    public MachineRecipeBuilderJS progressX(int x) {
        this.setValue(ModularMachineryRebornRecipeSchemas.PROGRESS_X, x);
        return this;
    }

    public MachineRecipeBuilderJS progressY(int y) {
        this.setValue(ModularMachineryRebornRecipeSchemas.PROGRESS_Y, y);
        return this;
    }

    public MachineRecipeBuilderJS width(int width) {
        this.setValue(ModularMachineryRebornRecipeSchemas.WIDTH, width);
        return this;
    }

    public MachineRecipeBuilderJS height(int height) {
        this.setValue(ModularMachineryRebornRecipeSchemas.HEIGHT, height);
        return this;
    }

    public MachineRecipeBuilderJS voidOnFailure(boolean v) {
        this.setValue(ModularMachineryRebornRecipeSchemas.VOID, v);
        return this;
    }

    public MachineRecipeBuilderJS priority(int priority) {
        this.setValue(ModularMachineryRebornRecipeSchemas.PRIORITY, priority);
        return this;
    }

    @Override
    @HideFromJS
    public MachineRecipeBuilderJS addRequirement(RecipeRequirement<?, ?> requirement) {
        if (!this.jei) {
            this.setValue(ModularMachineryRebornRecipeSchemas.REQUIREMENTS, this.addToList(ModularMachineryRebornRecipeSchemas.REQUIREMENTS, requirement));
        } else {
            this.setValue(ModularMachineryRebornRecipeSchemas.JEI_REQUIREMENTS, this.addToList(ModularMachineryRebornRecipeSchemas.JEI_REQUIREMENTS, requirement));
        }
        return this;
    }

    @HideFromJS
    private <E> List<E> addToList(RecipeKey<List<E>> key, E element) {
        ArrayList<E> list = new ArrayList<E>((Collection)this.getValue(key));
        list.add(element);
        return list;
    }

    @Override
    @HideFromJS
    public MachineRecipeBuilderJS error(String error, Object ... args) {
        throw new KubeRuntimeException(MessageFormatter.arrayFormat((String)error, (Object[])args).getMessage()).source(this.sourceLine);
    }

    @Override
    @Generated
    public boolean isJei() {
        return this.jei;
    }
}

