/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.item;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.JsonOps;
import es.degrassi.mmreborn.api.BlockIngredient;
import es.degrassi.mmreborn.api.PartialBlockState;
import es.degrassi.mmreborn.api.codec.DefaultCodecs;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.common.block.BlockController;
import es.degrassi.mmreborn.common.item.StructureCreatorItemMode;
import es.degrassi.mmreborn.common.registration.DataComponentRegistration;
import es.degrassi.mmreborn.common.registration.KeyMappings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class StructureCreatorItem
extends Item {
    private static final NamedCodec<List<List<String>>> PATTERN_CODEC = NamedCodec.STRING.listOf().listOf();
    private static final NamedCodec<Map<Character, BlockIngredient>> KEYS_CODEC = NamedCodec.unboundedMap(DefaultCodecs.CHARACTER, BlockIngredient.CODEC, "Map<Character, Block>");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public StructureCreatorItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = context.getClickedPos();
        BlockState state = context.getLevel().getBlockState(pos);
        ItemStack stack = context.getItemInHand();
        StructureCreatorItemMode currentMode = StructureCreatorItem.getCurrentMode(stack);
        if (currentMode.isSingle()) {
            if (state.getBlock() instanceof BlockController) {
                if (!context.getLevel().isClientSide()) {
                    this.finishStructure(stack, pos, (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING), (ServerPlayer)context.getPlayer());
                }
                return InteractionResult.SUCCESS;
            }
            if (!StructureCreatorItem.getSelectedBlocks(stack).contains(pos)) {
                StructureCreatorItem.addSelectedBlock(stack, pos);
                return InteractionResult.SUCCESS;
            }
            if (StructureCreatorItem.getSelectedBlocks(stack).contains(pos)) {
                StructureCreatorItem.removeSelectedBlock(stack, pos);
                return InteractionResult.SUCCESS;
            }
        } else if (currentMode.isBox()) {
            if (state.getBlock() instanceof BlockController) {
                if (!context.getLevel().isClientSide()) {
                    this.finishStructure(stack, pos, (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING), (ServerPlayer)context.getPlayer());
                }
                return InteractionResult.SUCCESS;
            }
            if (StructureCreatorItem.isFirst(stack)) {
                StructureCreatorItem.selectFirst(stack, pos);
                StructureCreatorItem.setSecond(stack);
            } else {
                StructureCreatorItem.selectSecond(stack, pos);
                StructureCreatorItem.setFirst(stack);
            }
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        int amount;
        tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn.structure_creator.mode", (Object[])new Object[]{StructureCreatorItem.getCurrentMode(stack).component()}));
        tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn.structure_creator.mode.change.tooltip", (Object[])new Object[]{((KeyMapping)KeyMappings.STRUCTURE_MODE_CHANGE.get()).getKey().getDisplayName()}));
        if (StructureCreatorItem.getCurrentMode(stack).isBox()) {
            if (StructureCreatorItem.isFirst(stack)) {
                tooltip.add((Component)Component.empty());
                tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn.structure_creator.mode.box.first").withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.empty());
                tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn.structure_creator.mode.box.second").withStyle(ChatFormatting.GRAY));
            }
            tooltip.add((Component)Component.empty());
        }
        if ((amount = StructureCreatorItem.getSelectedBlocks(stack).size()) == 0) {
            tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn.structure_creator.no_blocks").withStyle(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn.structure_creator.amount", (Object[])new Object[]{StructureCreatorItem.getSelectedBlocks(stack).size()}).withStyle(ChatFormatting.BLUE));
        }
        tooltip.add((Component)Component.empty());
        if (StructureCreatorItem.getCurrentMode(stack).isSingle()) {
            tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn.structure_creator.select").withStyle(ChatFormatting.GREEN));
        }
        tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn.structure_creator.reset").withStyle(ChatFormatting.GOLD));
        tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn.structure_creator.finish").withStyle(ChatFormatting.YELLOW));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching() && stack.getItem() == this) {
            stack.remove(DataComponentRegistration.STRUCTURE_CREATOR_DATA);
            stack.remove(DataComponentRegistration.STRUCTURE_CREATOR_BOX);
            stack.remove(DataComponentRegistration.STRUCTURE_CREATOR_BOX_CURRENT);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public static List<BlockPos> getSelectedBlocks(ItemStack stack) {
        return Optional.ofNullable((List)stack.get(DataComponentRegistration.STRUCTURE_CREATOR_DATA)).orElse(new ArrayList());
    }

    public static StructureCreatorItemMode getCurrentMode(ItemStack stack) {
        return Optional.ofNullable((StructureCreatorItemMode)((Object)stack.get(DataComponentRegistration.STRUCTURE_CREATOR_MODE))).orElse(StructureCreatorItemMode.SINGLE);
    }

    public static void nextMode(ItemStack stack) {
        stack.update(DataComponentRegistration.STRUCTURE_CREATOR_MODE, (Object)StructureCreatorItemMode.SINGLE, StructureCreatorItemMode::next);
    }

    public static boolean isFirst(ItemStack stack) {
        return (Boolean)stack.getOrDefault(DataComponentRegistration.STRUCTURE_CREATOR_BOX_CURRENT, (Object)true);
    }

    public static void setSecond(ItemStack stack) {
        stack.update(DataComponentRegistration.STRUCTURE_CREATOR_BOX_CURRENT, (Object)true, current -> false);
    }

    public static void setFirst(ItemStack stack) {
        stack.update(DataComponentRegistration.STRUCTURE_CREATOR_BOX_CURRENT, (Object)true, current -> true);
    }

    public static BlockPos getBox(ItemStack stack) {
        return (BlockPos)stack.getOrDefault(DataComponentRegistration.STRUCTURE_CREATOR_BOX, (Object)new BlockPos(0, 0, 0));
    }

    public static void selectFirst(ItemStack stack, BlockPos pos) {
        stack.update(DataComponentRegistration.STRUCTURE_CREATOR_BOX, (Object)new BlockPos(0, 0, 0), box -> pos.immutable());
        StructureCreatorItem.addSelectedBlock(stack, pos);
    }

    public static void selectSecond(ItemStack stack, BlockPos pos) {
        BlockPos stored = StructureCreatorItem.getBox(stack);
        int minX = Math.min(stored.getX(), pos.getX());
        int maxX = Math.max(stored.getX(), pos.getX());
        int minY = Math.min(stored.getY(), pos.getY());
        int maxY = Math.max(stored.getY(), pos.getY());
        int minZ = Math.min(stored.getZ(), pos.getZ());
        int maxZ = Math.max(stored.getZ(), pos.getZ());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    mutable.set(x, y, z);
                    if (StructureCreatorItem.getSelectedBlocks(stack).contains(mutable.immutable())) continue;
                    StructureCreatorItem.addSelectedBlock(stack, mutable.immutable());
                }
            }
        }
        stack.remove(DataComponentRegistration.STRUCTURE_CREATOR_BOX);
    }

    public static void addSelectedBlock(ItemStack stack, BlockPos pos) {
        stack.update(DataComponentRegistration.STRUCTURE_CREATOR_DATA, new ArrayList(), list -> {
            list.add(pos);
            return list;
        });
    }

    public static void removeSelectedBlock(ItemStack stack, BlockPos pos) {
        stack.update(DataComponentRegistration.STRUCTURE_CREATOR_DATA, new ArrayList(), list -> {
            list.remove(pos);
            return list;
        });
    }

    private void finishStructure(ItemStack stack, BlockPos machinePos, Direction machineFacing, ServerPlayer player) {
        List<BlockPos> blocks = StructureCreatorItem.getSelectedBlocks(stack);
        blocks.add(machinePos);
        if (blocks.size() <= 1) {
            player.sendSystemMessage((Component)Component.translatable((String)"modular_machinery_reborn.structure_creator.no_blocks"));
            return;
        }
        Level world = player.level();
        BlockIngredient[][][] states = this.getStructureArray(blocks, machineFacing, world);
        HashBiMap keys = HashBiMap.create();
        AtomicInteger charIndex = new AtomicInteger(97);
        Arrays.stream(states).flatMap(Arrays::stream).flatMap(Arrays::stream).filter(state -> state.getAll().stream().noneMatch(s -> s == PartialBlockState.MACHINE || s.getBlockState().getBlock() instanceof BlockController)).filter(state -> state != BlockIngredient.ANY).distinct().forEach(state -> {
            if (charIndex.get() == 109) {
                charIndex.incrementAndGet();
            }
            keys.put((Object)Character.valueOf((char)charIndex.getAndIncrement()), state);
            if (charIndex.get() == 122) {
                charIndex.set(65);
            }
        });
        ArrayList pattern = Lists.newArrayList();
        for (BlockIngredient[][] state2 : states) {
            ArrayList floor = Lists.newArrayList();
            for (BlockIngredient[] partialBlockStates : state2) {
                StringBuilder row = new StringBuilder();
                for (BlockIngredient partial : partialBlockStates) {
                    int key = partial.getAll().stream().anyMatch(s -> s == PartialBlockState.MACHINE || s.getBlockState().getBlock() instanceof BlockController) ? 109 : (partial.getAll().stream().anyMatch(s -> s == PartialBlockState.ANY) ? 32 : (keys.containsValue((Object)partial) ? (int)((Character)keys.inverse().get((Object)partial)).charValue() : 63));
                    row.append((char)key);
                }
                floor.add(row.reverse().toString());
            }
            pattern.add(floor.reversed());
        }
        JsonElement keysJson = (JsonElement)KEYS_CODEC.encodeStart(JsonOps.INSTANCE, (Map<Character, BlockIngredient>)keys).result().orElseThrow(IllegalStateException::new);
        JsonElement patternJson = (JsonElement)PATTERN_CODEC.encodeStart(JsonOps.INSTANCE, pattern).result().orElseThrow(IllegalStateException::new);
        JsonObject both = new JsonObject();
        both.add("pattern", patternJson);
        both.add("keys", keysJson);
        String ctKubeString = ".structure(\nMMRStructureBuilder.create()\n.pattern(" + patternJson.toString() + ")\n.keys(" + keysJson.toString() + "))";
        MutableComponent jsonText = Component.literal((String)"[JSON]").withStyle(style -> style.applyFormats(new ChatFormatting[]{ChatFormatting.YELLOW}).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)both.toString()))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, both.toString())));
        MutableComponent prettyJsonText = Component.literal((String)"[PRETTY JSON]").withStyle(style -> style.applyFormats(new ChatFormatting[]{ChatFormatting.GOLD}).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)GSON.toJson((JsonElement)both)))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, GSON.toJson((JsonElement)both))));
        MutableComponent kubeJSText = Component.literal((String)"[KUBEJS]").withStyle(style -> style.applyFormats(new ChatFormatting[]{ChatFormatting.DARK_PURPLE}).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)ctKubeString))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, ctKubeString)));
        MutableComponent message = Component.translatable((String)"modular_machinery_reborn.structure_creator.message", (Object[])new Object[]{jsonText, prettyJsonText, kubeJSText});
        player.sendSystemMessage((Component)message);
    }

    private BlockIngredient[][][] getStructureArray(List<BlockPos> blocks, Direction machineFacing, Level world) {
        int minX = blocks.stream().mapToInt(Vec3i::getX).min().orElseThrow(IllegalStateException::new);
        int maxX = blocks.stream().mapToInt(Vec3i::getX).max().orElseThrow(IllegalStateException::new);
        int minY = blocks.stream().mapToInt(Vec3i::getY).min().orElseThrow(IllegalStateException::new);
        int maxY = blocks.stream().mapToInt(Vec3i::getY).max().orElseThrow(IllegalStateException::new);
        int minZ = blocks.stream().mapToInt(Vec3i::getZ).min().orElseThrow(IllegalStateException::new);
        int maxZ = blocks.stream().mapToInt(Vec3i::getZ).max().orElseThrow(IllegalStateException::new);
        BlockIngredient[][][] states = machineFacing.getAxis() == Direction.Axis.X ? new BlockIngredient[maxY - minY + 1][maxX - minX + 1][maxZ - minZ + 1] : new BlockIngredient[maxY - minY + 1][maxZ - minZ + 1][maxX - minX + 1];
        AABB box = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        HashMap cache = Maps.newHashMap();
        BlockPos.betweenClosedStream((AABB)box).forEach(p -> {
            BlockIngredient partial;
            BlockState state = world.getBlockState(p);
            if (!blocks.contains(p)) {
                partial = BlockIngredient.ANY;
            } else if (cache.containsKey(state)) {
                partial = (BlockIngredient)cache.get(state);
            } else {
                partial = new BlockIngredient(new PartialBlockState(state, Lists.newArrayList((Iterable)state.getProperties()), null));
                cache.put(state, partial);
            }
            switch (machineFacing) {
                case EAST: {
                    states[p.getY() - minY][p.getX() - minX][maxZ - p.getZ()] = partial;
                    break;
                }
                case WEST: {
                    states[p.getY() - minY][maxX - p.getX()][p.getZ() - minZ] = partial;
                    break;
                }
                case SOUTH: {
                    states[p.getY() - minY][p.getZ() - minZ][p.getX() - minX] = partial;
                    break;
                }
                case NORTH: {
                    states[p.getY() - minY][maxZ - p.getZ()][maxX - p.getX()] = partial;
                }
            }
        });
        return states;
    }
}

