/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.machine;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.Structure;
import es.degrassi.mmreborn.api.codec.DefaultCodecs;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.codec.RegistrarCodec;
import es.degrassi.mmreborn.common.crafting.modifier.ModifierReplacement;
import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import es.degrassi.mmreborn.common.machine.MachineHatchType;
import es.degrassi.mmreborn.common.machine.Sounds;
import es.degrassi.mmreborn.common.manager.crafting.MachineStatus;
import es.degrassi.mmreborn.common.util.MachineModelLocation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.SoundType;

public class DynamicMachine {
    public static final NamedCodec<DynamicMachine> CODEC = NamedCodec.record(instance -> instance.group(DefaultCodecs.RESOURCE_LOCATION.fieldOf("registryName").forGetter(DynamicMachine::getRegistryName), NamedCodec.STRING.optionalFieldOf("localizedName").forGetter(machine -> Optional.of(machine.getLocalizedName())), Structure.CODEC.fieldOf("structure").forGetter(DynamicMachine::getPattern), DefaultCodecs.HEX.optionalFieldOf("color", Config.machineColor).forGetter(DynamicMachine::getMachineColor), MachineModelLocation.CODEC.optionalFieldOf("controller", MachineModelLocation.DEFAULT).forGetter(DynamicMachine::getControllerModel), NamedCodec.unboundedMap(MachineStatus.CODEC, Sounds.CODEC, "Sounds by status").optionalFieldOf("sound", new HashMap()).forGetter(DynamicMachine::getSounds), NamedCodec.unboundedMap(RegistrarCodec.HATCH_TYPE, TextureableMachineEntity.CODEC, "Formed Textures by HatchType").optionalFieldOf("formed_textures", Maps.newHashMap()).forGetter(DynamicMachine::getFormedTextures)).apply((Applicative)instance, (registryName, localizedName, pattern, color, controllerModel, sounds, formedTextures) -> {
        DynamicMachine machine = new DynamicMachine((ResourceLocation)registryName, (Map<MachineStatus, Sounds>)sounds, (Map<MachineHatchType, Pair<Boolean, Pair<Optional<ResourceLocation>, Optional<ResourceLocation>>>>)formedTextures);
        machine.setPattern((Structure)pattern);
        machine.setLocalizedName((Optional<String>)localizedName);
        machine.setDefinedColor((int)color);
        machine.setControllerModel((MachineModelLocation)controllerModel);
        return machine;
    }), "Dynamic Machine");
    public static final DynamicMachine DUMMY;
    @Nonnull
    private ResourceLocation registryName;
    private Optional<String> localizedName = Optional.empty();
    private Structure pattern = Structure.EMPTY;
    private int definedColor = Config.machineColor;
    @Nullable
    private MachineModelLocation controllerModel;
    private final Map<MachineStatus, Sounds> sounds;
    private final Map<MachineHatchType, Pair<Boolean, Pair<Optional<ResourceLocation>, Optional<ResourceLocation>>>> formedTextures;

    public DynamicMachine(@Nonnull ResourceLocation registryName, Map<MachineStatus, Sounds> sounds, Map<MachineHatchType, Pair<Boolean, Pair<Optional<ResourceLocation>, Optional<ResourceLocation>>>> formedTextures) {
        this.registryName = registryName;
        this.sounds = sounds;
        this.formedTextures = formedTextures;
    }

    public List<ModifierReplacement> getModifiers() {
        return this.getPattern().getPattern().getModifiers();
    }

    public String getLocalizedName() {
        return this.getName().getString();
    }

    public Component getName() {
        String localizationKey = this.registryName.getNamespace() + "." + this.registryName.getPath();
        return Component.translatableWithFallback((String)localizationKey, (String)this.localizedName.orElse(localizationKey));
    }

    @Nullable
    public SoundEvent getAmbientSound(MachineStatus status) {
        return Optional.ofNullable(this.sounds.get((Object)status)).map(Sounds::ambientSound).orElse(null);
    }

    public SoundType getInteractionSound(MachineStatus status) {
        return Optional.ofNullable(this.sounds.get((Object)status)).orElse(Sounds.DEFAULT).interaction();
    }

    public int getMachineColor() {
        return this.definedColor;
    }

    public JsonObject asJson() {
        JsonObject json = new JsonObject();
        json.addProperty("registryName", this.registryName.toString());
        json.addProperty("localizedName", this.localizedName.orElse("null"));
        json.add("pattern", (JsonElement)this.pattern.asJson());
        json.addProperty("definedColor", (Number)this.definedColor);
        if (this.controllerModel != null && this.controllerModel.getLoc() != null) {
            json.addProperty("controllerModel", this.controllerModel.toString());
        }
        JsonObject formedTexts = new JsonObject();
        this.formedTextures.forEach((hatchType, pair) -> {
            Boolean shouldColor = (Boolean)pair.getFirst();
            JsonObject texts = (JsonObject)pair.mapSecond(second -> {
                Optional baseTexture = (Optional)second.getFirst();
                Optional overlayTexture = (Optional)second.getSecond();
                JsonObject textures = new JsonObject();
                baseTexture.ifPresent(rl -> textures.addProperty("base_texture", rl.toString()));
                overlayTexture.ifPresent(rl -> textures.addProperty("overlay_texture", rl.toString()));
                return textures;
            }).getSecond();
            JsonObject withColor = new JsonObject();
            withColor.addProperty("should_color", shouldColor);
            withColor.add("textures", (JsonElement)texts);
            formedTexts.add(hatchType.getId().toString(), (JsonElement)withColor);
        });
        json.add("formed_textures", (JsonElement)formedTexts);
        return json;
    }

    public String toString() {
        return this.asJson().toString();
    }

    @Nonnull
    @Generated
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Generated
    public Structure getPattern() {
        return this.pattern;
    }

    @Generated
    public int getDefinedColor() {
        return this.definedColor;
    }

    @Nullable
    @Generated
    public MachineModelLocation getControllerModel() {
        return this.controllerModel;
    }

    @Generated
    public Map<MachineStatus, Sounds> getSounds() {
        return this.sounds;
    }

    @Generated
    public Map<MachineHatchType, Pair<Boolean, Pair<Optional<ResourceLocation>, Optional<ResourceLocation>>>> getFormedTextures() {
        return this.formedTextures;
    }

    @Generated
    public void setRegistryName(@Nonnull ResourceLocation registryName) {
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        this.registryName = registryName;
    }

    @Generated
    public void setLocalizedName(Optional<String> localizedName) {
        this.localizedName = localizedName;
    }

    @Generated
    public void setPattern(Structure pattern) {
        this.pattern = pattern;
    }

    @Generated
    public void setDefinedColor(int definedColor) {
        this.definedColor = definedColor;
    }

    @Generated
    public void setControllerModel(@Nullable MachineModelLocation controllerModel) {
        this.controllerModel = controllerModel;
    }

    static {
        HashMap<MachineStatus, Sounds> sounds = new HashMap<MachineStatus, Sounds>();
        for (MachineStatus status : MachineStatus.values()) {
            sounds.put(status, Sounds.DEFAULT);
        }
        DUMMY = new DynamicMachine(ModularMachineryReborn.rl("dummy"), sounds, Maps.newHashMap());
    }
}

