/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.manager.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.manager.ComponentManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class RequirementList<C extends MachineComponent<?>>
implements IRequirementList<C> {
    private final Map<Double, List<RequirementWithFunction>> processRequirements = Maps.newHashMap();
    private final List<RequirementWithFunction> tickableRequirements = Lists.newArrayList();
    private final List<RequirementWithFunction> worldConditions = Lists.newArrayList();
    private final List<RequirementWithFunction> inventoryConditions = Lists.newArrayList();
    private RecipeRequirement<? extends MachineComponent<?>, ?> currentRequirement;

    @Override
    public void processOnStart(IRequirementList.RequirementFunction<C> function) {
        this.processRequirements.computeIfAbsent(0.0, delay -> new ArrayList()).add(new RequirementWithFunction(this.currentRequirement, function));
    }

    @Override
    public void processOnEnd(IRequirementList.RequirementFunction<C> function) {
        this.processRequirements.computeIfAbsent(1.0, delay -> new ArrayList()).add(new RequirementWithFunction(this.currentRequirement, function));
    }

    @Override
    public void processEachTick(IRequirementList.RequirementFunction<C> function) {
        this.tickableRequirements.add(new RequirementWithFunction(this.currentRequirement, function));
    }

    @Override
    public void worldCondition(IRequirementList.RequirementFunction<C> function) {
        this.worldConditions.add(new RequirementWithFunction(this.currentRequirement, function));
    }

    @Override
    public void inventoryCondition(IRequirementList.RequirementFunction<C> function) {
        this.inventoryConditions.add(new RequirementWithFunction(this.currentRequirement, function));
    }

    @Override
    public void processDelayed(double baseDelay, IRequirementList.RequirementFunction<C> function) {
        this.processRequirements.computeIfAbsent(baseDelay, delay -> new ArrayList()).add(new RequirementWithFunction(this.currentRequirement, function));
    }

    @Override
    public void process(IOType mode, IRequirementList.RequirementFunction<C> function) {
        this.processDelayed(mode.isInput() ? 0.0 : 1.0, function);
    }

    @Generated
    public Map<Double, List<RequirementWithFunction>> getProcessRequirements() {
        return this.processRequirements;
    }

    @Generated
    public List<RequirementWithFunction> getTickableRequirements() {
        return this.tickableRequirements;
    }

    @Generated
    public List<RequirementWithFunction> getWorldConditions() {
        return this.worldConditions;
    }

    @Generated
    public List<RequirementWithFunction> getInventoryConditions() {
        return this.inventoryConditions;
    }

    @Generated
    public void setCurrentRequirement(RecipeRequirement<? extends MachineComponent<?>, ?> currentRequirement) {
        this.currentRequirement = currentRequirement;
    }

    public record RequirementWithFunction(RecipeRequirement<?, ?> requirement, IRequirementList.RequirementFunction<?> function) {
        public CraftingResult process(ComponentManager manager, ICraftingContext context) {
            Object component = this.requirement.findComponent(manager, context);
            if (component == null) {
                return CraftingResult.error(this.requirement.requirement().getMissingComponentErrorMessage(this.requirement.requirement().getMode()));
            }
            return this.function.process(component, context);
        }
    }
}

