/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.network.server;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.network.IData;
import es.degrassi.mmreborn.client.container.ContainerBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SUpdateContainerPacket(int windowId, List<IData<?>> data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SUpdateContainerPacket> TYPE = new CustomPacketPayload.Type(ModularMachineryReborn.rl("update_container"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SUpdateContainerPacket> CODEC = StreamCodec.ofMember(SUpdateContainerPacket::write, SUpdateContainerPacket::read);

    public CustomPacketPayload.Type<SUpdateContainerPacket> type() {
        return TYPE;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.windowId);
        buf.writeShort(this.data.size());
        this.data.forEach(data -> data.writeData(buf));
    }

    public static SUpdateContainerPacket read(RegistryFriendlyByteBuf buf) {
        int windowId = buf.readInt();
        ArrayList dataList = Lists.newArrayList();
        short size = buf.readShort();
        for (short i = 0; i < size; i = (short)(i + 1)) {
            IData<?> data = IData.readData(buf);
            if (data == null) continue;
            dataList.add(data);
        }
        return new SUpdateContainerPacket(windowId, dataList);
    }

    public static void handle(SUpdateContainerPacket packet, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> {
                AbstractContainerMenu patt0$temp;
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null && (patt0$temp = player.containerMenu) instanceof ContainerBase) {
                    ContainerBase container = (ContainerBase)patt0$temp;
                    if (player.containerMenu.containerId == packet.windowId) {
                        packet.data.forEach(container::handleData);
                    }
                }
            });
        }
    }
}

