/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.network.server;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SUpdateMachineColorPacket(Integer color, BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SUpdateMachineColorPacket> TYPE = new CustomPacketPayload.Type(ModularMachineryReborn.rl("update_machine_color"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SUpdateMachineColorPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SUpdateMachineColorPacket::color, (StreamCodec)BlockPos.STREAM_CODEC, SUpdateMachineColorPacket::pos, SUpdateMachineColorPacket::new);

    public CustomPacketPayload.Type<SUpdateMachineColorPacket> type() {
        return TYPE;
    }

    public static void handle(SUpdateMachineColorPacket packet, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> {
                BlockEntity be = context.player().level().getBlockEntity(packet.pos);
                if (be instanceof ColorableMachineEntity) {
                    ColorableMachineEntity entity = (ColorableMachineEntity)be;
                    entity.setMachineColor(packet.color);
                    be.requestModelDataUpdate();
                    context.player().level().setBlockAndUpdate(be.getBlockPos(), be.getBlockState());
                    be.setChanged();
                }
            });
        }
    }
}

