/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import es.degrassi.mmreborn.api.network.ISyncable;
import es.degrassi.mmreborn.api.network.ISyncableStuff;
import es.degrassi.mmreborn.api.network.syncable.ItemStackSyncable;
import es.degrassi.mmreborn.common.util.IOInventory;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class ItemSlot
implements IItemHandlerModifiable,
ISyncableStuff {
    private final int capacity;
    private final int maxInput;
    private final int maxOutput;
    private Predicate<ItemStack> filter;
    private ItemStack stack = ItemStack.EMPTY;
    private boolean bypassLimit = false;
    private final IOInventory manager;
    private final int slot;

    public ItemSlot(int slot, IOInventory manager, int capacity, int maxInput, int maxOutput, Predicate<ItemStack> filter) {
        this.capacity = capacity;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
        this.filter = filter;
        this.manager = manager;
        this.slot = slot;
    }

    public ItemSlot(IOInventory manager, Predicate<ItemStack> filter, CompoundTag nbt, HolderLookup.Provider registries) {
        this.manager = manager;
        this.filter = filter;
        if (nbt.contains("item")) {
            this.stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound("item"));
        }
        this.slot = nbt.getInt("slot");
        this.capacity = nbt.getInt("capacity");
        this.maxInput = nbt.getInt("maxInput");
        this.maxOutput = nbt.getInt("maxOutput");
    }

    public void deserialize(HolderLookup.Provider registries, CompoundTag nbt) {
        if (nbt.contains("item")) {
            this.stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound("item"));
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        if (!this.stack.isEmpty()) {
            nbt.put("item", this.stack.save(registries));
        }
        nbt.putInt("slot", this.slot);
        nbt.putInt("capacity", this.capacity);
        nbt.putInt("maxInput", this.maxInput);
        nbt.putInt("maxOutput", this.maxOutput);
        return nbt;
    }

    public boolean isInput() {
        return this.maxInput > 0;
    }

    public boolean isOutput() {
        return this.maxOutput > 0;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.stack = stack;
        this.getManager().setChanged();
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.stack;
    }

    public ItemStack insertItemBypassLimit(ItemStack stack, boolean simulate) {
        this.bypassLimit = true;
        ItemStack remainder = this.insertItem(0, stack, simulate);
        this.bypassLimit = false;
        return remainder;
    }

    public ItemStack extractItemBypassLimit(int amount, boolean simulate) {
        this.bypassLimit = true;
        ItemStack extracted = this.extractItem(0, amount, simulate);
        this.bypassLimit = false;
        return extracted;
    }

    public boolean canOutput() {
        return true;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public void setItemStack(ItemStack stack) {
        this.stack = stack;
        this.getManager().setChanged();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.isEmpty() || !this.isItemValid(0, stack) || !this.stack.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)stack)) {
            return stack;
        }
        int amountToInsert = stack.getCount();
        if (!this.bypassLimit) {
            amountToInsert = Math.min(amountToInsert, this.maxInput);
        }
        amountToInsert = Math.min(amountToInsert, stack.getMaxStackSize());
        if (!this.stack.isEmpty()) {
            amountToInsert = Math.min(amountToInsert, this.stack.getMaxStackSize() - this.stack.getCount());
        }
        if ((amountToInsert = Math.min(amountToInsert, this.capacity - this.stack.getCount())) <= 0) {
            return stack;
        }
        if (this.stack.isEmpty()) {
            if (!simulate) {
                this.stack = stack.copyWithCount(amountToInsert);
                this.getManager().setChanged();
            }
        } else if (!simulate) {
            this.stack.grow(amountToInsert);
            this.getManager().setChanged();
        }
        if (amountToInsert == stack.getCount()) {
            return ItemStack.EMPTY;
        }
        return stack.copyWithCount(stack.getCount() - amountToInsert);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0 || this.stack.isEmpty() || !this.canOutput()) {
            return ItemStack.EMPTY;
        }
        if (!this.bypassLimit) {
            amount = Math.min(amount, this.maxOutput);
        }
        amount = Math.min(amount, this.stack.getCount());
        ItemStack extracted = this.stack.copyWithCount(amount);
        if (!simulate) {
            this.stack.shrink(amount);
            this.getManager().setChanged();
        }
        return extracted;
    }

    public int getSlotLimit(int slot) {
        return this.capacity;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.filter.test(stack);
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(ItemStackSyncable.create(() -> this.stack, stack -> {
            this.stack = stack;
        }));
    }

    @Generated
    public int getCapacity() {
        return this.capacity;
    }

    @Generated
    public void setFilter(Predicate<ItemStack> filter) {
        this.filter = filter;
    }

    @Generated
    public Predicate<ItemStack> getFilter() {
        return this.filter;
    }

    @Generated
    public IOInventory getManager() {
        return this.manager;
    }

    @Generated
    public int getSlot() {
        return this.slot;
    }
}

