/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.data;

import es.degrassi.mmreborn.common.block.BlockController;
import es.degrassi.mmreborn.common.registration.BlockRegistration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MMRLootTableProvider
extends LootTableProvider {
    public MMRLootTableProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(LootSubProvider::new, LootTable.DEFAULT_PARAM_SET)), provider);
    }

    static class LootSubProvider
    extends BlockLootSubProvider {
        public LootSubProvider(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.DEFAULT_FLAGS, provider);
        }

        protected Iterable<Block> getKnownBlocks() {
            return BlockRegistration.BLOCKS.getEntries().stream().map(DeferredHolder::value).map(e -> e).toList();
        }

        protected void generate() {
            this.getKnownBlocks().forEach(block -> {
                if (!(block instanceof BlockController)) {
                    this.dropSelf((Block)block);
                } else {
                    BlockController b = (BlockController)block;
                    this.add((Block)block, LootTable.lootTable().withPool(((LootPool.Builder)this.applyExplosionCondition((ItemLike)b, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)b)))).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY))));
                }
            });
        }
    }
}

