/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.ForwardingSet;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractBiMap<K, V>
extends ForwardingMap<K, V>
implements BiMap<K, V>,
Serializable {
    private transient Map<K, V> delegate;
    transient AbstractBiMap<V, K> inverse;
    @LazyInit
    private transient Set<K> keySet;
    private transient Set<V> valueSet;
    @LazyInit
    private transient Set<Map.Entry<K, V>> entrySet;

    public AbstractBiMap(Map<K, V> forward, Map<V, K> backward) {
        this.setDelegates(forward, backward);
    }

    private AbstractBiMap(Map<K, V> backward, AbstractBiMap<V, K> forward) {
        this.delegate = backward;
        this.inverse = forward;
    }

    protected Map<K, V> delegate() {
        return this.delegate;
    }

    K checkKey(K key) {
        return key;
    }

    V checkValue(V value) {
        return value;
    }

    void setDelegates(Map<K, V> forward, Map<V, K> backward) {
        Preconditions.checkState((this.delegate == null ? 1 : 0) != 0);
        Preconditions.checkState((this.inverse == null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)forward.isEmpty());
        Preconditions.checkArgument((boolean)backward.isEmpty());
        Preconditions.checkArgument((forward != backward ? 1 : 0) != 0);
        this.delegate = forward;
        this.inverse = this.makeInverse(backward);
    }

    AbstractBiMap<V, K> makeInverse(Map<V, K> backward) {
        return new Inverse<V, K>(backward, this);
    }

    void setInverse(AbstractBiMap<V, K> inverse) {
        this.inverse = inverse;
    }

    public boolean containsValue(Object value) {
        return this.inverse.containsKey(value);
    }

    public V put(K key, V value) {
        return this.putInBothMaps(key, value, false);
    }

    public V forcePut(K key, V value) {
        return this.putInBothMaps(key, value, true);
    }

    private V putInBothMaps(K key, V value, boolean force) {
        this.checkKey(key);
        this.checkValue(value);
        boolean containedKey = this.containsKey(key);
        if (containedKey && Objects.equal(value, (Object)this.get(key))) {
            return value;
        }
        if (force) {
            this.inverse().remove(value);
        } else {
            Preconditions.checkArgument((!this.containsValue(value) ? 1 : 0) != 0, (String)"value already present: %s", value);
        }
        V oldValue = this.delegate.put(key, value);
        this.updateInverseMap(key, containedKey, oldValue, value);
        return oldValue;
    }

    private void updateInverseMap(K key, boolean containedKey, V oldValue, V newValue) {
        if (containedKey) {
            this.removeFromInverseMap(oldValue);
        }
        this.inverse.delegate.put(newValue, key);
    }

    public V remove(Object key) {
        return this.containsKey(key) ? (V)this.removeFromBothMaps(key) : null;
    }

    private V removeFromBothMaps(Object key) {
        V oldValue = this.delegate.remove(key);
        this.removeFromInverseMap(oldValue);
        return oldValue;
    }

    private void removeFromInverseMap(V oldValue) {
        this.inverse.delegate.remove(oldValue);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.delegate.replaceAll(function);
        this.inverse.delegate.clear();
        Map.Entry<K, V> broken = null;
        Iterator<Map.Entry<K, V>> itr = this.delegate.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<K, V> entry = itr.next();
            K k = entry.getKey();
            V v = entry.getValue();
            V conflict = this.inverse.delegate.putIfAbsent(v, k);
            if (conflict == null) continue;
            broken = entry;
            itr.remove();
        }
        if (broken != null) {
            throw new IllegalArgumentException("value already present: " + String.valueOf(broken.getValue()));
        }
    }

    public void clear() {
        this.delegate.clear();
        this.inverse.delegate.clear();
    }

    public BiMap<V, K> inverse() {
        return this.inverse;
    }

    public Set<K> keySet() {
        Set<K> result = this.keySet;
        return result == null ? (this.keySet = new KeySet()) : result;
    }

    public Set<V> values() {
        Set<V> result = this.valueSet;
        return result == null ? (this.valueSet = new ValueSet()) : result;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> result = this.entrySet;
        return result == null ? (this.entrySet = new EntrySet()) : result;
    }

    Iterator<Map.Entry<K, V>> entrySetIterator() {
        final Iterator<Map.Entry<K, V>> iterator = this.delegate.entrySet().iterator();
        return new Iterator<Map.Entry<K, V>>(){
            Map.Entry<K, V> entry;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                this.entry = (Map.Entry)iterator.next();
                return new BiMapEntry(this.entry);
            }

            @Override
            public void remove() {
                if (this.entry == null) {
                    throw new IllegalStateException("no calls to next() since the last call to remove()");
                }
                Object value = this.entry.getValue();
                iterator.remove();
                AbstractBiMap.this.removeFromInverseMap(value);
                this.entry = null;
            }
        };
    }

    static class Inverse<K, V>
    extends AbstractBiMap<K, V> {
        Inverse(Map<K, V> backward, AbstractBiMap<V, K> forward) {
            super(backward, forward);
        }

        @Override
        K checkKey(K key) {
            return this.inverse.checkValue(key);
        }

        @Override
        V checkValue(V value) {
            return this.inverse.checkKey(value);
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeObject(this.inverse());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.setInverse((AbstractBiMap)stream.readObject());
        }

        Object readResolve() {
            return this.inverse().inverse();
        }
    }

    private class KeySet
    extends ForwardingSet<K> {
        private KeySet() {
        }

        protected Set<K> delegate() {
            return AbstractBiMap.this.delegate.keySet();
        }

        public void clear() {
            AbstractBiMap.this.clear();
        }

        public boolean remove(Object key) {
            if (!this.contains(key)) {
                return false;
            }
            AbstractBiMap.this.removeFromBothMaps(key);
            return true;
        }

        public boolean removeAll(Collection<?> keysToRemove) {
            return this.standardRemoveAll(keysToRemove);
        }

        public boolean retainAll(Collection<?> keysToRetain) {
            return this.standardRetainAll(keysToRetain);
        }

        public Iterator<K> iterator() {
            return new TransformedIterator<Map.Entry<K, V>, K>(this, AbstractBiMap.this.entrySet().iterator()){

                @Override
                K transform(Map.Entry<K, V> entry) {
                    return entry.getKey();
                }
            };
        }
    }

    private class ValueSet
    extends ForwardingSet<V> {
        final Set<V> valuesDelegate;

        private ValueSet() {
            this.valuesDelegate = AbstractBiMap.this.inverse.keySet();
        }

        protected Set<V> delegate() {
            return this.valuesDelegate;
        }

        public Iterator<V> iterator() {
            return new TransformedIterator<Map.Entry<K, V>, V>(this, AbstractBiMap.this.entrySet().iterator()){

                @Override
                V transform(Map.Entry<K, V> entry) {
                    return entry.getValue();
                }
            };
        }

        public @Nullable Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        public String toString() {
            return this.standardToString();
        }
    }

    private class EntrySet
    extends ForwardingSet<Map.Entry<K, V>> {
        final Set<Map.Entry<K, V>> esDelegate;

        private EntrySet() {
            this.esDelegate = AbstractBiMap.this.delegate.entrySet();
        }

        protected Set<Map.Entry<K, V>> delegate() {
            return this.esDelegate;
        }

        public void clear() {
            AbstractBiMap.this.clear();
        }

        public boolean remove(Object object) {
            if (!this.esDelegate.contains(object) || !(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            AbstractBiMap.this.inverse.delegate.remove(entry.getValue());
            this.esDelegate.remove(entry);
            return true;
        }

        public Iterator<Map.Entry<K, V>> iterator() {
            return AbstractBiMap.this.entrySetIterator();
        }

        public @Nullable Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return this.delegate().contains((Map.Entry)o);
        }

        public boolean containsAll(Collection<?> c) {
            return this.standardContainsAll(c);
        }

        public boolean removeAll(Collection<?> c) {
            return this.standardRemoveAll(c);
        }

        public boolean retainAll(Collection<?> c) {
            return this.standardRetainAll(c);
        }
    }

    abstract class TransformedIterator<F, T>
    implements Iterator<T> {
        final Iterator<? extends F> backingIterator;

        TransformedIterator(AbstractBiMap this$0, Iterator<? extends F> backingIterator) {
            this.backingIterator = (Iterator)Preconditions.checkNotNull(backingIterator);
        }

        abstract T transform(F var1);

        @Override
        public final boolean hasNext() {
            return this.backingIterator.hasNext();
        }

        @Override
        public final T next() {
            return this.transform(this.backingIterator.next());
        }

        @Override
        public final void remove() {
            this.backingIterator.remove();
        }
    }

    class BiMapEntry
    extends ForwardingMapEntry<K, V> {
        private final Map.Entry<K, V> delegate;

        BiMapEntry(Map.Entry<K, V> delegate) {
            this.delegate = delegate;
        }

        protected Map.Entry<K, V> delegate() {
            return this.delegate;
        }

        public V setValue(V value) {
            AbstractBiMap.this.checkValue(value);
            Preconditions.checkState((boolean)AbstractBiMap.this.entrySet().contains((Object)this), (Object)"entry no longer in map");
            if (Objects.equal(value, (Object)this.getValue())) {
                return value;
            }
            Preconditions.checkArgument((!AbstractBiMap.this.containsValue(value) ? 1 : 0) != 0, (String)"value already present: %s", value);
            Object oldValue = this.delegate.setValue(value);
            Preconditions.checkState((boolean)Objects.equal(value, (Object)AbstractBiMap.this.get(this.getKey())), (Object)"entry no longer in map");
            AbstractBiMap.this.updateInverseMap(this.getKey(), true, oldValue, value);
            return oldValue;
        }
    }
}

