/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.client;

import com.teamresourceful.resourcefullib.common.network.Packet;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import tech.thatgravyboat.creeperoverhaul.Creepers;
import tech.thatgravyboat.creeperoverhaul.client.RenderTypes;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.Cosmetics;
import tech.thatgravyboat.creeperoverhaul.client.neoforge.CreepersClientImpl;
import tech.thatgravyboat.creeperoverhaul.client.renderer.cosmetics.CosmeticLayer;
import tech.thatgravyboat.creeperoverhaul.client.renderer.normal.CreeperModel;
import tech.thatgravyboat.creeperoverhaul.client.renderer.normal.CreeperRenderer;
import tech.thatgravyboat.creeperoverhaul.client.renderer.replaced.ReplacedCreeperRenderer;
import tech.thatgravyboat.creeperoverhaul.common.config.ClientConfig;
import tech.thatgravyboat.creeperoverhaul.common.entity.CreeperTypes;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.BaseCreeper;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.CreeperType;
import tech.thatgravyboat.creeperoverhaul.common.network.NetworkHandler;
import tech.thatgravyboat.creeperoverhaul.common.network.packets.ServerboundCosmeticPacket;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModBlocks;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModEntities;
import tech.thatgravyboat.creeperoverhaul.mixin.LivingEntityRendererInvoker;

public class CreepersClient {
    public static void init() {
        Creepers.CONFIGURATOR.register(ClientConfig.class);
        Cosmetics.init();
        ClientConfig.showCosmetic.addListener((oldValue, newValue) -> {
            if (Minecraft.getInstance().level == null) {
                return;
            }
            NetworkHandler.NETWORK.sendToServer((Packet)new ServerboundCosmeticPacket((boolean)newValue));
        });
    }

    public static void registerEntityLayers(Function<PlayerSkin.Model, PlayerRenderer> getter) {
        PlayerRenderer defaultRenderer = getter.apply(PlayerSkin.Model.WIDE);
        PlayerRenderer slimRenderer = getter.apply(PlayerSkin.Model.SLIM);
        LivingEntityRendererInvoker defaultInvoker = (LivingEntityRendererInvoker)defaultRenderer;
        LivingEntityRendererInvoker slimInvoker = (LivingEntityRendererInvoker)slimRenderer;
        if (defaultRenderer != null && slimRenderer != null) {
            defaultInvoker.invokeAddLayer(new CosmeticLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)defaultRenderer));
            slimInvoker.invokeAddLayer(new CosmeticLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)slimRenderer));
        }
    }

    public static void registerRenderers() {
        CreepersClient.registerRenderer(ModEntities.JUNGLE_CREEPER, CreepersClient.createRenderer(CreeperTypes.JUNGLE));
        CreepersClient.registerRenderer(ModEntities.BAMBOO_CREEPER, CreepersClient.createRenderer(CreeperTypes.BAMBOO));
        CreepersClient.registerRenderer(ModEntities.DESERT_CREEPER, CreepersClient.createRenderer(CreeperTypes.DESERT));
        CreepersClient.registerRenderer(ModEntities.BADLANDS_CREEPER, CreepersClient.createRenderer(CreeperTypes.BADLANDS));
        CreepersClient.registerRenderer(ModEntities.HILLS_CREEPER, CreepersClient.createRenderer(CreeperTypes.HILLS));
        CreepersClient.registerRenderer(ModEntities.SAVANNAH_CREEPER, CreepersClient.createRenderer(CreeperTypes.SAVANNAH));
        CreepersClient.registerRenderer(ModEntities.MUSHROOM_CREEPER, CreepersClient.createRenderer(CreeperTypes.MUSHROOM));
        CreepersClient.registerRenderer(ModEntities.SWAMP_CREEPER, CreepersClient.createRenderer(CreeperTypes.SWAMP));
        CreepersClient.registerRenderer(ModEntities.DRIPSTONE_CREEPER, CreepersClient.createRenderer(CreeperTypes.DRIPSTONE));
        CreepersClient.registerRenderer(ModEntities.CAVE_CREEPER, CreepersClient.createRenderer(CreeperTypes.CAVE));
        CreepersClient.registerRenderer(ModEntities.DARK_OAK_CREEPER, CreepersClient.createRenderer(CreeperTypes.DARK_OAK));
        CreepersClient.registerRenderer(ModEntities.SPRUCE_CREEPER, CreepersClient.createRenderer(CreeperTypes.SPRUCE));
        CreepersClient.registerRenderer(ModEntities.BEACH_CREEPER, CreepersClient.createRenderer(CreeperTypes.BEACH));
        CreepersClient.registerRenderer(ModEntities.SNOWY_CREEPER, CreepersClient.createRenderer(CreeperTypes.SNOWY));
        CreepersClient.registerRenderer(ModEntities.OCEAN_CREEPER, CreepersClient.createRenderer(CreeperTypes.OCEAN));
        CreepersClient.registerRenderer(ModEntities.BIRCH_CREEPER, CreepersClient.createRenderer(CreeperTypes.BIRCH));
        if (ClientConfig.replaceDefaultCreeper) {
            CreepersClient.registerRenderer(EntityType.CREEPER, ReplacedCreeperRenderer::new);
        }
        CreepersClient.registerBlockRenderType(ModBlocks.TINY_CACTUS, RenderTypes.cutout());
        CreepersClient.registerBlockRenderType(ModBlocks.POTTED_TINY_CACTUS, RenderTypes.cutout());
    }

    private static <E extends BaseCreeper> EntityRendererProvider<E> createRenderer(CreeperType type) {
        return manager -> new CreeperRenderer(manager, new CreeperModel(type));
    }

    public static <E extends Entity> void registerRenderer(Supplier<EntityType<E>> entity, EntityRendererProvider<E> renderer) {
        CreepersClient.registerRenderer(entity.get(), renderer);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <E extends Entity> void registerRenderer(EntityType<E> entity, EntityRendererProvider<E> renderer) {
        void var1_1;
        CreepersClientImpl.registerRenderer(entity, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockRenderType(Supplier<Block> block, RenderType type) {
        void var1_1;
        CreepersClientImpl.registerBlockRenderType(block, (RenderType)var1_1);
    }
}

