/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.afterdark;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("./config/afterdark.json");
    public static Config INSTANCE = new Config();
    public float catalystSpawnChance = 0.15f;
    public boolean shouldSpawnCatalyst = true;
    public String[] lootTables = new String[]{"minecraft:chests/abandoned_mineshaft", "minecraft:chests/ancient_city", "minecraft:chests/buried_treasure", "minecraft:chests/end_city_treasure", "minecraft:chests/ruined_portal", "minecraft:chests/nether_bridge"};
    public boolean canReturnWithoutCatalyst = true;
    public boolean shouldGrassBurn = false;
    public List<String> GrassBlocks = List.of("minecraft:short_grass", "minecraft:tall_grass");
    public int SafeTeleportCheckRadius = 20;
    public int TeleportCatalystUses = 5;
    public boolean shouldTeleportReturnToSetWorld = false;
    public String returnSetWorld = "minecraft:overworld";

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                INSTANCE = (Config)GSON.fromJson((Reader)reader, Config.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Config.save();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

