/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.afterdark.features;

import com.mojang.serialization.Codec;
import dev.denismasterherobrine.afterdark.features.configuration.WaterloggableRandomPatchConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class WaterloggableRandomPatchFeature
extends Feature<WaterloggableRandomPatchConfiguration> {
    public WaterloggableRandomPatchFeature(Codec<WaterloggableRandomPatchConfiguration> pContext) {
        super(pContext);
    }

    public boolean place(FeaturePlaceContext<WaterloggableRandomPatchConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        RandomSource random = pContext.random();
        WaterloggableRandomPatchConfiguration randomPatchConfiguration = (WaterloggableRandomPatchConfiguration)pContext.config();
        int i = 0;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int j = randomPatchConfiguration.xz_spread + 1;
        int k = randomPatchConfiguration.y_spread + 1;
        for (int l = 0; l < randomPatchConfiguration.tries; ++l) {
            mutableBlockPos.setWithOffset((Vec3i)blockpos, random.nextInt(j) - random.nextInt(j), random.nextInt(k) - random.nextInt(k), random.nextInt(j) - random.nextInt(j));
            if (worldgenlevel.getBlockState((BlockPos)mutableBlockPos).equals(Blocks.WATER)) {
                this.placeBlock(worldgenlevel, (BlockPos)mutableBlockPos, randomPatchConfiguration.to_place.getState(random, (BlockPos)mutableBlockPos));
            }
            ++i;
        }
        return i > 0;
    }

    private boolean placeBlock(WorldGenLevel worldGenLevel, BlockPos blockPos, BlockState blockState) {
        if (!blockState.canSurvive((LevelReader)worldGenLevel, blockPos)) {
            return false;
        }
        if (blockState.getBlock() instanceof DoublePlantBlock) {
            if (!worldGenLevel.isEmptyBlock(blockPos.above())) {
                return false;
            }
            DoublePlantBlock.placeAt((LevelAccessor)worldGenLevel, (BlockState)blockState, (BlockPos)blockPos, (int)2);
            return true;
        }
        if (blockState.getProperties().contains(BlockStateProperties.WATERLOGGED) && worldGenLevel.getBlockState(blockPos).is(Blocks.WATER)) {
            worldGenLevel.setBlock(blockPos, (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
        }
        worldGenLevel.setBlock(blockPos, blockState, 2);
        return true;
    }
}

