/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.afterdark.loot.lootTables;

import dev.denismasterherobrine.afterdark.Config;
import dev.denismasterherobrine.afterdark.registry.AfterdarkRegistry;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class CommonLootModifier {
    private static final List<ResourceLocation> lootTablesIds = List.of(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/ancient_city"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/buried_treasure"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/ruined_portal"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/nether_bridge"));

    public static LootPool.Builder createLootPool() {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)(Config.INSTANCE.shouldSpawnCatalyst ? 1.0f : 0.0f))).when(LootItemRandomChanceCondition.randomChance((float)Config.INSTANCE.catalystSpawnChance)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)AfterdarkRegistry.TELEPORT_CATALYST_ITEM)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f)));
    }

    public static boolean isTargetLootTable(ResourceLocation id) {
        List<String> lootTables = List.of(Config.INSTANCE.lootTables);
        for (String lootTable : lootTables) {
            if (!id.toString().equals(lootTable)) continue;
            return true;
        }
        return false;
    }
}

