/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.grim_and_bleak.item;

import java.util.List;
import net.mcreator.grim_and_bleak.init.GrimAndBleakModItems;
import net.mcreator.grim_and_bleak.procedures.DarksteelBattleaxeToolInHandTickProcedure;
import net.mcreator.grim_and_bleak.procedures.TemplarClaymoreLivingEntityIsHitWithToolProcedure;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class TemplarClaymoreItem
extends SwordItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 0;
        }

        public float getSpeed() {
            return 4.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_STONE_TOOL;
        }

        public int getEnchantmentValue() {
            return 15;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of();
        }
    };

    public TemplarClaymoreItem() {
        super(TOOL_TIER, new Item.Properties().attributes(SwordItem.createAttributes((Tier)TOOL_TIER, (float)11.0f, (float)-3.4f)));
    }

    @SubscribeEvent
    public static void handleToolDamage(ModifyDefaultComponentsEvent event) {
        event.modify((ItemLike)GrimAndBleakModItems.TEMPLAR_CLAYMORE.get(), builder -> builder.remove(DataComponents.MAX_DAMAGE));
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        TemplarClaymoreLivingEntityIsHitWithToolProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, (Entity)sourceentity);
        return retval;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.grim_and_bleak.templar_claymore.description_0"));
        list.add((Component)Component.translatable((String)"item.grim_and_bleak.templar_claymore.description_1"));
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            DarksteelBattleaxeToolInHandTickProcedure.execute(entity);
        }
    }
}

