/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.grim_and_bleak.network;

import java.util.function.Supplier;
import net.mcreator.grim_and_bleak.GrimAndBleakMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class GrimAndBleakModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"grim_and_bleak");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        GrimAndBleakMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        GrimAndBleakMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"grim_and_bleak", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"grim_and_bleak", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double MustShowPossessedOverlay = 0.0;
        public double lightX = 0.0;
        public double lightY = 0.0;
        public double lightZ = 0.0;
        public double darksteelarmors = 0.0;
        public double PX = 0.0;
        public double PY = 0.0;
        public double PZ = 0.0;
        public double CamShake = 0.0;
        public double lightarmorpieces = 0.0;
        public double heavyarmorpieces = 0.0;
        public double sX = 0.0;
        public double sY = 0.0;
        public double sZ = 0.0;
        public double decaydelay = 0.0;
        public double MustShowAbsolutePain = 0.0;
        public boolean IsTheGateKeeper = false;
        public double worthiness = 0.0;
        public double ritual_number = 0.0;
        public boolean chosenabilitycooldown = false;
        public double abilityduration = 0.0;
        public ItemStack Armor0 = ItemStack.EMPTY;
        public ItemStack Armor1 = ItemStack.EMPTY;
        public ItemStack Armor2 = ItemStack.EMPTY;
        public ItemStack Armor3 = ItemStack.EMPTY;
        public ItemStack PredDaggerItem = ItemStack.EMPTY;
        public double gatex = 0.0;
        public double gatez = 0.0;
        public double heartbleat_frame = 0.0;
        public double mustshowthorns = -1.0;
        public boolean damned = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("MustShowPossessedOverlay", this.MustShowPossessedOverlay);
            nbt.putDouble("lightX", this.lightX);
            nbt.putDouble("lightY", this.lightY);
            nbt.putDouble("lightZ", this.lightZ);
            nbt.putDouble("darksteelarmors", this.darksteelarmors);
            nbt.putDouble("PX", this.PX);
            nbt.putDouble("PY", this.PY);
            nbt.putDouble("PZ", this.PZ);
            nbt.putDouble("CamShake", this.CamShake);
            nbt.putDouble("lightarmorpieces", this.lightarmorpieces);
            nbt.putDouble("heavyarmorpieces", this.heavyarmorpieces);
            nbt.putDouble("sX", this.sX);
            nbt.putDouble("sY", this.sY);
            nbt.putDouble("sZ", this.sZ);
            nbt.putDouble("decaydelay", this.decaydelay);
            nbt.putDouble("MustShowAbsolutePain", this.MustShowAbsolutePain);
            nbt.putBoolean("IsTheGateKeeper", this.IsTheGateKeeper);
            nbt.putDouble("worthiness", this.worthiness);
            nbt.putDouble("ritual_number", this.ritual_number);
            nbt.putBoolean("chosenabilitycooldown", this.chosenabilitycooldown);
            nbt.putDouble("abilityduration", this.abilityduration);
            nbt.put("Armor0", this.Armor0.saveOptional(lookupProvider));
            nbt.put("Armor1", this.Armor1.saveOptional(lookupProvider));
            nbt.put("Armor2", this.Armor2.saveOptional(lookupProvider));
            nbt.put("Armor3", this.Armor3.saveOptional(lookupProvider));
            nbt.put("PredDaggerItem", this.PredDaggerItem.saveOptional(lookupProvider));
            nbt.putDouble("gatex", this.gatex);
            nbt.putDouble("gatez", this.gatez);
            nbt.putDouble("heartbleat_frame", this.heartbleat_frame);
            nbt.putDouble("mustshowthorns", this.mustshowthorns);
            nbt.putBoolean("damned", this.damned);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.MustShowPossessedOverlay = nbt.getDouble("MustShowPossessedOverlay");
            this.lightX = nbt.getDouble("lightX");
            this.lightY = nbt.getDouble("lightY");
            this.lightZ = nbt.getDouble("lightZ");
            this.darksteelarmors = nbt.getDouble("darksteelarmors");
            this.PX = nbt.getDouble("PX");
            this.PY = nbt.getDouble("PY");
            this.PZ = nbt.getDouble("PZ");
            this.CamShake = nbt.getDouble("CamShake");
            this.lightarmorpieces = nbt.getDouble("lightarmorpieces");
            this.heavyarmorpieces = nbt.getDouble("heavyarmorpieces");
            this.sX = nbt.getDouble("sX");
            this.sY = nbt.getDouble("sY");
            this.sZ = nbt.getDouble("sZ");
            this.decaydelay = nbt.getDouble("decaydelay");
            this.MustShowAbsolutePain = nbt.getDouble("MustShowAbsolutePain");
            this.IsTheGateKeeper = nbt.getBoolean("IsTheGateKeeper");
            this.worthiness = nbt.getDouble("worthiness");
            this.ritual_number = nbt.getDouble("ritual_number");
            this.chosenabilitycooldown = nbt.getBoolean("chosenabilitycooldown");
            this.abilityduration = nbt.getDouble("abilityduration");
            this.Armor0 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Armor0"));
            this.Armor1 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Armor1"));
            this.Armor2 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Armor2"));
            this.Armor3 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Armor3"));
            this.PredDaggerItem = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("PredDaggerItem"));
            this.gatex = nbt.getDouble("gatex");
            this.gatez = nbt.getDouble("gatez");
            this.heartbleat_frame = nbt.getDouble("heartbleat_frame");
            this.mustshowthorns = nbt.getDouble("mustshowthorns");
            this.damned = nbt.getBoolean("damned");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "grim_and_bleak_mapvars";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "grim_and_bleak_worldvars";
        public boolean PortalBreached = false;
        public double stormy = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.PortalBreached = nbt.getBoolean("PortalBreached");
            this.stormy = nbt.getDouble("stormy");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("PortalBreached", this.PortalBreached);
            nbt.putDouble("stormy", this.stormy);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.lightX = original.lightX;
            clone.lightY = original.lightY;
            clone.lightZ = original.lightZ;
            clone.PX = original.PX;
            clone.PY = original.PY;
            clone.PZ = original.PZ;
            clone.sX = original.sX;
            clone.sY = original.sY;
            clone.sZ = original.sZ;
            clone.IsTheGateKeeper = original.IsTheGateKeeper;
            clone.worthiness = original.worthiness;
            clone.gatex = original.gatex;
            clone.gatez = original.gatez;
            clone.damned = original.damned;
            if (!event.isWasDeath()) {
                clone.MustShowPossessedOverlay = original.MustShowPossessedOverlay;
                clone.darksteelarmors = original.darksteelarmors;
                clone.CamShake = original.CamShake;
                clone.lightarmorpieces = original.lightarmorpieces;
                clone.heavyarmorpieces = original.heavyarmorpieces;
                clone.decaydelay = original.decaydelay;
                clone.MustShowAbsolutePain = original.MustShowAbsolutePain;
                clone.ritual_number = original.ritual_number;
                clone.chosenabilitycooldown = original.chosenabilitycooldown;
                clone.abilityduration = original.abilityduration;
                clone.Armor0 = original.Armor0;
                clone.Armor1 = original.Armor1;
                clone.Armor2 = original.Armor2;
                clone.Armor3 = original.Armor3;
                clone.PredDaggerItem = original.PredDaggerItem;
                clone.heartbleat_frame = original.heartbleat_frame;
                clone.mustshowthorns = original.mustshowthorns;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

