/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.jinxedlib.core.mixin;

import com.kekecreations.jinxedlib.common.data.CompostableUtils;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.WorkAtComposter;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorkAtComposter.class})
public class WorkAtComposterMixin {
    @Shadow
    private static final List<Item> COMPOSTABLE_ITEMS = List.of();

    @Shadow
    private void spawnComposterFillEffects(ServerLevel pLevel, BlockState pPreState, BlockPos pPos, BlockState pPostState) {
        pLevel.levelEvent(1500, pPos, pPostState != pPreState ? 1 : 0);
    }

    @Inject(method={"compostItems"}, at={@At(value="INVOKE", target="net/minecraft/world/entity/npc/Villager.getInventory ()Lnet/minecraft/world/SimpleContainer;")})
    public void jinxedlib_compostItems(ServerLevel pLevel, Villager pVillager, GlobalPos pGlobal, BlockState pState, CallbackInfo ci) {
        BlockPos blockPos = pGlobal.pos();
        int i = 20;
        SimpleContainer simplecontainer = pVillager.getInventory();
        int k = simplecontainer.getContainerSize();
        BlockState blockstate = pState;
        Reference2IntOpenHashMap amounts = new Reference2IntOpenHashMap(COMPOSTABLE_ITEMS.size() * 256);
        for (int l = k - 1; l >= 0 && i > 0; --l) {
            ItemStack itemstack = simplecontainer.getItem(l);
            if (!CompostableUtils.canVillagerCompost(pLevel.registryAccess(), itemstack)) continue;
            int j1 = itemstack.getCount();
            int k1 = amounts.getInt((Object)itemstack.getItem()) + j1;
            amounts.put((Object)itemstack.getItem(), k1);
            int l1 = Math.min(Math.min(k1 - 10, i), j1);
            if (l1 <= 0) continue;
            i -= l1;
            for (int i2 = 0; i2 < l1; ++i2) {
                if ((Integer)(blockstate = ComposterBlock.insertItem((Entity)pVillager, (BlockState)blockstate, (ServerLevel)pLevel, (ItemStack)itemstack, (BlockPos)blockPos)).getValue((Property)ComposterBlock.LEVEL) != 7) continue;
                this.spawnComposterFillEffects(pLevel, pState, blockPos, blockstate);
                return;
            }
        }
    }
}

