/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.entities;

import it.hurts.octostudios.reliquified_ars_nouveau.init.EntityRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.bracelet.BallistarianBracerItem;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.sync.S2CEntityMotionPacket;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BallistarianBowEntity
extends Mob
implements GeoEntity,
OwnableEntity {
    private LivingEntity target;
    private UUID ownerUUID;

    public BallistarianBowEntity(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    public void tick() {
        BallistarianBracerItem relic;
        super.tick();
        if (this.getCommandSenderWorld().isClientSide()) {
            return;
        }
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            this.discard();
            return;
        }
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)owner, (Item)((Item)ItemRegistry.BALLISTARIAN_BRACER.value()));
        Item item = stack.getItem();
        if (!(item instanceof BallistarianBracerItem) || !(relic = (BallistarianBracerItem)item).getUUIDListFromComponents(stack).contains(this.getUUID())) {
            this.discard();
            return;
        }
        if (this.isDeadOrDying()) {
            ((ServerLevel)this.getCommandSenderWorld()).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(221, 140 + this.random.nextInt(35), this.random.nextInt(36)), (float)0.35f, (int)40, (float)0.8f), this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), 10, 0.0, 0.1, 0.0, 0.05);
            relic.setCooldown(stack, this.getStringUUID(), (int)Math.round(relic.getStatValue(stack, "striker", "cooldown") * 20.0));
            this.discard();
        }
        int index = relic.getUUIDListFromComponents(stack).indexOf(this.getUUID());
        int maxCount = (int)Math.round(relic.getStatValue(stack, "striker", "count"));
        Vec3 normalizedLookAngle = owner.getLookAngle().normalize();
        Pair<Vec3, Double> pair = this.calculateOffsetAndHeight(index, maxCount, normalizedLookAngle);
        Vec3 offset = (Vec3)pair.getLeft();
        Vec3 targetPosition = owner.position().add(offset.x, owner.getEyeY() - owner.getY() + (Double)pair.getRight(), offset.z);
        NetworkHandler.sendToClientsTrackingEntity((CustomPacketPayload)new S2CEntityMotionPacket(this.getId(), this.getDeltaMovement()), (Entity)this);
        this.setDeltaMovement(targetPosition.subtract(this.position()).scale(Mth.clamp((double)(owner.getKnownMovement().length() * 1.5), (double)0.1, (double)0.75)));
        this.rotatedBowAngle(normalizedLookAngle, maxCount, index);
    }

    public void rotatedBowAngle(Vec3 vec, int total, int index) {
        Integer rowSize;
        int count;
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return;
        }
        ArrayList<Integer> rows = new ArrayList<Integer>();
        int remaining = total;
        for (int size = 8; size > 0 && remaining > 0; remaining -= count, size -= 2) {
            count = Math.min(size, remaining);
            rows.add(count);
        }
        int row = 0;
        int localIndex = index;
        for (int i = 0; i < rows.size(); ++i) {
            int rowSize2 = (Integer)rows.get(i);
            if (localIndex < rowSize2) {
                row = i;
                break;
            }
            localIndex -= ((Integer)rows.get(i)).intValue();
        }
        boolean isOdd = (rowSize = (Integer)rows.get(row)) % 2 != 0;
        int centerIndex = rowSize / 2;
        if (isOdd && localIndex == centerIndex) {
            this.setYRot(owner.getYRot());
            this.setXRot(0.0f);
            this.yBodyRot = this.yHeadRot = this.getYRot();
            this.yRotO = this.yHeadRot;
            return;
        }
        double radians = Math.toRadians(15.0 * (isOdd ? (double)(localIndex - centerIndex) : (double)(localIndex - centerIndex) + 0.5));
        Vec3 rotatedVec = new Vec3(vec.x * Math.cos(radians) - vec.z * Math.sin(radians), vec.y, vec.x * Math.sin(radians) + vec.z * Math.cos(radians));
        this.setYRot((float)Math.toDegrees(Math.atan2(rotatedVec.z, rotatedVec.x)) - 90.0f);
        this.setXRot((float)(-Math.toDegrees(Math.atan2(rotatedVec.y, Math.sqrt(rotatedVec.x * rotatedVec.x + rotatedVec.z * rotatedVec.z)))));
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
    }

    public Pair<Vec3, Double> calculateOffsetAndHeight(int index, int total, Vec3 lookVec) {
        int count;
        int radius = 3;
        if (lookVec.y > 0.7) {
            double angle = Math.toRadians(360.0 * (double)index / (double)total);
            return Pair.of((Object)new Vec3(Math.cos(angle), 0.0, Math.sin(angle)).scale((double)(radius + 1)), (Object)0.3);
        }
        if (lookVec.y < -0.7) {
            double angle = Math.toRadians(360.0 * (double)index / (double)total);
            return Pair.of((Object)new Vec3(Math.cos(angle), 0.0, Math.sin(angle)).scale((double)(radius + 1)), (Object)-1.8);
        }
        Vec3 backVec = lookVec.scale(-1.0);
        Vec3 sideVec = new Vec3(-lookVec.z, 0.0, lookVec.x);
        ArrayList<Integer> rows = new ArrayList<Integer>();
        int remaining = total;
        for (int size = 8; size > 0 && remaining > 0; remaining -= count, size -= 2) {
            count = Math.min(size, remaining);
            rows.add(count);
        }
        int row = 0;
        int localIndex = index;
        for (int i = 0; i < rows.size(); ++i) {
            int rowSize = (Integer)rows.get(i);
            if (localIndex < rowSize) {
                row = i;
                break;
            }
            localIndex -= rowSize;
        }
        double centerOffset = (double)((Integer)rows.get(row) - 1) / 2.0;
        double sideOffset = ((double)localIndex - centerOffset) * 1.0;
        if ((double)localIndex == centerOffset) {
            sideOffset = 0.0;
        }
        return Pair.of((Object)backVec.scale((double)radius * 0.5).add(sideVec.scale(sideOffset)), (Object)(0.6 + (double)row * 1.0));
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity entity = source.getEntity();
        if (entity != null && entity.getUUID().equals(this.ownerUUID)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.hasUUID("OwnerUUID")) {
            this.ownerUUID = tag.getUUID("OwnerUUID");
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (this.ownerUUID != null) {
            tag.putUUID("OwnerUUID", this.ownerUUID);
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.getOwnerUUID() == null) {
            return null;
        }
        return this.getCommandSenderWorld().getPlayerByUUID(this.ownerUUID);
    }

    public boolean isNoGravity() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    public void setOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
    public static class RegistryAttributesHandlerEvent {
        @SubscribeEvent
        public static void onRegisterAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)EntityRegistry.BALLISTARIAN_BOW.get(), Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).build());
        }
    }
}

