/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.ring;

import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketClientRewindEffect;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import top.theillusivec4.curios.api.SlotContext;

public class RingOfLastWillItem
extends NouveauRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"hibernation").stat(StatData.builder((String)"cooldown").initialValue(60.0, 50.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.05).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"hibernation").initialValue(1).gem(GemShape.SQUARE, GemColor.RED).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-10795448).borderBottom(-10795448).textured(true).build()).beams(BeamsData.builder().startColor(-4259285).endColor(16527800).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide() || this.getCooldown(stack) == 0) {
            return;
        }
        this.consumeCooldown(stack, 1);
        if (this.getCooldown(stack) == 0) {
            ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
            RandomSource random = level.getRandom();
            for (int i = 0; i < 100; ++i) {
                double angle = Math.PI * 2 * (double)i / 100.0;
                level.sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(100 + random.nextInt(156), random.nextInt(100 + random.nextInt(156)), random.nextInt(100 + random.nextInt(156))), (float)0.3f, (int)60, (float)0.95f), player.getX() + 1.0 * Math.cos(angle), player.getY() + (double)0.1f, player.getZ() + 1.0 * Math.sin(angle), 1, 0.0, 0.1, 0.0, 0.1);
                level.playSound(null, (Entity)player, SoundEvents.TRIAL_SPAWNER_SPAWN_MOB, SoundSource.PLAYERS, 0.3f, 0.9f + random.nextFloat() * 0.2f);
            }
        }
    }

    public void consumeCooldown(ItemStack stack, int time) {
        this.setCooldown(stack, this.getCooldown(stack) - time);
    }

    public void setCooldown(ItemStack stack, int cooldown) {
        stack.set((Supplier)DataComponentRegistry.COOLDOWN, (Object)Math.max(cooldown, 0));
    }

    public int getCooldown(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.COOLDOWN, (Object)0);
    }

    @EventBusSubscriber
    public static class RingOfLastWillEvent {
        @SubscribeEvent
        public static void onDeathPlayer(LivingDeathEvent event) {
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide()) {
                return;
            }
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.RING_OF_LAST_WILL.value()))) {
                RingOfLastWillItem relic;
                Item item = stack.getItem();
                if (!(item instanceof RingOfLastWillItem) || !(relic = (RingOfLastWillItem)item).isAbilityUnlocked(stack, "hibernation") || relic.getCooldown(stack) > 0) continue;
                ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
                RandomSource random = level.getRandom();
                level.playSound(null, (Entity)player, SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 1.0f, 0.9f + random.nextFloat() * 0.2f);
                player.setHealth(2.0f);
                relic.setCooldown(stack, (int)MathUtils.round((double)(relic.getStatValue(stack, "hibernation", "cooldown") * 20.0), (int)0));
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
                Networking.sendToNearbyClient((Level)level, (Entity)player, (CustomPacketPayload)new PacketClientRewindEffect(60, (Entity)player));
                event.setCanceled(true);
                for (int i = 0; i < 50; ++i) {
                    level.sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(100 + random.nextInt(156), random.nextInt(100 + random.nextInt(156)), random.nextInt(100 + random.nextInt(156))), (float)0.5f, (int)60, (float)0.95f), player.getX(), player.getY() + 1.0, player.getZ(), 1, (random.nextDouble() - 0.5) * 3.0, random.nextDouble() * 1.5, (random.nextDouble() - 0.5) * 3.0, 0.05);
                }
            }
        }
    }
}

