/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.entity;

import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.config.util.SpawnData;
import com.tristankechlo.livingthings.config.values.ListValue;
import com.tristankechlo.livingthings.config.values.NumberValue;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;

public final class ShroomieConfig
extends EntityConfig {
    private static final ShroomieConfig INSTANCE = new ShroomieConfig();
    public final NumberValue.DoubleValue health = new NumberValue.DoubleValue("health", 10.0, 1.0, 1024.0);
    public final NumberValue.DoubleValue movementSpeed = new NumberValue.DoubleValue("movementSpeed", 0.2, 0.0, 1024.0);
    public final NumberValue.IntegerValue maxSpawnedInChunk = new NumberValue.IntegerValue("maxSpawnedInChunk", 5, 1, 15);
    public final ListValue<SpawnData> spawnBiomes = new ListValue<SpawnData>("spawnBiomes", ShroomieConfig.createDefaultSpawns(), SpawnData::serialize, SpawnData::deserialize);
    public final NumberValue.IntegerValue colorBrownWeight = new NumberValue.IntegerValue("colorBrownWeight", 50, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue colorRedWeight = new NumberValue.IntegerValue("colorRedWeight", 50, 0, Integer.MAX_VALUE);

    private ShroomieConfig() {
        super("shroomie");
        this.registerConfigValues(this.health, this.movementSpeed, this.maxSpawnedInChunk, this.spawnBiomes);
        this.registerForCategory("colorWeights", this.colorBrownWeight, this.colorRedWeight);
    }

    public static ShroomieConfig get() {
        return INSTANCE;
    }

    public static double health() {
        return (Double)ShroomieConfig.INSTANCE.health.get();
    }

    public static double movementSpeed() {
        return (Double)ShroomieConfig.INSTANCE.movementSpeed.get();
    }

    public static int maxSpawnedInChunk() {
        return (Integer)ShroomieConfig.INSTANCE.maxSpawnedInChunk.get();
    }

    private static List<SpawnData> createDefaultSpawns() {
        return List.of(new SpawnData(20, 5, 7, new ResourceKey[]{Biomes.MUSHROOM_FIELDS}));
    }
}

