/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.PeacockConfig;
import com.tristankechlo.livingthings.entity.ai.PeacockDestroyCropBlocks;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class PeacockEntity
extends Animal
implements ILexiconEntry {
    private static final EntityDataAccessor<Boolean> PANIC = SynchedEntityData.defineId(PeacockEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FLUFFED = SynchedEntityData.defineId(PeacockEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DESTROYING_CROPS = SynchedEntityData.defineId(PeacockEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final UniformInt FLUFFED_TIME = TimeUtil.rangeOfSeconds((int)10, (int)60);
    private int fluffedTime;

    public PeacockEntity(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, PeacockConfig.health()).add(Attributes.MOVEMENT_SPEED, PeacockConfig.movementSpeed());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PeacockPanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredients.PEACOCK_FOOD, false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new PeacockDestroyCropBlocks(this));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PANIC, (Object)false);
        builder.define(FLUFFED, (Object)false);
        builder.define(DESTROYING_CROPS, (Object)false);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.entityData.set(FLUFFED, (Object)nbt.getBoolean("Fluffed"));
        this.fluffedTime = nbt.getInt("FluffedTime");
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("Fluffed", ((Boolean)this.entityData.get(FLUFFED)).booleanValue());
        nbt.putInt("FluffedTime", this.fluffedTime);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(LivingThingsTags.PEACOCK_FOOD);
    }

    public static <T extends Animal> boolean checkPeacockSpawnRules(EntityType<T> entityType, ServerLevelAccessor world, MobSpawnType mobSpawnType, BlockPos pos, RandomSource randomSource) {
        return world.getBlockState(pos.below()).is(LivingThingsTags.PEACOCK_SPAWNABLE_ON) && PeacockEntity.isBrightEnoughToSpawn((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob parent) {
        return (AgeableMob)ModEntityTypes.PEACOCK.get().create((Level)level);
    }

    public int getMaxSpawnClusterSize() {
        return PeacockConfig.maxSpawnedInChunk();
    }

    public void setInPanic(boolean panic) {
        this.entityData.set(PANIC, (Object)panic);
    }

    public boolean isInPanic() {
        return (Boolean)this.entityData.get(PANIC) != false || this.getLastHurtByMob() != null || this.isFreezing() || this.isOnFire();
    }

    public boolean isTailFluffed() {
        return this.isInPanic() || (Boolean)this.entityData.get(FLUFFED) != false;
    }

    public void startFluffing() {
        this.fluffedTime = FLUFFED_TIME.sample(this.random);
        this.entityData.set(FLUFFED, (Object)true);
    }

    public void setInLove(Player player) {
        super.setInLove(player);
        this.entityData.set(FLUFFED, (Object)true);
    }

    public void resetLove() {
        super.resetLove();
        this.startFluffing();
    }

    public void aiStep() {
        super.aiStep();
        if (this.isDestroyingCrops() && this.random.nextInt(5) == 0) {
            BlockPos pos = this.blockPosition();
            this.level().levelEvent(2001, pos, Block.getId((BlockState)Blocks.FARMLAND.defaultBlockState()));
        }
        if (this.fluffedTime > 0) {
            --this.fluffedTime;
            if (this.fluffedTime == 0) {
                this.entityData.set(FLUFFED, (Object)false);
                return;
            }
        }
        if (!((Boolean)this.entityData.get(FLUFFED)).booleanValue() && this.random.nextInt(4000) == 0) {
            this.startFluffing();
        }
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.PEACOCK;
    }

    public int getAmbientSoundInterval() {
        return (Integer)PeacockConfig.get().talkInterval.get();
    }

    protected SoundEvent getAmbientSound() {
        return ModSounds.PEACOCK_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.PEACOCK_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.PEACOCK_DEATH.get();
    }

    public boolean isDestroyingCrops() {
        return (Boolean)this.entityData.get(DESTROYING_CROPS);
    }

    public void setDestroyingCrops(boolean eating) {
        this.entityData.set(DESTROYING_CROPS, (Object)eating);
    }

    private static class PeacockPanicGoal
    extends PanicGoal {
        public PeacockPanicGoal(PathfinderMob mob, double speed) {
            super(mob, speed);
        }

        public void start() {
            super.start();
            ((PeacockEntity)this.mob).setInPanic(true);
        }

        public void stop() {
            super.stop();
            ((PeacockEntity)this.mob).setInPanic(false);
        }
    }
}

