/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.providers;

import com.aetherteam.nitrogen.data.providers.NitrogenItemModelProvider;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public abstract class AetherItemModelProvider
extends NitrogenItemModelProvider {
    public AetherItemModelProvider(PackOutput output, String id, ExistingFileHelper helper) {
        super(output, id, helper);
    }

    public void lanceItem(Item item, String location) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 45.0f).translation(0.0f, 1.0f, -5.0f).scale(0.85f, 0.85f, 0.85f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -45.0f).translation(0.0f, 1.0f, -5.0f).scale(0.85f, 0.85f, 0.85f).end().end();
    }

    public void nameableWeapon(Item item, String location, String renamedVariant) {
        ((ItemModelBuilder)this.withExistingParent(renamedVariant, this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + renamedVariant));
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).override().predicate(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"named"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + renamedVariant))).end();
    }

    public void dartShooterItem(Item item, String location) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 45.0f).translation(0.0f, 1.5f, -1.0f).scale(0.85f, 0.85f, 0.85f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -45.0f).translation(0.0f, 1.5f, -1.0f).scale(0.85f, 0.85f, 0.85f).end().end();
    }

    public void glovesItem(Item item, String location) {
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)));
        double index = 0.1;
        for (ResourceKey trimMaterial : NitrogenItemModelProvider.VANILLA_TRIM_MATERIALS) {
            String material = trimMaterial.location().getPath();
            String name = this.itemName(item) + "_" + material + "_trim";
            ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).texture("layer1", this.modLoc("trims/items/gloves_trim_" + material));
            builder.override().predicate(ResourceLocation.withDefaultNamespace((String)"trim_type"), (float)index).model((ModelFile)this.getExistingFile(this.modLoc("item/" + name))).end();
            index += 0.1;
        }
    }

    public void dyedGlovesItem(Item item, String location) {
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).texture("layer1", this.modLoc("item/" + location + this.itemName(item) + "_overlay"));
        double index = 0.1;
        for (ResourceKey trimMaterial : NitrogenItemModelProvider.VANILLA_TRIM_MATERIALS) {
            String material = trimMaterial.location().getPath();
            String name = this.itemName(item) + "_" + material + "_trim";
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).texture("layer1", this.modLoc("item/" + location + this.itemName(item) + "_overlay"))).texture("layer2", this.modLoc("trims/items/gloves_trim_" + material));
            builder.override().predicate(ResourceLocation.withDefaultNamespace((String)"trim_type"), (float)index).model((ModelFile)this.getExistingFile(this.modLoc("item/" + name))).end();
            index += 0.1;
        }
    }

    public void rotatedItem(Item item, String location) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).transforms().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(90.0f, -90.0f, 25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f, 0.68f, 0.68f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(90.0f, 90.0f, -25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f, 0.68f, 0.68f).end().end();
    }

    public void moaEggItem(Item item, String location) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + "moa_egg"))).texture("layer1", this.modLoc("item/" + location + "moa_egg_spot"));
    }

    public void portalItem(Item item, String location) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).texture("layer1", this.modLoc("item/" + location + this.itemName(item) + "_inside"));
    }

    public void aercloudItem(Block block) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/cube_all"))).texture("all", this.texture(this.blockName(block), "natural/"))).renderType(ResourceLocation.withDefaultNamespace((String)"translucent"));
    }

    public void itemLockedDungeonBlock(Block block, Block baseBlock) {
        this.itemOverlayDungeonBlock(block, baseBlock, "lock");
    }

    public void itemTrappedDungeonBlock(Block block, Block baseBlock) {
        this.itemOverlayDungeonBlock(block, baseBlock, "exclamation");
    }

    public void itemBossDoorwayDungeonBlock(Block block, Block baseBlock) {
        this.itemOverlayDungeonBlock(block, baseBlock, "door");
    }

    public void itemTreasureDoorwayDungeonBlock(Block block, Block baseBlock) {
        this.itemOverlayDungeonBlock(block, baseBlock, "treasure");
    }

    public void itemOverlayDungeonBlock(Block block, Block baseBlock, String overlay) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/cube"))).texture("overlay", ResourceLocation.fromNamespaceAndPath((String)"aether", (String)("block/dungeon/" + overlay)))).texture("face", this.texture(this.blockName(baseBlock), "dungeon/"))).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces((direction, builder) -> builder.texture("#face").cullface(direction).end()).end()).element().from(0.0f, 0.0f, -0.1f).to(16.0f, 16.0f, -0.1f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(8.0f, 8.0f, 6.9f).end().face(Direction.NORTH).texture("#overlay").emissivity(15, 15).end().end()).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(-90.0f, -180.0f, -45.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(-90.0f, -180.0f, -45.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemDisplayContext.GROUND).rotation(90.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.25f, 0.25f, 0.25f).end().transform(ItemDisplayContext.GUI).rotation(30.0f, 135.0f, 0.0f).scale(0.625f, 0.625f, 0.625f).end().transform(ItemDisplayContext.FIXED).scale(0.5f, 0.5f, 0.5f).end().end();
    }
}

