/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.world.feature.LargeIceDripstoneConfiguration;
import com.yungnickyoung.minecraft.yungscavebiomes.world.feature.util.DripstoneIceUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.Vec3;

public class LargeIceDripstoneFeature
extends Feature<LargeIceDripstoneConfiguration> {
    public LargeIceDripstoneFeature(Codec<LargeIceDripstoneConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<LargeIceDripstoneConfiguration> featurePlaceContext) {
        Object t;
        WorldGenLevel worldGenLevel = featurePlaceContext.level();
        BlockPos origin = featurePlaceContext.origin();
        SectionPos originSectionPos = SectionPos.of((BlockPos)origin);
        LargeIceDripstoneConfiguration config = (LargeIceDripstoneConfiguration)featurePlaceContext.config();
        RandomSource random = featurePlaceContext.random();
        if (!DripstoneIceUtils.isEmptyOrWater((LevelAccessor)worldGenLevel, origin)) {
            return false;
        }
        Optional optionalColumn = Column.scan((LevelSimulatedReader)worldGenLevel, (BlockPos)origin, (int)config.floorToCeilingSearchRange, DripstoneUtils::isEmptyOrWater, DripstoneUtils::isDripstoneBaseOrLava);
        if (optionalColumn.isEmpty() || !((t = optionalColumn.get()) instanceof Column.Range)) {
            return false;
        }
        Column.Range range = (Column.Range)t;
        if (range.height() < 4) {
            return false;
        }
        int maxColumnRadius = (int)((float)range.height() * config.maxColumnRadiusToCaveHeightRatio);
        maxColumnRadius = Mth.clamp((int)maxColumnRadius, (int)config.columnRadius.getMinValue(), (int)config.columnRadius.getMaxValue());
        int columnRadius = Mth.randomBetweenInclusive((RandomSource)random, (int)config.columnRadius.getMinValue(), (int)maxColumnRadius);
        LargeIceDripstone stalactite = LargeIceDripstoneFeature.makeIceDripstone(origin.atY(range.ceiling() - 1), false, random, columnRadius, config.stalactiteBluntness, config.heightScale);
        LargeIceDripstone stalagmite = LargeIceDripstoneFeature.makeIceDripstone(origin.atY(range.floor() + 1), true, random, columnRadius, config.stalagmiteBluntness, config.heightScale);
        WindOffsetter windOffsetter = stalactite.isSuitableForWind(config) && stalagmite.isSuitableForWind(config) ? new WindOffsetter(origin.getY(), random, config.windSpeed, config.angle) : WindOffsetter.noWind();
        boolean canSpawnStalactite = stalactite.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldGenLevel, windOffsetter);
        boolean canspawnStalagmite = stalagmite.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldGenLevel, windOffsetter);
        if (canSpawnStalactite) {
            stalactite.placeBlocks(worldGenLevel, random, windOffsetter, config.rareIceChance, originSectionPos);
        }
        if (canspawnStalagmite) {
            stalagmite.placeBlocks(worldGenLevel, random, windOffsetter, config.rareIceChance, originSectionPos);
        }
        return true;
    }

    private static LargeIceDripstone makeIceDripstone(BlockPos blockPos, boolean isPointingUp, RandomSource random, int radius, FloatProvider bluntnessProvider, FloatProvider scaleProvider) {
        return new LargeIceDripstone(blockPos, isPointingUp, radius, bluntnessProvider.sample(random), scaleProvider.sample(random));
    }

    private void placeDebugMarkers(WorldGenLevel worldGenLevel, BlockPos blockPos, Column.Range range, WindOffsetter windOffsetter) {
        worldGenLevel.setBlock(windOffsetter.offset(blockPos.atY(range.ceiling() - 1)), Blocks.DIAMOND_BLOCK.defaultBlockState(), 2);
        worldGenLevel.setBlock(windOffsetter.offset(blockPos.atY(range.floor() + 1)), Blocks.GOLD_BLOCK.defaultBlockState(), 2);
        BlockPos.MutableBlockPos mutableBlockPos = blockPos.atY(range.floor() + 2).mutable();
        while (mutableBlockPos.getY() < range.ceiling() - 1) {
            BlockPos blockPos2 = windOffsetter.offset((BlockPos)mutableBlockPos);
            if (DripstoneIceUtils.isEmptyOrWater((LevelAccessor)worldGenLevel, blockPos2) || worldGenLevel.getBlockState(blockPos2).is(Blocks.DRIPSTONE_BLOCK)) {
                worldGenLevel.setBlock(blockPos2, Blocks.CREEPER_HEAD.defaultBlockState(), 2);
            }
            mutableBlockPos.move(Direction.UP);
        }
    }

    static final class LargeIceDripstone {
        private BlockPos root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargeIceDripstone(BlockPos root, boolean pointingUp, int radius, double bluntness, double scale) {
            this.root = root;
            this.pointingUp = pointingUp;
            this.radius = radius;
            this.bluntness = bluntness;
            this.scale = scale;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        private int getMinY() {
            return this.pointingUp ? this.root.getY() : this.root.getY() - this.getHeight();
        }

        private int getMaxY() {
            return !this.pointingUp ? this.root.getY() : this.root.getY() + this.getHeight();
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(WorldGenLevel worldGenLevel, WindOffsetter windOffsetter) {
            while (this.radius > 1) {
                BlockPos.MutableBlockPos mutable = this.root.mutable();
                for (int i = 0; i < Math.min(10, this.getHeight()); ++i) {
                    if (worldGenLevel.getBlockState((BlockPos)mutable).is(Blocks.LAVA)) {
                        return false;
                    }
                    if (DripstoneIceUtils.isCircleMostlyEmbeddedInStone(worldGenLevel, windOffsetter.offset((BlockPos)mutable), this.radius)) {
                        this.root = mutable;
                        return true;
                    }
                    mutable.move(this.pointingUp ? Direction.DOWN : Direction.UP);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float radialDistance) {
            return (int)DripstoneIceUtils.getDripstoneHeight(radialDistance, this.radius, this.scale, this.bluntness);
        }

        void placeBlocks(WorldGenLevel worldGenLevel, RandomSource random, WindOffsetter windOffsetter, float rareIceChance, SectionPos originSectionPos) {
            boolean hasRareIce;
            boolean bl = hasRareIce = random.nextFloat() < rareIceChance;
            if (this.getHeightAtRadius(0.0f) < 6) {
                hasRareIce = false;
            }
            for (int dx = -this.radius; dx <= this.radius; ++dx) {
                block1: for (int dz = -this.radius; dz <= this.radius; ++dz) {
                    int heightAtCurrPos;
                    float distToCenter = Mth.sqrt((float)(dx * dx + dz * dz));
                    if (!(distToCenter <= (float)this.radius) || (heightAtCurrPos = this.getHeightAtRadius(distToCenter)) <= 0) continue;
                    if (random.nextDouble() < 0.2) {
                        heightAtCurrPos = (int)((float)heightAtCurrPos * Mth.randomBetween((RandomSource)random, (float)0.8f, (float)1.0f));
                    }
                    BlockPos.MutableBlockPos mutable = this.root.offset(dx, 0, dz).mutable();
                    boolean placed = false;
                    int surfaceHeight = this.pointingUp ? worldGenLevel.getHeight(Heightmap.Types.WORLD_SURFACE_WG, mutable.getX(), mutable.getZ()) : Integer.MAX_VALUE;
                    for (int dy = 0; dy < heightAtCurrPos && mutable.getY() < surfaceHeight; ++dy) {
                        BlockPos blockPos = windOffsetter.offset((BlockPos)mutable);
                        if (DripstoneIceUtils.isEmptyOrWaterOrLava((LevelAccessor)worldGenLevel, blockPos)) {
                            placed = true;
                            Block block = Blocks.PACKED_ICE;
                            if (hasRareIce) {
                                double progress = (double)dy / (double)heightAtCurrPos;
                                if (dx == 0 && dz == 0 && dy == (int)((double)heightAtCurrPos / 2.2)) {
                                    block = (Block)BlockModule.RARE_ICE.get();
                                } else if (progress > 0.3 + random.nextDouble() * 0.04) {
                                    block = Blocks.ICE;
                                }
                            }
                            if (this.isBlockInPlacementRange(originSectionPos, blockPos)) {
                                worldGenLevel.setBlock(blockPos, block.defaultBlockState(), 2);
                            }
                        } else if (placed && worldGenLevel.getBlockState(blockPos).is(BlockTags.BASE_STONE_OVERWORLD)) continue block1;
                        mutable.move(this.pointingUp ? Direction.UP : Direction.DOWN);
                    }
                }
            }
        }

        private boolean isSuitableForWind(LargeIceDripstoneConfiguration largeDripstoneConfiguration) {
            return this.radius >= largeDripstoneConfiguration.minRadiusForWind && this.bluntness >= (double)largeDripstoneConfiguration.minBluntnessForWind;
        }

        private boolean isBlockInPlacementRange(SectionPos originSectionPos, BlockPos blockPos) {
            SectionPos blockSectionPos = SectionPos.of((BlockPos)blockPos);
            return Mth.abs((int)(originSectionPos.x() - blockSectionPos.x())) <= 1 && Mth.abs((int)(originSectionPos.z() - blockSectionPos.z())) <= 1;
        }
    }

    static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final Vec3 windSpeed;

        WindOffsetter(int originY, RandomSource random, FloatProvider windSpeedProvider, FloatProvider angleProvider) {
            this.originY = originY;
            float speedAmp = windSpeedProvider.sample(random);
            float radAngle = angleProvider.sample(random);
            this.windSpeed = new Vec3((double)(Mth.cos((float)radAngle) * speedAmp), 0.0, (double)(Mth.sin((float)radAngle) * speedAmp));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        BlockPos offset(BlockPos blockPos) {
            if (this.windSpeed == null) {
                return blockPos;
            }
            int dy = this.originY - blockPos.getY();
            Vec3 vec3 = this.windSpeed.scale((double)dy);
            return blockPos.offset((int)vec3.x, 0, (int)vec3.z);
        }
    }
}

