/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental;

import alexthw.ars_elemental.common.entity.familiars.FirenandoFamiliar;
import alexthw.ars_elemental.common.entity.familiars.FirenandoHolder;
import alexthw.ars_elemental.common.entity.familiars.FlashjackFamiliar;
import alexthw.ars_elemental.common.entity.familiars.FlashjackHolder;
import alexthw.ars_elemental.common.entity.familiars.MermaidHolder;
import alexthw.ars_elemental.common.glyphs.EffectBubbleShield;
import alexthw.ars_elemental.common.glyphs.EffectCharm;
import alexthw.ars_elemental.common.glyphs.EffectConflagrate;
import alexthw.ars_elemental.common.glyphs.EffectConjureTerrain;
import alexthw.ars_elemental.common.glyphs.EffectDischarge;
import alexthw.ars_elemental.common.glyphs.EffectEnvenom;
import alexthw.ars_elemental.common.glyphs.EffectLifeLink;
import alexthw.ars_elemental.common.glyphs.EffectNullify;
import alexthw.ars_elemental.common.glyphs.EffectPhantom;
import alexthw.ars_elemental.common.glyphs.EffectSpark;
import alexthw.ars_elemental.common.glyphs.EffectSpike;
import alexthw.ars_elemental.common.glyphs.EffectSpores;
import alexthw.ars_elemental.common.glyphs.EffectWaterGrave;
import alexthw.ars_elemental.common.glyphs.MethodArcProjectile;
import alexthw.ars_elemental.common.glyphs.MethodHomingProjectile;
import alexthw.ars_elemental.common.glyphs.PropagatorArc;
import alexthw.ars_elemental.common.glyphs.PropagatorHoming;
import alexthw.ars_elemental.common.glyphs.filters.AerialFilter;
import alexthw.ars_elemental.common.glyphs.filters.AquaticFilter;
import alexthw.ars_elemental.common.glyphs.filters.FieryFilter;
import alexthw.ars_elemental.common.glyphs.filters.InsectFilter;
import alexthw.ars_elemental.common.glyphs.filters.SummonFilter;
import alexthw.ars_elemental.common.glyphs.filters.UndeadFilter;
import alexthw.ars_elemental.common.items.armor.ArmorSet;
import alexthw.ars_elemental.common.items.armor.ShockPerk;
import alexthw.ars_elemental.common.items.armor.SporePerk;
import alexthw.ars_elemental.common.items.armor.SummonPerk;
import alexthw.ars_elemental.common.rituals.AttractionRitual;
import alexthw.ars_elemental.common.rituals.DetectionRitual;
import alexthw.ars_elemental.common.rituals.RepulsionRitual;
import alexthw.ars_elemental.common.rituals.SquirrelRitual;
import alexthw.ars_elemental.common.rituals.TeslaRitual;
import alexthw.ars_elemental.common.rituals.forest.ArchwoodForestRitual;
import alexthw.ars_elemental.common.rituals.forest.ArchwoodForestationRitual;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.registry.ModParticles;
import alexthw.ars_elemental.registry.ModRegistry;
import com.alexthw.sauce.api.item.IElementalArmor;
import com.alexthw.sauce.registry.SauceTags;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleTypeProperty;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.LingerTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.SimpleParticleTimelineType;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.api.registry.FamiliarRegistry;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ITurretBehavior;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.RotatingSpellTurret;
import com.hollingsworth.arsnouveau.common.block.tile.RotatingTurretTile;
import com.hollingsworth.arsnouveau.common.entity.EntityHomingProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.light.LightManager;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBlink;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCut;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFirework;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGlide;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGravity;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHeal;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHex;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectKnockback;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLaunch;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLeap;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPull;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonUndead;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonVex;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWindshear;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWither;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class ArsNouveauRegistry {
    public static final List<AbstractSpellPart> registeredSpells = new ArrayList<AbstractSpellPart>();
    @Deprecated
    public static final DocAssets.BlitInfo ANIMA_ICON = new DocAssets.BlitInfo(ArsNouveau.prefix((String)"textures/gui/documentation/doc_icon_anima.png"), 10, 10);
    public static final DeferredHolder<IParticleTimelineType<?>, IParticleTimelineType<LingerTimeline>> GRAVITY_TIMELINE = ParticleTimelineRegistry.TIMELINE_DF.register("gravity", () -> new SimpleParticleTimelineType((AbstractSpellPart)EffectGravity.INSTANCE, LingerTimeline.CODEC, LingerTimeline.STREAM_CODEC, LingerTimeline::new));
    public static ArmorSet[] medium_armors = new ArmorSet[]{ModItems.AIR_ARMOR, ModItems.FIRE_ARMOR, ModItems.EARTH_ARMOR, ModItems.WATER_ARMOR};
    public static ArmorSet[] heavy_armors = new ArmorSet[]{ModItems.AIR_ARMOR_H, ModItems.FIRE_ARMOR_H, ModItems.EARTH_ARMOR_H, ModItems.WATER_ARMOR_H};
    public static ArmorSet[] light_armors = new ArmorSet[]{ModItems.AIR_ARMOR_L, ModItems.FIRE_ARMOR_L, ModItems.EARTH_ARMOR_L, ModItems.WATER_ARMOR_L};

    public static void init() {
        ArsNouveauRegistry.registerGlyphs();
        ArsNouveauRegistry.registerRituals();
        ArsNouveauRegistry.registerFamiliars();
        ArsNouveauRegistry.registerPerks();
        ArsNouveauRegistry.linkDamageResistances();
    }

    private static void registerCasters() {
        SpellCasterRegistry.register((ItemLike)((ItemLike)ModItems.SPELL_HORN.get()), stack -> (AbstractCaster)stack.get((DataComponentType)DataComponentRegistry.SPELL_CASTER.get()));
        SpellCasterRegistry.register((ItemLike)((ItemLike)ModItems.AIR_CTOME.get()), stack -> (AbstractCaster)stack.get((DataComponentType)com.alexthw.sauce.registry.ModRegistry.E_TOME_CASTER.get()));
        SpellCasterRegistry.register((ItemLike)((ItemLike)ModItems.FIRE_CTOME.get()), stack -> (AbstractCaster)stack.get((DataComponentType)com.alexthw.sauce.registry.ModRegistry.E_TOME_CASTER.get()));
        SpellCasterRegistry.register((ItemLike)((ItemLike)ModItems.EARTH_CTOME.get()), stack -> (AbstractCaster)stack.get((DataComponentType)com.alexthw.sauce.registry.ModRegistry.E_TOME_CASTER.get()));
        SpellCasterRegistry.register((ItemLike)((ItemLike)ModItems.WATER_CTOME.get()), stack -> (AbstractCaster)stack.get((DataComponentType)com.alexthw.sauce.registry.ModRegistry.E_TOME_CASTER.get()));
        SpellCasterRegistry.register((ItemLike)((ItemLike)ModItems.NECRO_CTOME.get()), stack -> (AbstractCaster)stack.get((DataComponentType)com.alexthw.sauce.registry.ModRegistry.E_TOME_CASTER.get()));
        SpellCasterRegistry.register((ItemLike)((ItemLike)ModItems.SHAPERS_CTOME.get()), stack -> (AbstractCaster)stack.get((DataComponentType)com.alexthw.sauce.registry.ModRegistry.E_TOME_CASTER.get()));
        SpellCasterRegistry.register((ItemLike)((ItemLike)ModItems.CHAIN_LENS.get()), stack -> (AbstractCaster)stack.get((Supplier)DataComponentRegistry.SPELL_CASTER));
    }

    private static void linkDamageResistances() {
        IElementalArmor.damageResistances.put(SpellSchools.ELEMENTAL_FIRE, SauceTags.FIRE_DAMAGE);
        IElementalArmor.damageResistances.put(SpellSchools.ELEMENTAL_AIR, SauceTags.AIR_DAMAGE);
        IElementalArmor.damageResistances.put(SpellSchools.ELEMENTAL_EARTH, SauceTags.EARTH_DAMAGE);
        IElementalArmor.damageResistances.put(SpellSchools.ELEMENTAL_WATER, SauceTags.WATER_DAMAGE);
    }

    public static void registerGlyphs() {
        ArsNouveauRegistry.register((AbstractSpellPart)EffectWaterGrave.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectBubbleShield.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectConjureTerrain.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectCharm.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectPhantom.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectLifeLink.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectSpores.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectDischarge.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectEnvenom.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectSpike.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectSpark.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectConflagrate.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)MethodHomingProjectile.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)MethodArcProjectile.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)PropagatorHoming.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)PropagatorArc.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)AquaticFilter.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)AquaticFilter.NOT_INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)FieryFilter.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)FieryFilter.NOT_INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)AerialFilter.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)AerialFilter.NOT_INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)InsectFilter.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)InsectFilter.NOT_INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)UndeadFilter.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)UndeadFilter.NOT_INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)SummonFilter.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)SummonFilter.NOT_INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectNullify.INSTANCE);
    }

    public static void registerRitual(AbstractRitual ritual) {
        RitualRegistry.registerRitual((AbstractRitual)ritual);
    }

    public static void addSchool(AbstractSpellPart part, SpellSchool school) {
        part.spellSchools.add(school);
        school.addSpellPart(part);
    }

    public static void register(AbstractSpellPart spellPart) {
        GlyphRegistry.registerSpell((AbstractSpellPart)spellPart);
        registeredSpells.add(spellPart);
    }

    public static void registerFamiliars() {
        FamiliarRegistry.registerFamiliar((AbstractFamiliarHolder)new MermaidHolder());
        FamiliarRegistry.registerFamiliar((AbstractFamiliarHolder)new FirenandoHolder());
        FamiliarRegistry.registerFamiliar((AbstractFamiliarHolder)new FlashjackHolder());
    }

    public static void registerPerks() {
        PerkRegistry.registerPerk((IPerk)SporePerk.INSTANCE);
        PerkRegistry.registerPerk((IPerk)ShockPerk.INSTANCE);
        PerkRegistry.registerPerk((IPerk)SummonPerk.INSTANCE);
    }

    private static void addPerkSlots() {
        for (ArmorSet set : medium_armors) {
            PerkRegistry.registerPerkProvider((ItemLike)set.getHat(), ArsNouveauRegistry.makePerkList(Arrays.asList(PerkSlot.ONE, PerkSlot.TWO, PerkSlot.THREE)));
            PerkRegistry.registerPerkProvider((ItemLike)set.getChest(), ArsNouveauRegistry.makePerkList(Arrays.asList(PerkSlot.ONE, PerkSlot.TWO, PerkSlot.THREE)));
            PerkRegistry.registerPerkProvider((ItemLike)set.getLegs(), ArsNouveauRegistry.makePerkList(Arrays.asList(PerkSlot.ONE, PerkSlot.TWO, PerkSlot.THREE)));
            PerkRegistry.registerPerkProvider((ItemLike)set.getBoots(), ArsNouveauRegistry.makePerkList(Arrays.asList(PerkSlot.ONE, PerkSlot.TWO, PerkSlot.THREE)));
        }
        for (ArmorSet set : heavy_armors) {
            PerkRegistry.registerPerkProvider((ItemLike)set.getHat(), ArsNouveauRegistry.makePerkList(Arrays.asList(PerkSlot.ONE, PerkSlot.TWO, PerkSlot.TWO)));
            PerkRegistry.registerPerkProvider((ItemLike)set.getChest(), ArsNouveauRegistry.makePerkList(Arrays.asList(PerkSlot.ONE, PerkSlot.TWO, PerkSlot.THREE)));
            PerkRegistry.registerPerkProvider((ItemLike)set.getLegs(), ArsNouveauRegistry.makePerkList(Arrays.asList(PerkSlot.ONE, PerkSlot.TWO, PerkSlot.THREE)));
            PerkRegistry.registerPerkProvider((ItemLike)set.getBoots(), ArsNouveauRegistry.makePerkList(Arrays.asList(PerkSlot.ONE, PerkSlot.TWO, PerkSlot.TWO)));
        }
        for (ArmorSet set : light_armors) {
            PerkRegistry.registerPerkProvider((ItemLike)set.getHat(), ArsNouveauRegistry.makePerkList(Arrays.asList(PerkSlot.ONE, PerkSlot.TWO, PerkSlot.THREE)));
            PerkRegistry.registerPerkProvider((ItemLike)set.getChest(), ArsNouveauRegistry.makePerkList(Arrays.asList(PerkSlot.TWO, PerkSlot.TWO, PerkSlot.THREE)));
            PerkRegistry.registerPerkProvider((ItemLike)set.getLegs(), ArsNouveauRegistry.makePerkList(Arrays.asList(PerkSlot.TWO, PerkSlot.TWO, PerkSlot.THREE)));
            PerkRegistry.registerPerkProvider((ItemLike)set.getBoots(), ArsNouveauRegistry.makePerkList(Arrays.asList(PerkSlot.ONE, PerkSlot.TWO, PerkSlot.THREE)));
        }
    }

    @NotNull
    private static List<List<PerkSlot>> makePerkList(List<PerkSlot> perkSlots) {
        return List.of(perkSlots, perkSlots, perkSlots, perkSlots);
    }

    public static void addLights() {
        Config.ITEM_LIGHTMAP.put(ModItems.FLASHING_POD.getId(), 14);
        LightManager.register((EntityType)((EntityType)ModEntities.FIRENANDO_ENTITY.get()), p -> {
            if (p.level().getBrightness(LightLayer.BLOCK, p.blockPosition()) < 6) {
                return 10;
            }
            return 0;
        });
        LightManager.register((EntityType)((EntityType)ModEntities.FIRENANDO_FAMILIAR.get()), p -> {
            if (p.level().getBrightness(LightLayer.BLOCK, p.blockPosition()) < 6) {
                return 10;
            }
            return 0;
        });
    }

    public static void postInit() {
        ArsNouveauRegistry.registerCasters();
        ArsNouveauRegistry.addSchool((AbstractSpellPart)EffectHeal.INSTANCE, SpellSchools.NECROMANCY);
        ArsNouveauRegistry.addSchool((AbstractSpellPart)EffectSummonVex.INSTANCE, SpellSchools.NECROMANCY);
        ArsNouveauRegistry.addSchool((AbstractSpellPart)EffectWither.INSTANCE, SpellSchools.NECROMANCY);
        ArsNouveauRegistry.addSchool((AbstractSpellPart)EffectHex.INSTANCE, SpellSchools.NECROMANCY);
        ArsNouveauRegistry.addSchool((AbstractSpellPart)EffectLifeLink.INSTANCE, SpellSchools.NECROMANCY);
        ArsNouveauRegistry.addSchool((AbstractSpellPart)EffectCharm.INSTANCE, SpellSchools.NECROMANCY);
        ArsNouveauRegistry.addSchool((AbstractSpellPart)EffectSummonUndead.INSTANCE, SpellSchools.NECROMANCY);
        ArsNouveauRegistry.addSchool((AbstractSpellPart)EffectCut.INSTANCE, SpellSchools.ELEMENTAL_AIR);
        EffectFirework.INSTANCE.compatibleAugments.add(AugmentDampen.INSTANCE);
        EffectLaunch.INSTANCE.compatibleAugments.add(AugmentExtendTime.INSTANCE);
        EffectLaunch.INSTANCE.compatibleAugments.add(AugmentDurationDown.INSTANCE);
        EffectGravity.INSTANCE.compatibleAugments.add(AugmentSensitive.INSTANCE);
        EffectWindshear.INSTANCE.compatibleAugments.add(AugmentFortune.INSTANCE);
        ArsNouveauRegistry.addLights();
        ArsNouveauRegistry.addPerkSlots();
        ArsNouveauAPI.getInstance().getEnchantingRecipeTypes().add((RecipeType)ModRegistry.NETHERITE_UP.get());
        FirenandoFamiliar.projectileGlyphs.addAll(List.of(MethodArcProjectile.INSTANCE, MethodHomingProjectile.INSTANCE, MethodProjectile.INSTANCE, PropagatorHoming.INSTANCE, PropagatorArc.INSTANCE));
        FlashjackFamiliar.movementGlyphs.addAll(List.of(EffectLeap.INSTANCE, EffectLaunch.INSTANCE, EffectPull.INSTANCE, EffectKnockback.INSTANCE, EffectBlink.INSTANCE, EffectGlide.INSTANCE));
        ParticleTypeProperty.addType((ParticleTypeProperty.ParticleData)new ParticleTypeProperty.ParticleData((ParticleType)ModParticles.SPARK_2.get(), true));
        ParticleTypeProperty.addType((ParticleTypeProperty.ParticleData)new ParticleTypeProperty.ParticleData((ParticleType)ModParticles.VENOM_2.get(), true));
    }

    public static void registerRituals() {
        ArsNouveauRegistry.registerRitual(new SquirrelRitual());
        ArsNouveauRegistry.registerRitual(new TeslaRitual());
        ArsNouveauRegistry.registerRitual(new DetectionRitual());
        ArsNouveauRegistry.registerRitual(new RepulsionRitual());
        ArsNouveauRegistry.registerRitual(new AttractionRitual());
        ArsNouveauRegistry.registerRitual((AbstractRitual)new ArchwoodForestRitual());
        ArsNouveauRegistry.registerRitual((AbstractRitual)new ArchwoodForestationRitual());
    }

    static {
        RotatingSpellTurret.ROT_TURRET_BEHAVIOR_MAP.put(MethodHomingProjectile.INSTANCE, new ITurretBehavior(){

            public void onCast(SpellResolver resolver, ServerLevel world, BlockPos pos, Player fakePlayer, Position position, Direction direction) {
                EntityHomingProjectileSpell spell = new EntityHomingProjectileSpell((Level)world, resolver);
                SpellStats stats = resolver.getCastStats();
                spell.setOwner((Entity)fakePlayer);
                spell.setPos(position.x(), position.y(), position.z());
                spell.setIgnored(MethodHomingProjectile.basicIgnores((LivingEntity)fakePlayer, resolver.spell.getAugments(0, null).contains(AugmentSensitive.INSTANCE), resolver.spell));
                float velocity = MethodHomingProjectile.getProjectileSpeed(stats);
                BlockEntity blockEntity = world.getBlockEntity(pos);
                if (blockEntity instanceof RotatingTurretTile) {
                    RotatingTurretTile rotatingTurretTile = (RotatingTurretTile)blockEntity;
                    Vec3 vec3d = rotatingTurretTile.getShootAngle().normalize();
                    spell.shoot(vec3d.x(), vec3d.y(), vec3d.z(), velocity, 0.0f);
                }
                world.addFreshEntity((Entity)spell);
            }
        });
        RotatingSpellTurret.ROT_TURRET_BEHAVIOR_MAP.put(MethodArcProjectile.INSTANCE, new ITurretBehavior(){

            public void onCast(SpellResolver resolver, ServerLevel world, BlockPos pos, Player fakePlayer, Position position, Direction direction) {
                EntityProjectileSpell spell = new EntityProjectileSpell((Level)world, resolver);
                SpellStats stats = resolver.getCastStats();
                spell.setGravity(true);
                spell.setOwner((Entity)fakePlayer);
                spell.setPos(position.x(), position.y(), position.z());
                float velocity = MethodArcProjectile.getProjectileSpeed(stats);
                BlockEntity blockEntity = world.getBlockEntity(pos);
                if (blockEntity instanceof RotatingTurretTile) {
                    RotatingTurretTile rotatingTurretTile = (RotatingTurretTile)blockEntity;
                    Vec3 vec3d = rotatingTurretTile.getShootAngle().normalize();
                    spell.shoot(vec3d.x(), vec3d.y(), vec3d.z(), velocity, 0.0f);
                }
                world.addFreshEntity((Entity)spell);
            }
        });
        BasicSpellTurret.TURRET_BEHAVIOR_MAP.put(MethodHomingProjectile.INSTANCE, new ITurretBehavior(){

            public void onCast(SpellResolver resolver, ServerLevel world, BlockPos pos, Player fakePlayer, Position position, Direction direction) {
                EntityHomingProjectileSpell spell = new EntityHomingProjectileSpell((Level)world, resolver);
                SpellStats stats = resolver.getCastStats();
                float velocity = MethodHomingProjectile.getProjectileSpeed(stats);
                spell.setOwner((Entity)fakePlayer);
                spell.setPos(position.x(), position.y(), position.z());
                spell.setIgnored(MethodHomingProjectile.basicIgnores((LivingEntity)fakePlayer, resolver.spell.getAugments(0, null).contains(AugmentSensitive.INSTANCE), resolver.spell));
                spell.shoot((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ(), velocity, 0.0f);
                world.addFreshEntity((Entity)spell);
            }
        });
        BasicSpellTurret.TURRET_BEHAVIOR_MAP.put(MethodArcProjectile.INSTANCE, new ITurretBehavior(){

            public void onCast(SpellResolver resolver, ServerLevel world, BlockPos pos, Player fakePlayer, Position position, Direction direction) {
                EntityProjectileSpell spell = new EntityProjectileSpell((Level)world, resolver);
                SpellStats stats = resolver.getCastStats();
                float velocity = MethodArcProjectile.getProjectileSpeed(stats);
                spell.setGravity(true);
                spell.setOwner((Entity)fakePlayer);
                spell.setPos(position.x(), position.y(), position.z());
                spell.shoot((double)direction.getStepX(), (double)((float)direction.getStepY() + 0.25f), (double)direction.getStepZ(), velocity, 0.0f);
                world.addFreshEntity((Entity)spell);
            }
        });
    }
}

