/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks.prism;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.block.SpellPrismBlock;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SpellMirror
extends SpellPrismBlock {
    static final VoxelShape base = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    static final VoxelShape south = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    static final VoxelShape floor = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    static final VoxelShape ceiling = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    static final VoxelShape east = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    static final VoxelShape west = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SpellMirror(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        BlockState blockstate = pLevel.getBlockState(pPos.relative(direction.getOpposite()));
        return blockstate.isFaceSturdy((BlockGetter)pLevel, pPos, direction);
    }

    @NotNull
    public BlockState updateShape(BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pNeighborPos) {
        return pDirection == ((Direction)pState.getValue((Property)FACING)).getOpposite() && !this.canSurvive(pState, (LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    public void onHit(ServerLevel world, BlockPos pos, EntityProjectileSpell spell) {
        Direction direction = (Direction)world.getBlockState(pos).getValue((Property)FACING);
        float factor = -0.9f;
        ++spell.prismRedirect;
        if (spell.prismRedirect >= 3) {
            ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)((PlayerTrigger)ANCriteriaTriggers.PRISMATIC.get()), (ServerLevel)world, (BlockPos)pos, (int)10);
        }
        if (spell.resolver() == null) {
            spell.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        switch (direction) {
            case UP: 
            case DOWN: {
                Vec3 vel = spell.getDeltaMovement();
                spell.setDeltaMovement(vel.x(), (double)factor * vel.y(), vel.z());
                break;
            }
            case EAST: 
            case WEST: {
                Vec3 vel = spell.getDeltaMovement();
                spell.setDeltaMovement((double)factor * vel.x(), vel.y(), vel.z());
                break;
            }
            case NORTH: 
            case SOUTH: {
                Vec3 vel = spell.getDeltaMovement();
                spell.setDeltaMovement(vel.x(), vel.y(), (double)factor * vel.z());
            }
        }
        BlockUtil.updateObservers((Level)world, (BlockPos)pos);
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.EAST -> east;
            case Direction.WEST -> west;
            case Direction.SOUTH -> south;
            case Direction.NORTH -> base;
            case Direction.DOWN -> ceiling;
            case Direction.UP -> floor;
        };
    }
}

